/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.frame.endportal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.config.FrameSizes;
import com.therandomlabs.randomportals.api.event.EndPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.RequiredCorner;
import com.therandomlabs.randomportals.api.frame.detector.BasicVerticalFrameDetector;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.block.RPOBlocks;
import com.therandomlabs.randomportals.frame.endportal.LateralEndPortalDetector;
import com.therandomlabs.randomportals.frame.endportal.VerticalInwardsEndPortalDetector;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.util.EnumMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class EndPortalFrames {
    public static final Function<FrameType, FrameSize> NORMAL = FrameSize.fromJSONs("end_portal/normal");
    public static final Function<FrameType, FrameSize> LATERAL_WITH_VERTICAL_FRAMES_SIZE = type -> FrameSizes.get("end_portal", "lateral_with_vertical_frames");
    public static final Function<FrameType, FrameSize> UPSIDE_DOWN_SIZE = type -> FrameSizes.get("end_portal", "upside_down");
    public static final Function<FrameType, FrameSize> VERTICAL_INWARDS_FACING_SIZE = FrameSize.fromJSONs("end_portal/inwards_facing");
    public static final ImmutableList<Function<FrameType, FrameSize>> SIZES = ImmutableList.of(NORMAL, LATERAL_WITH_VERTICAL_FRAMES_SIZE, UPSIDE_DOWN_SIZE, VERTICAL_INWARDS_FACING_SIZE);
    public static final FrameDetector LATERAL = new LateralEndPortalDetector(Blocks.field_150378_br, NORMAL);
    public static final FrameDetector LATERAL_WITH_VERTICAL_FRAMES = new LateralEndPortalDetector((Block)RPOBlocks.vertical_end_portal_frame, LATERAL_WITH_VERTICAL_FRAMES_SIZE);
    public static final FrameDetector UPSIDE_DOWN = new LateralEndPortalDetector((Block)RPOBlocks.upside_down_end_portal_frame, UPSIDE_DOWN_SIZE);
    public static final ImmutableMap<EnumFacing, FrameDetector> VERTICAL;
    public static final FrameDetector VERTICAL_INWARDS_FACING;

    private EndPortalFrames() {
    }

    public static Frame activate(World world, BlockPos framePos) {
        IBlockState state = world.func_180495_p(framePos);
        Block block = state.func_177230_c();
        world.func_184133_a(null, framePos, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f);
        Frame frame = block == Blocks.field_150378_br ? LATERAL.detect(world, framePos) : (block == RPOBlocks.vertical_end_portal_frame ? LATERAL_WITH_VERTICAL_FRAMES.detect(world, framePos) : UPSIDE_DOWN.detect(world, framePos));
        if (frame != null && !frame.isCorner(framePos)) {
            EndPortalEvent.Activate event = new EndPortalEvent.Activate(world, frame, framePos);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return null;
            }
            IBlockState portalState = block == RPOBlocks.upside_down_end_portal_frame ? RPOBlocks.upside_down_end_portal.func_176223_P() : Blocks.field_150384_bq.func_176223_P();
            for (BlockPos innerPos : frame.getInnerBlockPositions()) {
                world.func_180501_a(innerPos, portalState, 2);
            }
            world.func_175669_a(1038, frame.getTopLeft().func_177982_a(1, 0, 1), 0);
            RPOSavedData.get(world).addEndPortal(frame);
            return frame;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        EnumFacing portalFacing = null;
        if (block == RPOBlocks.vertical_end_portal_frame) {
            frame = ((FrameDetector)VERTICAL.get((Object)facing)).detect(world, framePos);
            portalFacing = facing;
        }
        if (frame == null && (frame = VERTICAL_INWARDS_FACING.detect(world, framePos)) != null) {
            EnumFacing enumFacing = portalFacing = frame.getType() == FrameType.VERTICAL_X ? EnumFacing.NORTH : EnumFacing.EAST;
        }
        if (frame == null || frame.isCorner(framePos)) {
            return null;
        }
        EndPortalEvent.Activate event = new EndPortalEvent.Activate(world, frame, framePos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        ImmutableList<BlockPos> innerBlockPositions = frame.getInnerBlockPositions();
        IBlockState portalState = RPOBlocks.vertical_end_portal.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)portalFacing);
        for (BlockPos innerPos : innerBlockPositions) {
            world.func_180501_a(innerPos, portalState, 2);
        }
        world.func_175669_a(1038, (BlockPos)innerBlockPositions.get(0), 0);
        RPOSavedData.get(world).addEndPortal(frame);
        return frame;
    }

    public static void registerSizes() {
        FrameSizes.register("end_portal/normal");
        FrameSizes.register("end_portal", "lateral_with_vertical_frames", "upside_down");
        FrameSizes.registerVertical("end_portal/inwards_facing");
    }

    static {
        VERTICAL_INWARDS_FACING = new VerticalInwardsEndPortalDetector();
        EnumMap<EnumFacing, BasicVerticalFrameDetector> vertical = new EnumMap<EnumFacing, BasicVerticalFrameDetector>(EnumFacing.class);
        vertical.put(EnumFacing.NORTH, new BasicVerticalFrameDetector(NORMAL, FrameStatePredicate.of((Predicate<IBlockState>)BlockStateMatcher.func_177638_a((Block)RPOBlocks.vertical_end_portal_frame).func_177637_a((IProperty)BlockEndPortalFrame.field_176507_b, eye -> eye)), RequiredCorner.ANY, EnumFacing.NORTH, frame -> true));
        vertical.put(EnumFacing.EAST, new BasicVerticalFrameDetector(NORMAL, FrameStatePredicate.of((Predicate<IBlockState>)BlockStateMatcher.func_177638_a((Block)RPOBlocks.vertical_end_portal_frame).func_177637_a((IProperty)BlockEndPortalFrame.field_176507_b, eye -> eye)), RequiredCorner.ANY, EnumFacing.EAST, frame -> true));
        vertical.put(EnumFacing.SOUTH, new BasicVerticalFrameDetector(NORMAL, FrameStatePredicate.of((Predicate<IBlockState>)BlockStateMatcher.func_177638_a((Block)RPOBlocks.vertical_end_portal_frame).func_177637_a((IProperty)BlockEndPortalFrame.field_176507_b, eye -> eye)), RequiredCorner.ANY, EnumFacing.SOUTH, frame -> true));
        vertical.put(EnumFacing.WEST, new BasicVerticalFrameDetector(NORMAL, FrameStatePredicate.of((Predicate<IBlockState>)BlockStateMatcher.func_177638_a((Block)RPOBlocks.vertical_end_portal_frame).func_177637_a((IProperty)BlockEndPortalFrame.field_176507_b, eye -> eye)), RequiredCorner.ANY, EnumFacing.WEST, frame -> true));
        VERTICAL = ImmutableMap.copyOf(vertical);
    }
}

