/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.util;

import com.therandomlabs.randomportals.api.frame.FrameType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@FunctionalInterface
public interface FrameStatePredicate {
    public boolean test(World var1, BlockPos var2, IBlockState var3, @Nullable FrameType var4);

    default public boolean test(World world, BlockPos pos, IBlockState state) {
        return this.test(world, pos, state, null);
    }

    default public <T extends Comparable<T>> FrameStatePredicate with(IProperty<T> property, T value) {
        return (world, pos, state, type) -> this.test(world, pos, state, type) && state.func_177229_b(property).equals(value);
    }

    default public <T extends Comparable<T>> FrameStatePredicate where(IProperty<T> property, Predicate<? super T> is) {
        return (world, pos, state, type) -> this.test(world, pos, state, type) && is.test(state.func_177229_b(property));
    }

    public static FrameStatePredicate of(Predicate<IBlockState> predicate) {
        return (world, pos, state, type) -> predicate.test(state);
    }

    public static FrameStatePredicate of(Block block) {
        return (world, pos, state, type) -> state.func_177230_c() == block;
    }

    public static FrameStatePredicate of(Block block, int meta) {
        return (world, pos, state, type) -> state.func_177230_c() == block && (meta == Short.MAX_VALUE || meta == block.func_176201_c(state));
    }

    public static FrameStatePredicate ofBlock(Predicate<Block> predicate) {
        return (world, pos, state, type) -> predicate.test(state.func_177230_c());
    }
}

