/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.netherportal;

import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.netherportal.FunctionType;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;

public final class NetherPortal {
    public static final int NO_FIXED_DESTINATION = Integer.MIN_VALUE;
    private final Frame frame;
    private final World world;
    private Frame receivingFrame;
    private String typeID;
    private FunctionType functionType;
    private int destination;

    public NetherPortal(Frame frame, Frame receivingFrame, PortalType type) {
        this(frame, receivingFrame, type, null, Integer.MIN_VALUE);
    }

    public NetherPortal(Frame frame, Frame receivingFrame, PortalType type, FunctionType functionType, int destination) {
        this.frame = frame;
        this.world = frame.getWorld();
        this.receivingFrame = receivingFrame;
        this.typeID = type.toString();
        this.functionType = functionType == null ? (type.decorative ? FunctionType.DECORATIVE : FunctionType.NORMAL) : functionType;
        this.destination = destination;
    }

    public String toString() {
        return "NetherPortal[frame=" + this.frame + ",receivingFrame=" + this.receivingFrame + ",typeID=" + this.typeID + ",functionType=" + (Object)((Object)this.functionType) + ",destination=" + this.destination + "]";
    }

    @Nonnull
    public Frame getFrame() {
        return this.frame;
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Nullable
    public Frame getReceivingFrame() {
        return this.receivingFrame;
    }

    public void setReceivingFrame(Frame frame) {
        this.receivingFrame = frame;
        RPOSavedData.get(this.world).func_76185_a();
    }

    @Nonnull
    public PortalType getType() {
        PortalType type = PortalTypes.getSpecific(this.typeID);
        this.typeID = type.toString();
        return type;
    }

    @Nonnull
    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionType type) {
        this.functionType = type;
        RPOSavedData.get(this.world).func_76185_a();
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int id) {
        this.destination = id;
    }
}

