/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.frame.detector;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameSide;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.RequiredCorner;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicVerticalFrameDetector
extends FrameDetector {
    private final FrameType defaultType;
    private final Function<FrameType, FrameSize> defaultSize;
    private final FrameStatePredicate blockMatcher;
    private final RequiredCorner requiredCorner;
    private final EnumFacing facing;
    private final Predicate<Frame> framePredicate;

    public BasicVerticalFrameDetector(Function<FrameType, FrameSize> defaultSize, FrameStatePredicate blockMatcher, RequiredCorner requiredCorner, Predicate<Frame> framePredicate) {
        this(defaultSize, blockMatcher, requiredCorner, null, framePredicate);
    }

    public BasicVerticalFrameDetector(Function<FrameType, FrameSize> defaultSize, FrameStatePredicate blockMatcher, RequiredCorner requiredCorner, EnumFacing facing, Predicate<Frame> framePredicate) {
        this.defaultType = facing == null ? FrameType.VERTICAL : (facing.func_176740_k() == EnumFacing.Axis.X ? FrameType.VERTICAL_Z : FrameType.VERTICAL_X);
        this.defaultSize = defaultSize;
        this.blockMatcher = blockMatcher;
        this.requiredCorner = requiredCorner;
        this.facing = facing;
        this.framePredicate = framePredicate;
    }

    @Override
    public FrameType getDefaultType() {
        return this.defaultType;
    }

    @Override
    public Function<FrameType, FrameSize> getDefaultSize() {
        return this.defaultSize;
    }

    @Override
    protected boolean test(World world, FrameType type, BlockPos pos, IBlockState state, FrameSide side, int position) {
        if (position == 1 && this.requiredCorner != RequiredCorner.SAME) {
            return this.requiredCorner.test(world, pos, state);
        }
        if (this.facing == null) {
            return this.blockMatcher.test(world, pos, state);
        }
        return this.blockMatcher.test(world, pos, state) && state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == this.facing;
    }

    @Override
    protected boolean test(Frame frame) {
        return this.framePredicate.test(frame);
    }
}

