/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.frame;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameSide;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Frame {
    private final World world;
    private final DimensionType dimensionType;
    private final FrameType type;
    private final int width;
    private final int height;
    private final int size;
    private final EnumFacing widthDirection;
    private final EnumFacing heightDirection;
    private final BlockPos topLeft;
    private final BlockPos topRight;
    private final BlockPos bottomLeft;
    private final BlockPos bottomRight;
    private ImmutableList<BlockPos> topBlocks;
    private ImmutableList<BlockPos> rightBlocks;
    private ImmutableList<BlockPos> bottomBlocks;
    private ImmutableList<BlockPos> leftBlocks;
    private ImmutableList<BlockPos> frameBlocks;
    private ImmutableList<BlockPos> innerBlocks;

    public Frame(World world, FrameType type, BlockPos topLeft, int width, int height) {
        this(world, type, topLeft, null, null, null, width, height);
    }

    Frame(World world, FrameType type, Map<Integer, FrameDetector.Corner> corners) {
        this(world, type, corners.get((Object)Integer.valueOf((int)0)).pos, corners.get((Object)Integer.valueOf((int)1)).pos, corners.get((Object)Integer.valueOf((int)3)).pos, corners.get((Object)Integer.valueOf((int)2)).pos, corners.get((Object)Integer.valueOf((int)0)).sideLength, corners.get((Object)Integer.valueOf((int)1)).sideLength);
    }

    private Frame(World world, FrameType type, BlockPos topLeft, BlockPos topRight, BlockPos bottomLeft, BlockPos bottomRight, int width, int height) {
        if (width < 3 || height < 3) {
            throw new IllegalArgumentException("Frame cannot be smaller than 3 blocks");
        }
        this.world = world;
        this.dimensionType = world.field_73011_w.func_186058_p();
        this.type = type;
        this.width = width;
        this.height = height;
        this.size = width * height;
        this.widthDirection = type.getWidthDirection();
        this.heightDirection = type.getHeightDirection();
        this.topLeft = topLeft;
        if (topRight == null) {
            this.topRight = topLeft.func_177967_a(this.widthDirection, width - 1);
            this.bottomLeft = topLeft.func_177967_a(this.heightDirection, height - 1);
            this.bottomRight = this.bottomLeft.func_177967_a(this.widthDirection, width - 1);
        } else {
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }
    }

    public int hashCode() {
        return this.topLeft.hashCode() * this.width * this.height * this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)object;
        return this.topLeft.equals((Object)frame.topLeft) && this.width == frame.width && this.height == frame.height && this.type == frame.type;
    }

    public String toString() {
        return "Frame[topLeft=" + this.topLeft + ",topRight=" + this.topRight + ",bottomLeft=" + this.bottomLeft + ",bottomRight=" + this.bottomRight + ",type=" + (Object)((Object)this.type) + "]";
    }

    public World getWorld() {
        return this.world;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public FrameType getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.size;
    }

    public EnumFacing getWidthDirection() {
        return this.widthDirection;
    }

    public EnumFacing getHeightDirection() {
        return this.heightDirection;
    }

    public boolean isCorner(BlockPos pos) {
        return this.topLeft.equals((Object)pos) || this.topRight.equals((Object)pos) || this.bottomLeft.equals((Object)pos) || this.bottomRight.equals((Object)pos);
    }

    public ImmutableList<BlockPos> getCornerBlockPositions() {
        return ImmutableList.of((Object)this.topLeft, (Object)this.topRight, (Object)this.bottomLeft, (Object)this.bottomRight);
    }

    public List<IBlockState> getCornerBlocks() {
        return Lists.newArrayList((Object[])new IBlockState[]{this.world.func_180495_p(this.topLeft), this.world.func_180495_p(this.topRight), this.world.func_180495_p(this.bottomLeft), this.world.func_180495_p(this.bottomRight)});
    }

    public BlockPos getTopLeft() {
        return this.topLeft;
    }

    public BlockPos getTopRight() {
        return this.topRight;
    }

    public BlockPos getBottomLeft() {
        return this.bottomLeft;
    }

    public BlockPos getBottomRight() {
        return this.bottomRight;
    }

    public boolean isTopBlock(BlockPos pos) {
        return this.isBetween(pos, this.topLeft, this.topRight);
    }

    public ImmutableList<BlockPos> getTopBlockPositions() {
        if (this.topBlocks == null) {
            this.topBlocks = this.getPositions(true, false);
        }
        return this.topBlocks;
    }

    public List<IBlockState> getTopBlocks() {
        return this.getTopBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public boolean isRightBlock(BlockPos pos) {
        return this.isBetween(pos, this.topRight, this.bottomRight);
    }

    public ImmutableList<BlockPos> getRightBlockPositions() {
        if (this.rightBlocks == null) {
            this.rightBlocks = this.getPositions(false, true);
        }
        return this.rightBlocks;
    }

    public List<IBlockState> getRightBlocks() {
        return this.getRightBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public boolean isBottomBlock(BlockPos pos) {
        return this.isBetween(pos, this.bottomRight, this.bottomLeft);
    }

    public ImmutableList<BlockPos> getBottomBlockPositions() {
        if (this.bottomBlocks == null) {
            this.bottomBlocks = this.getPositions(true, true);
        }
        return this.bottomBlocks;
    }

    public List<IBlockState> getBottomBlocks() {
        return this.getBottomBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public boolean isLeftBlock(BlockPos pos) {
        return this.isBetween(pos, this.bottomLeft, this.topLeft);
    }

    public ImmutableList<BlockPos> getLeftBlockPositions() {
        if (this.leftBlocks == null) {
            this.leftBlocks = this.getPositions(false, false);
        }
        return this.leftBlocks;
    }

    public List<IBlockState> getLeftBlocks() {
        return this.getLeftBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public boolean isFrameBlock(BlockPos pos) {
        return this.isBetween(pos, this.topLeft, this.bottomRight) && !this.isInnerBlock(pos);
    }

    public ImmutableList<BlockPos> getFrameBlockPositions() {
        if (this.frameBlocks == null) {
            this.getTopBlockPositions();
            this.getRightBlockPositions();
            this.getBottomBlockPositions();
            this.getLeftBlockPositions();
            LinkedHashSet<BlockPos> frameBlocks = new LinkedHashSet<BlockPos>(this.topBlocks.size() + this.rightBlocks.size() + this.bottomBlocks.size() + this.leftBlocks.size() - 4);
            frameBlocks.addAll((Collection<BlockPos>)this.topBlocks);
            frameBlocks.addAll((Collection<BlockPos>)this.rightBlocks);
            frameBlocks.addAll((Collection<BlockPos>)this.bottomBlocks);
            frameBlocks.addAll((Collection<BlockPos>)this.leftBlocks);
            this.frameBlocks = ImmutableList.copyOf(frameBlocks);
        }
        return this.frameBlocks;
    }

    public List<IBlockState> getFrameBlocks() {
        return this.getFrameBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public boolean isInnerBlock(BlockPos pos) {
        return this.isBetween(pos, this.topLeft, this.bottomRight, false);
    }

    public ImmutableList<BlockPos> getInnerBlockPositions() {
        if (this.innerBlocks == null) {
            ArrayList<BlockPos> innerBlocks = new ArrayList<BlockPos>((this.width - 2) * (this.height - 2));
            for (int widthOffset = 1; widthOffset < this.width - 1; ++widthOffset) {
                for (int heightOffset = 1; heightOffset < this.height - 1; ++heightOffset) {
                    innerBlocks.add(this.topLeft.func_177967_a(this.widthDirection, widthOffset).func_177967_a(this.heightDirection, heightOffset));
                }
            }
            this.innerBlocks = ImmutableList.copyOf(innerBlocks);
        }
        return this.innerBlocks;
    }

    public List<IBlockState> getInnerBlocks() {
        return this.getInnerBlockPositions().stream().map(arg_0 -> ((World)this.world).func_180495_p(arg_0)).collect(Collectors.toList());
    }

    public List<BlockPos> getInnerRow(int row) {
        if (row < 1 || row > this.height - 2) {
            throw new IllegalArgumentException(String.format("Invalid row %s for frame with width %s and height %s", row, this.width, this.height));
        }
        return this.getPositions(this.topLeft.func_177972_a(this.widthDirection), this.width - 2, this.widthDirection, row, this.heightDirection);
    }

    public List<BlockPos> getInnerRowFromBottom(int row) {
        return this.getInnerRow(this.height - 1 - row);
    }

    public List<BlockPos> getInnerColumn(int column) {
        if (column < 1 || column > this.width - 2) {
            throw new IllegalArgumentException(String.format("Invalid column %s for frame with width %s and height %s", column, this.width, this.height));
        }
        return this.getPositions(this.topLeft.func_177972_a(this.heightDirection), this.height - 2, this.heightDirection, column, this.widthDirection);
    }

    public List<BlockPos> getInnerColumnFromBottom(int column) {
        return this.getInnerColumn(this.width - 1 - column);
    }

    public FrameSide getSide(BlockPos pos) {
        if (this.isCorner(pos)) {
            return FrameSide.CORNER;
        }
        if (this.isTopBlock(pos)) {
            return FrameSide.TOP;
        }
        if (this.isRightBlock(pos)) {
            return FrameSide.RIGHT;
        }
        if (this.isBottomBlock(pos)) {
            return FrameSide.BOTTOM;
        }
        if (this.isLeftBlock(pos)) {
            return FrameSide.LEFT;
        }
        if (this.isInnerBlock(pos)) {
            return FrameSide.INNER;
        }
        return FrameSide.NONE;
    }

    public boolean contains(BlockPos pos) {
        return this.isBetween(pos, this.topLeft, this.bottomRight);
    }

    public boolean isFacingInwards(BlockPos pos, EnumFacing facing) {
        switch (this.getSide(pos)) {
            case TOP: {
                return facing == this.heightDirection;
            }
            case RIGHT: {
                return facing == this.widthDirection.func_176734_d();
            }
            case BOTTOM: {
                return facing == this.heightDirection.func_176734_d();
            }
            case LEFT: {
                return facing == this.widthDirection;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        for (BlockPos innerPos : this.getInnerBlockPositions()) {
            Block block;
            IBlockState state = this.world.func_180495_p(innerPos);
            if (state.func_185904_a() == Material.field_151581_o || (block = state.func_177230_c()).func_176200_f((IBlockAccess)this.world, innerPos)) continue;
            return false;
        }
        return true;
    }

    public boolean testInnerBlocks(FrameStatePredicate predicate) {
        for (BlockPos innerPos : this.getInnerBlockPositions()) {
            if (predicate.test(this.world, innerPos, this.world.func_180495_p(innerPos), this.type)) continue;
            return false;
        }
        return true;
    }

    private boolean isBetween(BlockPos pos, BlockPos corner1, BlockPos corner2) {
        return this.isBetween(pos, corner1, corner2, true);
    }

    private boolean isBetween(BlockPos pos, BlockPos corner1, BlockPos corner2, boolean inclusive) {
        int corner1X = corner1.func_177958_n();
        int corner1Y = corner1.func_177956_o();
        int corner1Z = corner1.func_177952_p();
        int corner2X = corner2.func_177958_n();
        int corner2Y = corner2.func_177956_o();
        int corner2Z = corner2.func_177952_p();
        int minX = Math.min(corner1X, corner2X);
        int minY = Math.min(corner1Y, corner2Y);
        int minZ = Math.min(corner1Z, corner2Z);
        int maxX = Math.max(corner1X, corner2X);
        int maxY = Math.max(corner1Y, corner2Y);
        int maxZ = Math.max(corner1Z, corner2Z);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (inclusive) {
            return x >= minX && y >= minY && z >= minZ && x <= maxX && y <= maxY && z <= maxZ;
        }
        switch (this.type.getAxis()) {
            case X: {
                return x > minX && y > minY && x < maxX && y < maxY && z == minZ;
            }
            case Y: {
                return x > minX && z > minZ && x < maxX && z < maxZ && y == minY;
            }
        }
        return y > minY && z > minZ && y < maxY && z < maxZ && x == minX;
    }

    private ImmutableList<BlockPos> getPositions(boolean width, boolean offsetBoth) {
        if (width) {
            return this.getPositions(this.topLeft, this.width, this.widthDirection, offsetBoth ? this.height - 1 : 0, this.heightDirection);
        }
        return this.getPositions(this.topLeft, this.height, this.heightDirection, offsetBoth ? this.width - 1 : 0, this.widthDirection);
    }

    private ImmutableList<BlockPos> getPositions(BlockPos startingPos, int maxOffset, EnumFacing offsetDirection, int otherOffset, EnumFacing otherOffsetDirection) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(maxOffset);
        BlockPos toOffset = startingPos.func_177967_a(otherOffsetDirection, otherOffset);
        positions.add(toOffset);
        for (int offset = 1; offset < maxOffset; ++offset) {
            positions.add(toOffset.func_177967_a(offsetDirection, offset));
        }
        return ImmutableList.copyOf(positions);
    }
}

