/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randomportals.api.config.ActivationData;
import com.therandomlabs.randomportals.api.config.ColorData;
import com.therandomlabs.randomportals.api.config.DestinationData;
import com.therandomlabs.randomportals.api.config.FrameData;
import com.therandomlabs.randomportals.api.config.PortalTypeGroup;
import com.therandomlabs.randomportals.api.config.TeleportationDelay;
import com.therandomlabs.randomportals.api.frame.Frame;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.DimensionManager;

public final class PortalType {
    public FrameData frame = new FrameData();
    public ActivationData activation = new ActivationData();
    public ColorData color = new ColorData();
    public DestinationData destination = new DestinationData();
    public TeleportationDelay teleportationDelay = new TeleportationDelay();
    public boolean decorative;
    public transient PortalTypeGroup group;
    public transient int dimensionID;

    public String toString() {
        return this.group + ":" + this.dimensionID;
    }

    public void ensureCorrect() {
        this.frame.ensureCorrect();
        this.activation.ensureCorrect();
        this.color.ensureCorrect();
        this.destination.ensureCorrect();
        this.teleportationDelay.ensureCorrect();
    }

    public boolean testActivator(ItemStack stack) {
        return this.activation.test(stack);
    }

    public boolean test(Frame frame) {
        return this.frame.test(frame);
    }

    public int getDestinationDimensionID(int sendingDimensionID) {
        int id;
        int n = id = sendingDimensionID == this.destination.dimensionID ? this.group.defaultDimensionID : this.destination.dimensionID;
        if (DimensionManager.getWorld((int)sendingDimensionID) == null) {
            return sendingDimensionID == -1 ? 0 : -1;
        }
        return id;
    }
}

