/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public final class PortalActivator {
    private static final IForgeRegistry<Item> ITEM_REGISTRY = GameRegistry.findRegistry(Item.class);
    public String registryName;
    public int meta = Short.MAX_VALUE;
    private transient boolean itemRetrieved;
    private transient Item item;
    private transient PortalActivator[] items;

    public PortalActivator() {
    }

    public PortalActivator(Item item, int meta) {
        this.registryName = item.getRegistryName().toString();
        this.meta = meta;
        this.itemRetrieved = true;
        this.item = item;
        this.items = new PortalActivator[]{this};
    }

    public String toString() {
        return "PortalActivator[registryName=" + this.registryName + ",meta=" + this.meta + "]";
    }

    public Item getItem() {
        if (!this.itemRetrieved && !this.registryName.startsWith("ore:")) {
            this.item = (Item)ITEM_REGISTRY.getValue(new ResourceLocation(this.registryName));
            if (this.item != null) {
                this.registryName = this.item.getRegistryName().toString();
            }
            this.itemRetrieved = true;
        }
        return this.item;
    }

    public PortalActivator getActualItem() {
        return this.getItems().length == 0 ? null : this.items[0];
    }

    public boolean isValid() {
        return this.getItems().length != 0;
    }

    public boolean test(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        for (PortalActivator activator : this.getItems()) {
            if (activator.getItem() != item || activator.meta != Short.MAX_VALUE && activator.meta != meta) continue;
            return true;
        }
        return false;
    }

    private PortalActivator[] getItems() {
        if (this.items != null) {
            return this.items;
        }
        if (!this.registryName.startsWith("ore:")) {
            if (this.getItem() == null) {
                this.items = new PortalActivator[0];
                return this.items;
            }
            this.items = new PortalActivator[]{this};
            return this.items;
        }
        NonNullList ores = OreDictionary.getOres((String)this.registryName.substring(4));
        if (ores.isEmpty()) {
            this.items = new PortalActivator[0];
            return this.items;
        }
        ArrayList<PortalActivator> items = new ArrayList<PortalActivator>(ores.size());
        for (ItemStack ore : ores) {
            items.add(new PortalActivator(ore.func_77973_b(), ore.func_77960_j()));
        }
        this.items = items.toArray(new PortalActivator[0]);
        return this.items;
    }
}

