/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals;

import com.therandomlabs.randomportals.RandomPortals;
import com.therandomlabs.randomportals.advancements.RPOCriteriaTriggers;
import com.therandomlabs.randomportals.api.config.FrameSizes;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.config.RPOConfig;
import com.therandomlabs.randomportals.frame.endportal.EndPortalFrames;
import com.therandomlabs.randomportals.handler.EndPortalActivationHandler;
import com.therandomlabs.randomportals.handler.FrameHeadVillagerHandler;
import com.therandomlabs.randomportals.handler.NetherPortalActivationHandler;
import com.therandomlabs.randomportals.handler.NetherPortalFrameBreakHandler;
import com.therandomlabs.randomportals.handler.NetherPortalTeleportHandler;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    public void preInit() {
        if (RandomPortals.INSPIRATIONS_INSTALLED) {
            try {
                this.handleInspirations();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
                RandomPortals.LOGGER.error("Failed to fix Inspirations compatibility", (Throwable)ex);
            }
        }
        ConfigManager.register(RPOConfig.class);
    }

    public void init() {
        RPOConfig.reload();
        if (RandomPortals.MOVINGWORLD_INSTALLED) {
            try {
                this.handleMovingWorld();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                RandomPortals.LOGGER.error("Failed to fix MovingWorld compatibility", (Throwable)ex);
            }
        }
        if (RPOConfig.EndPortals.enabled) {
            MinecraftForge.EVENT_BUS.register(EndPortalActivationHandler.class);
            MinecraftForge.EVENT_BUS.register(FrameHeadVillagerHandler.class);
        }
        if (RPOConfig.NetherPortals.enabled) {
            MinecraftForge.EVENT_BUS.register(NetherPortalTeleportHandler.class);
            MinecraftForge.EVENT_BUS.register(NetherPortalFrameBreakHandler.class);
            MinecraftForge.EVENT_BUS.register(NetherPortalActivationHandler.class);
        }
        EndPortalFrames.registerSizes();
        FrameSizes.reload();
        RPOCriteriaTriggers.register();
    }

    public void postInit() {
        try {
            PortalTypes.reload();
        }
        catch (IOException ex) {
            TRLUtils.crashReport("Error while reloading Nether portal types", ex);
        }
    }

    private void handleInspirations() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> config = Class.forName("knightminer.inspirations.common.Config");
        Field customPortalColor = config.getDeclaredField("customPortalColor");
        customPortalColor.set(null, false);
    }

    private void handleMovingWorld() throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> movingWorldMod = Class.forName("com.elytradev.movingworld.MovingWorldMod");
        Object movingWorldInstance = movingWorldMod.getDeclaredField("INSTANCE").get(null);
        Object localConfigInstance = movingWorldMod.getDeclaredMethod("getLocalConfig", new Class[0]).invoke(movingWorldInstance, new Object[0]);
        Class<?> mainConfig = localConfigInstance.getClass();
        Object sharedConfigInstance = mainConfig.getDeclaredMethod("getShared", new Class[0]).invoke(localConfigInstance, new Object[0]);
        Class<?> sharedConfig = sharedConfigInstance.getClass();
        Object config = sharedConfig.getDeclaredField("assemblePriorityConfig").get(sharedConfigInstance);
        Class<?> clazz = config.getClass();
        Field defaultHighPriorityAssemblyBlocks = clazz.getDeclaredField("defaultHighPriorityAssemblyBlocks");
        Field defaultLowPriorityDisassemblyBlocks = clazz.getDeclaredField("defaultLowPriorityDisassemblyBlocks");
        defaultHighPriorityAssemblyBlocks.setAccessible(true);
        defaultLowPriorityDisassemblyBlocks.setAccessible(true);
        Block[] blocks1 = (Block[])defaultHighPriorityAssemblyBlocks.get(config);
        Block[] blocks2 = (Block[])defaultLowPriorityDisassemblyBlocks.get(config);
        this.replace(blocks1);
        this.replace(blocks2);
    }

    private void replace(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            String registryName = blocks[i].getRegistryName().toString();
            if (registryName.equals("minecraft:portal")) {
                blocks[i] = Blocks.field_150427_aO;
                continue;
            }
            if (!registryName.equals("minecraft:end_portal")) continue;
            blocks[i] = Blocks.field_150384_bq;
        }
    }
}

