/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.tile;

import com.codetaylor.mc.advancedmortars.lib.util.StackUtil;
import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.reference.EnumMortarType;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.IMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.MortarDelegate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityMortarBase
extends TileEntity
implements IMortar {
    protected byte typeId;
    protected int durability;
    protected IMortar mortarDelegate;
    protected int craftingProgress;

    public TileEntityMortarBase(EnumMortarType type) {
        this.typeId = (byte)type.getMeta();
        this.mortarDelegate = new MortarDelegate(type, this::func_70296_d);
    }

    public int getDurability() {
        return this.durability;
    }

    public int getMaxDurability() {
        return ModuleMortar.Blocks.MORTAR.getMaxDurability(EnumMortarType.fromMeta(this.typeId));
    }

    public int getCraftingProgress() {
        return this.craftingProgress;
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.mortarDelegate.getItemStackHandler();
    }

    @Override
    public boolean canInsertItem(ItemStack itemStack) {
        return this.mortarDelegate.canInsertItem(itemStack);
    }

    @Override
    public void insertItem(ItemStack itemStack) {
        this.mortarDelegate.insertItem(itemStack);
    }

    @Override
    public ItemStack removeItem() {
        this.resetCraftingProgress();
        return this.mortarDelegate.removeItem();
    }

    @Override
    public int getOccupiedSlotCount() {
        return this.mortarDelegate.getOccupiedSlotCount();
    }

    @Override
    public boolean isEmpty() {
        return this.mortarDelegate.isEmpty();
    }

    @Override
    public void dropAllItems(World world, BlockPos pos) {
        this.mortarDelegate.dropAllItems(world, pos);
    }

    private void resetCraftingProgress() {
        this.craftingProgress = 0;
        this.func_70296_d();
    }

    public boolean incrementCraftingProgress() {
        IRecipeMortar recipe = this.getRecipe();
        if (recipe != null) {
            ++this.craftingProgress;
            this.func_70296_d();
            float volume = 0.05f;
            if ((double)this.field_145850_b.field_73012_v.nextFloat() < 0.25) {
                volume = 0.25f;
            }
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.125, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187587_bZ, SoundCategory.BLOCKS, volume, 1.0f);
            if (this.craftingProgress >= recipe.getDuration()) {
                this.resetCraftingProgress();
                ItemStack[] outputs = this.doCrafting();
                StackUtil.spawnStackOnTop(this.field_145850_b, outputs[0], this.field_174879_c);
                if (outputs.length > 1 && this.field_145850_b.field_73012_v.nextFloat() < recipe.getSecondaryOutputChance()) {
                    StackUtil.spawnStackOnTop(this.field_145850_b, outputs[1], this.field_174879_c);
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.125, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25f, 1.0f);
                int maxDurability = this.getMaxDurability();
                if (maxDurability > 0) {
                    this.incrementAndCheckDurability(maxDurability);
                }
            }
            return true;
        }
        return false;
    }

    private void incrementAndCheckDurability(int maxDurability) {
        ++this.durability;
        if (this.durability >= maxDurability) {
            this.destroy(true, true, SoundEvents.field_187635_cQ);
        }
    }

    public ItemStack destroy(boolean dropAllItems, boolean spawnParticles, @Nullable SoundEvent soundEvent) {
        if (dropAllItems) {
            this.dropAllItems(this.field_145850_b, this.field_174879_c);
        }
        if (spawnParticles) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.BLOCK_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.125, (double)this.field_174879_c.func_177952_p() + 0.5, 50, 0.0, 0.0, 0.0, 2.0, new int[]{Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c))});
        }
        if (soundEvent != null) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.125, (double)this.field_174879_c.func_177952_p() + 0.5, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        return this.getAsItemStack();
    }

    public ItemStack getAsItemStack() {
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)ModuleMortar.Blocks.MORTAR), 1, (int)this.typeId);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound teCompound = new NBTTagCompound();
        this.func_189515_b(teCompound);
        compound.func_74782_a("BlockEntityTag", (NBTBase)teCompound);
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    @Override
    public ItemStack[] doCrafting() {
        return this.mortarDelegate.doCrafting();
    }

    @Override
    public IRecipeMortar getRecipe() {
        return this.mortarDelegate.getRecipe();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74774_a("type", this.typeId);
        compound.func_74768_a("durability", this.durability);
        compound.func_74782_a("mortarDelegate", (NBTBase)this.mortarDelegate.serializeNBT());
        compound.func_74768_a("craftingProgress", this.craftingProgress);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.typeId = compound.func_74771_c("type");
        this.durability = compound.func_74762_e("durability");
        this.craftingProgress = compound.func_74762_e("craftingProgress");
        this.mortarDelegate.deserializeNBT(compound.func_74775_l("mortarDelegate"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

