/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.render;

import com.codetaylor.mc.advancedmortars.lib.gui.GuiHelper;
import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleConfig;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.IRecipeMortar;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarBase;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.items.ItemStackHandler;

public class HUDRender {
    private static final ResourceLocation TEXTURE = new ResourceLocation("advancedmortars", "textures/gui/hud_mortar.png");
    public static final int TEXTURE_WIDTH = 44;
    public static final int TEXTURE_HEIGHT = 55;

    public static void render(ScaledResolution resolution) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r != null && minecraft.field_71462_r instanceof GuiChat) {
            return;
        }
        RayTraceResult rayTraceResult = minecraft.field_71476_x;
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockPos = rayTraceResult.func_178782_a();
        if (blockPos.func_177956_o() < 0 || blockPos.func_177956_o() >= 256) {
            return;
        }
        TileEntity tileEntity = minecraft.field_71441_e.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityMortarBase) {
            int y;
            int y2;
            int x;
            ItemStack stackInSlot;
            ItemStackHandler itemStackHandler = ((TileEntityMortarBase)tileEntity).getItemStackHandler();
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            for (int i = 0; i < itemStackHandler.getSlots() && !(stackInSlot = itemStackHandler.getStackInSlot(i)).func_190926_b(); ++i) {
                itemStackList.add(stackInSlot);
            }
            float angle = (float)(Math.PI * 2 / (double)itemStackList.size());
            double radius = 32.0;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74520_c();
            for (int i = 0; i < itemStackList.size(); ++i) {
                ItemStack itemStack = (ItemStack)itemStackList.get(i);
                x = (int)((double)MathHelper.func_76134_b((float)(angle * (float)i)) * radius + (double)(resolution.func_78326_a() / 2)) - 8;
                y2 = (int)((double)MathHelper.func_76126_a((float)(angle * (float)i)) * radius + (double)(resolution.func_78328_b() / 2)) - 8;
                minecraft.func_175599_af().func_180450_b(itemStack, x, y2);
                minecraft.func_175599_af().func_175030_a(minecraft.field_71466_p, itemStack, x, y2);
            }
            IRecipeMortar recipe = ((TileEntityMortarBase)tileEntity).getRecipe();
            if (recipe != null) {
                ItemStack output = recipe.getOutput();
                x = (int)(radius + (double)(resolution.func_78326_a() / 2)) - 8 + 64;
                y2 = resolution.func_78328_b() / 2 - 8;
                minecraft.func_175599_af().func_180450_b(output, x, y2);
                minecraft.func_175599_af().func_175030_a(minecraft.field_71466_p, output, x, y2);
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            if (recipe != null) {
                int x2 = (int)(radius + (double)(resolution.func_78326_a() / 2)) - 8 + 30;
                y = resolution.func_78328_b() / 2 - 4;
                if (minecraft.field_71439_g.func_184614_ca().func_190926_b() || !ModuleConfig.RECIPES.REQUIRE_EMPTY_HAND_TO_USE) {
                    GuiHelper.drawTexturedRect(minecraft, TEXTURE, x2, y, 8, 10, 100, 10, 35, 44, 55);
                    x2 += 5;
                }
                GuiHelper.drawTexturedRect(minecraft, TEXTURE, x2 + 5, y, 12, 11, 100, 32, 0, 44, 55);
            }
            if (ModuleConfig.CLIENT.DISPLAY_INTERACTION_HINTS) {
                int x3 = resolution.func_78326_a() / 2 - 9 + 18;
                if (!minecraft.field_71439_g.func_184614_ca().func_190926_b() || ((TileEntityMortarBase)tileEntity).isEmpty()) {
                    x3 -= 17;
                }
                y = resolution.func_78328_b() / 2 - 64 - 8;
                GuiHelper.drawTexturedRect(minecraft, TEXTURE, x3, y, 18, 22, 100, 18, 23, 44, 55);
                if (!((TileEntityMortarBase)tileEntity).isEmpty() && minecraft.field_71439_g.func_184614_ca().func_190926_b()) {
                    x3 = resolution.func_78326_a() / 2 - 9 - 18;
                    y = resolution.func_78328_b() / 2 - 64 - 8;
                    GuiHelper.drawTexturedRect(minecraft, TEXTURE, x3, y, 18, 22, 100, 0, 23, 44, 55);
                }
            }
            if (ModuleConfig.CLIENT.DISPLAY_MORTAR_DURABILITY) {
                int x4 = resolution.func_78326_a() / 2 - 7;
                y = resolution.func_78328_b() / 2 - 12;
                GuiHelper.drawTexturedRect(minecraft, TEXTURE, x4, y, 16, 23, 100, 0, 0, 44, 55);
                x4 = resolution.func_78326_a() / 2 - 9;
                y = resolution.func_78328_b() / 2 + 0;
                double durability = (double)((TileEntityMortarBase)tileEntity).getDurability() / (double)((TileEntityMortarBase)tileEntity).getMaxDurability();
                int color = MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - durability)) / 3.0f), (float)1.0f, (float)1.0f);
                GuiHelper.drawDurabilityBar(x4, y, durability, color, 14);
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
        }
    }

    private HUDRender() {
    }
}

