/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.reference;

import com.codetaylor.mc.advancedmortars.lib.spi.IVariant;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;

public enum EnumMortarType implements IVariant
{
    WOOD(0, "wood", Material.field_151575_d, Material.field_151575_d.func_151565_r(), 2.0f, 5.0f, "axe", 0, SoundType.field_185848_a),
    STONE(1, "stone", Material.field_151576_e, Material.field_151576_e.func_151565_r(), 1.5f, 10.0f, "pickaxe", 1, SoundType.field_185851_d),
    IRON(2, "iron", Material.field_151573_f, Material.field_151573_f.func_151565_r(), 5.0f, 10.0f, "pickaxe", 2, SoundType.field_185852_e),
    DIAMOND(3, "diamond", Material.field_151573_f, MapColor.field_151648_G, 5.0f, 10.0f, "pickaxe", 3, SoundType.field_185852_e),
    GOLD(4, "gold", Material.field_151573_f, MapColor.field_151647_F, 2.0f, 5.0f, "pickaxe", 2, SoundType.field_185852_e),
    OBSIDIAN(5, "obsidian", Material.field_151573_f, MapColor.field_151647_F, 5.0f, 10.0f, "pickaxe", 3, SoundType.field_185852_e),
    EMERALD(6, "emerald", Material.field_151573_f, MapColor.field_151647_F, 5.0f, 10.0f, "pickaxe", 3, SoundType.field_185852_e);

    private static final EnumMortarType[] META_LOOKUP;
    public static final String[] NAMES;
    public static final Map<String, EnumMortarType> NAME_MAP;
    private final int meta;
    private final String name;
    private final Material material;
    private final MapColor mapColor;
    private final float hardness;
    private final float resistance;
    private final String harvestTool;
    private final int harvestLevel;
    private final SoundType soundType;

    private EnumMortarType(int meta, String name, Material material, MapColor mapColor, float hardness, float resistance, String harvestTool, int harvestLevel, SoundType soundType) {
        this.meta = meta;
        this.name = name;
        this.material = material;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.resistance = resistance;
        this.harvestTool = harvestTool;
        this.harvestLevel = harvestLevel;
        this.soundType = soundType;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public String getHarvestTool() {
        return this.harvestTool;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public static EnumMortarType fromMeta(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public static EnumMortarType fromName(String name) {
        return NAME_MAP.get(name);
    }

    static {
        META_LOOKUP = (EnumMortarType[])Stream.of(EnumMortarType.values()).sorted(Comparator.comparing(EnumMortarType::getMeta)).toArray(EnumMortarType[]::new);
        NAMES = (String[])Stream.of(EnumMortarType.values()).sorted(Comparator.comparing(EnumMortarType::getMeta)).map(enumMortarType -> enumMortarType.name).toArray(String[]::new);
        NAME_MAP = Stream.of(EnumMortarType.values()).collect(Collectors.toMap(EnumMortarType::func_176610_l, Function.identity()));
    }
}

