/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.integration.jei;

import com.codetaylor.mc.advancedmortars.lib.gui.GuiHelper;
import com.codetaylor.mc.advancedmortars.modules.mortar.recipe.RecipeMortar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class JEIRecipeWrapperMortar
implements IRecipeWrapper {
    private static final ResourceLocation TEXTURE_PRIMARY_OVERLAY = new ResourceLocation("advancedmortars", "textures/gui/jei_primary.png");
    private static final ResourceLocation TEXTURE_SECONDARY_OVERLAY = new ResourceLocation("advancedmortars", "textures/gui/jei_secondary.png");
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private List<ItemStack> outputs;
    private float secondaryOutputChance;

    public JEIRecipeWrapperMortar(RecipeMortar recipe) {
        for (Ingredient input : recipe.getIngredients()) {
            this.inputs.add(Arrays.asList(input.func_193365_a()));
        }
        this.outputs = new ArrayList<ItemStack>();
        this.outputs.add(recipe.getOutput());
        if (recipe.getSecondaryOutput() != null && !recipe.getSecondaryOutput().func_190926_b()) {
            this.outputs.add(recipe.getSecondaryOutput());
        }
        this.secondaryOutputChance = recipe.getSecondaryOutputChance();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179147_l();
        if (this.outputs.size() > 1) {
            GuiHelper.drawTexturedRect(minecraft, TEXTURE_SECONDARY_OVERLAY, recipeWidth - 26, 12, 26, 54, 0, 0, 0, 26, 54);
            String text = Math.round(this.secondaryOutputChance * 100.0f) + "%";
            int stringWidth = minecraft.field_71466_p.func_78256_a(text);
            minecraft.field_71466_p.func_175063_a(text, (float)(recipeWidth - stringWidth - 24), 48.0f, 0xFFFFFF);
        } else {
            GuiHelper.drawTexturedRect(minecraft, TEXTURE_PRIMARY_OVERLAY, recipeWidth - 26, 8, 26, 54, 0, 0, 0, 26, 54);
        }
        GlStateManager.func_179084_k();
    }
}

