/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.modules.mortar.block;

import com.codetaylor.mc.advancedmortars.lib.spi.BlockBase;
import com.codetaylor.mc.advancedmortars.lib.spi.IBlockVariant;
import com.codetaylor.mc.advancedmortars.lib.util.StackUtil;
import com.codetaylor.mc.advancedmortars.modules.mortar.ModuleConfig;
import com.codetaylor.mc.advancedmortars.modules.mortar.reference.EnumMortarType;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarBase;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarDiamond;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarEmerald;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarGold;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarIron;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarObsidian;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarStone;
import com.codetaylor.mc.advancedmortars.modules.mortar.tile.TileEntityMortarWood;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMortar
extends BlockBase
implements IBlockVariant<EnumMortarType> {
    public static final String NAME = "mortar";
    public static final IProperty<EnumMortarType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMortarType.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);

    public BlockMortar() {
        super(Material.field_151575_d, NAME);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumMortarType.WOOD)));
    }

    public Material func_149688_o(IBlockState state) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getMaterial();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((EnumMortarType)((Object)blockState.func_177229_b(VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((EnumMortarType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).getResistance();
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getHarvestTool();
    }

    public int getHarvestLevel(IBlockState state) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getHarvestLevel();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getSoundType();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityMortarBase) {
            boolean dropAllItems = !ModuleConfig.KEEP_CONTENTS;
            drops.add((Object)((TileEntityMortarBase)tileEntity).destroy(dropAllItems, false, null));
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (!super.func_176196_c(world, pos)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity;
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityMortarBase) {
            ItemStack itemStack = ((TileEntityMortarBase)tileEntity).destroy(true, false, SoundEvents.field_187638_cR);
            StackUtil.spawnStackOnTop(world, itemStack, pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184586_b(hand);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityMortarBase) {
                TileEntityMortarBase tile = (TileEntityMortarBase)tileEntity;
                if (heldItem.func_190926_b() && player.func_70093_af()) {
                    if (!tile.isEmpty()) {
                        StackUtil.spawnStackOnTop(world, tile.removeItem(), pos);
                    }
                    return true;
                }
                if (!heldItem.func_190926_b() && tile.canInsertItem(heldItem)) {
                    tile.insertItem(heldItem);
                    return true;
                }
                if ((heldItem.func_190926_b() || !ModuleConfig.RECIPES.REQUIRE_EMPTY_HAND_TO_USE) && player.func_71024_bL().func_75116_a() >= ModuleConfig.RECIPES.MINIMUM_HUNGER_TO_USE && tile.incrementCraftingProgress()) {
                    player.func_71020_j((float)ModuleConfig.RECIPES.EXHAUSTION_COST_PER_CLICK);
                }
            }
        }
        return true;
    }

    public int getMaxDurability(ItemStack itemStack) {
        int metadata = itemStack.func_77960_j();
        EnumMortarType type = EnumMortarType.fromMeta(metadata);
        return this.getMaxDurability(type);
    }

    public int getMaxDurability(EnumMortarType type) {
        switch (type) {
            case WOOD: {
                return ModuleConfig.DURABILITY.WOOD;
            }
            case STONE: {
                return ModuleConfig.DURABILITY.STONE;
            }
            case IRON: {
                return ModuleConfig.DURABILITY.IRON;
            }
            case GOLD: {
                return ModuleConfig.DURABILITY.GOLD;
            }
            case DIAMOND: {
                return ModuleConfig.DURABILITY.DIAMOND;
            }
            case OBSIDIAN: {
                return ModuleConfig.DURABILITY.OBSIDIAN;
            }
            case EMERALD: {
                return ModuleConfig.DURABILITY.EMERALD;
            }
        }
        throw new IllegalArgumentException("Unknown mortar type: " + type);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumMortarType type = (EnumMortarType)((Object)state.func_177229_b(VARIANT));
        switch (type) {
            case WOOD: {
                return new TileEntityMortarWood();
            }
            case STONE: {
                return new TileEntityMortarStone();
            }
            case IRON: {
                return new TileEntityMortarIron();
            }
            case DIAMOND: {
                return new TileEntityMortarDiamond();
            }
            case GOLD: {
                return new TileEntityMortarGold();
            }
            case OBSIDIAN: {
                return new TileEntityMortarObsidian();
            }
            case EMERALD: {
                return new TileEntityMortarEmerald();
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + type);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumMortarType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMortarType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumMortarType type : EnumMortarType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @Nonnull
    public String getName(ItemStack stack) {
        return "mortar_" + EnumMortarType.fromMeta(stack.func_77960_j()).func_176610_l();
    }

    @Override
    public IProperty<EnumMortarType> getVariant() {
        return VARIANT;
    }
}

