/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.lib.module.helper;

import com.codetaylor.mc.advancedmortars.lib.spi.IBlockVariant;
import com.codetaylor.mc.advancedmortars.lib.spi.IVariant;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ModelRegistrationHelper {
    public static final StateMapperBase PROPERTY_STRING_MAPPER = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    public static void registerBlockItemModels(Block ... blocks) {
        for (Block block : blocks) {
            if (block instanceof IBlockVariant) {
                ModelRegistrationHelper.registerVariantBlockItemModels(block.func_176223_P(), ((IBlockVariant)block).getVariant());
                continue;
            }
            ModelRegistrationHelper.registerBlockItemModel(block.func_176223_P());
        }
    }

    public static void registerBlockItemModel(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        ModelRegistrationHelper.registerItemModel(item, new ModelResourceLocation((ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block), PROPERTY_STRING_MAPPER.func_178131_a((Map)blockState.func_177228_b())));
    }

    public static <T extends IVariant & Comparable<T>> void registerVariantBlockItemModels(IBlockState baseState, IProperty<T> property) {
        ModelRegistrationHelper.registerVariantBlockItemModels(baseState, property, IVariant::getMeta);
    }

    public static <T extends IVariant & Comparable<T>> void registerVariantBlockItemModelsSeparately(IBlockState state, IProperty<T> property) {
        ModelRegistrationHelper.registerVariantBlockItemModelsSeparately(state, property, "");
    }

    public static <T extends IVariant & Comparable<T>> void registerVariantBlockItemModelsSeparately(IBlockState state, IProperty<T> property, String suffix) {
        for (IVariant value : property.func_177700_c()) {
            Block block = state.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            String name = block instanceof IBlockVariant ? ((IBlockVariant)block).getName(new ItemStack(item, 1, value.getMeta())) + suffix : value.func_176610_l() + suffix;
            if (item == Items.field_190931_a) continue;
            ModelRegistrationHelper.registerItemModel(item, value.getMeta(), new ModelResourceLocation("advancedmortars:" + name, "inventory"));
        }
    }

    public static <T extends Comparable<T>> void registerVariantBlockItemModels(IBlockState baseState, IProperty<T> property, ToIntFunction<T> getMeta) {
        property.func_177700_c().forEach(value -> ModelRegistrationHelper.registerBlockItemModelForMeta(baseState.func_177226_a(property, value), getMeta.applyAsInt(value)));
    }

    public static void registerBlockItemModelForMeta(IBlockState state, int metadata) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item != Items.field_190931_a) {
            ModelRegistrationHelper.registerItemModel(item, metadata, PROPERTY_STRING_MAPPER.func_178131_a((Map)state.func_177228_b()));
        }
    }

    public static void registerItemModels(Item ... items) {
        for (Item item : items) {
            ModelRegistrationHelper.registerItemModel(item, item.getRegistryName().toString());
        }
    }

    public static void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation resourceLocation = new ModelResourceLocation(modelLocation, "inventory");
        ModelRegistrationHelper.registerItemModel(item, 0, resourceLocation);
    }

    public static void registerItemModel(Item item, ModelResourceLocation resourceLocation) {
        ModelRegistrationHelper.registerItemModel(item, 0, resourceLocation);
    }

    public static void registerItemModel(Item item, int metadata, String variant) {
        ModelRegistrationHelper.registerItemModel(item, metadata, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    public static void registerItemModel(Item item, int meta, ModelResourceLocation resourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resourceLocation);
    }

    public static <T extends IVariant> void registerVariantItemModels(Item item, String variantName, T[] values) {
        for (T value : values) {
            ModelRegistrationHelper.registerItemModel(item, value.getMeta(), variantName + "=" + value.func_176610_l());
        }
    }
}

