/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.lib.module.helper;

import com.codetaylor.mc.advancedmortars.lib.spi.IBlockColored;
import com.codetaylor.mc.advancedmortars.lib.spi.IBlockVariant;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.util.ResourceLocation;

public class BlockRegistrationHelper {
    public static ItemBlock[] createItemBlocks(Block ... blocks) {
        ItemBlock[] result = new ItemBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            ItemBlock itemBlock;
            result[i] = itemBlock = BlockRegistrationHelper.createItemBlock(blocks[i]);
        }
        return result;
    }

    public static ItemBlock createItemBlock(Block block) {
        Object itemBlock = block instanceof IBlockColored ? new ItemColored(block, ((IBlockColored)block).hasBlockColoredSubtypes()) : (block instanceof IBlockVariant ? new ItemMultiTexture(block, block, ((IBlockVariant)block)::getName) : new ItemBlock(block));
        BlockRegistrationHelper.setRegistryName(block, (ItemBlock)itemBlock);
        return itemBlock;
    }

    private static void setRegistryName(Block block, ItemBlock itemBlock) {
        ResourceLocation registryName = block.getRegistryName();
        Preconditions.checkNotNull((Object)registryName, (String)"Block %s has null registry name", (Object)block);
        itemBlock.setRegistryName(registryName);
    }
}

