/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.advancedmortars.lib.module;

import com.codetaylor.mc.advancedmortars.lib.module.IModule;
import com.codetaylor.mc.advancedmortars.lib.module.IModuleLoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class ModuleRegistry {
    private Map<Class<? extends IModule>, IModule> moduleMap;
    private IModuleLoggerFactory moduleLoggerFactory;

    public ModuleRegistry(IModuleLoggerFactory moduleLoggerFactory) {
        this.moduleLoggerFactory = moduleLoggerFactory;
        this.moduleMap = new HashMap<Class<? extends IModule>, IModule>();
    }

    public void registerModules(IModule ... modules) {
        for (IModule module : modules) {
            this.registerModule(module);
        }
    }

    public void registerModule(IModule module) {
        if (this.moduleMap.containsKey(module.getClass())) {
            throw new RuntimeException("Module already registered: " + module.getClass());
        }
        MinecraftForge.EVENT_BUS.register((Object)module);
        module.setLogger(this.moduleLoggerFactory.create(module));
        this.moduleMap.put(module.getClass(), module);
    }

    public <M extends IModule> M getModule(Class<M> moduleClass) {
        return (M)this.moduleMap.get(moduleClass);
    }

    public List<IModule> getModules(List<IModule> result) {
        result.addAll(this.moduleMap.values());
        return result;
    }

    public boolean hasModule(Class<? extends IModule> moduleClass) {
        return this.moduleMap.containsKey(moduleClass);
    }
}

