/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.gui.VillageLordGuiContainer;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.item.ItemTrophy;
import net.torocraft.toroquest.network.message.MessageQuestUpdate;

public class MessageSetItemReputationAmount
implements IMessage {
    public int reputation = 0;
    public MessageCode messageCode = MessageCode.EMPTY;

    public MessageSetItemReputationAmount() {
    }

    public MessageSetItemReputationAmount(IVillageLordInventory inventory) {
        ItemStack item = inventory.getDonationItem();
        if (item.func_190926_b()) {
            this.reputation = 0;
            this.messageCode = MessageCode.EMPTY;
            return;
        }
        if (MessageSetItemReputationAmount.isNoteForLord(inventory.getProvince(), item)) {
            this.reputation = 0;
            this.messageCode = MessageCode.NOTE;
            return;
        }
        if (MessageSetItemReputationAmount.isStolenItemForProvince(inventory.getProvince(), item)) {
            this.reputation = ToroQuestConfiguration.donateArtifactRepGain;
            this.messageCode = MessageCode.STOLEN_ITEM;
            return;
        }
        if (MessageSetItemReputationAmount.isTrophy(inventory.getProvince(), item)) {
            this.reputation = ToroQuestConfiguration.donateTrophyRepGain;
            this.messageCode = MessageCode.TROPHY;
            return;
        }
        MessageQuestUpdate.DonationReward reward = MessageQuestUpdate.getRepForDonation(item);
        if (reward != null) {
            this.reputation = reward.rep;
            this.messageCode = MessageCode.DONATION;
            return;
        }
        this.reputation = 0;
        this.messageCode = MessageCode.EMPTY;
    }

    public static boolean isStolenItemForProvince(Province inProvince, ItemStack stack) {
        try {
            if (!stack.func_77942_o()) {
                return false;
            }
            if (inProvince == null) {
                return false;
            }
            String civName = stack.func_77978_p().func_74779_i("civilizationName");
            Boolean isStolen = stack.func_77978_p().func_74767_n("isStolen");
            if (MessageSetItemReputationAmount.isEmpty(civName)) {
                return false;
            }
            if (!isStolen.booleanValue()) {
                return false;
            }
            return inProvince.civilization.name().toString().equals(civName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTrophy(Province inProvince, ItemStack stack) {
        if (inProvince == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemTrophy || stack.func_77973_b() == Item.func_111206_d((String)"toroquest:legendary_bandit_helmet") || stack.func_77973_b() == Item.func_111206_d((String)"toroquest:royal_helmet");
    }

    public static boolean isNoteForLord(Province inProvince, ItemStack stack) {
        try {
            if (stack.func_77973_b() != Item.func_111206_d((String)"toroquest:lord_note") || !stack.func_77942_o()) {
                return false;
            }
            if (inProvince == null) {
                return false;
            }
            String toProvinceID = stack.func_77978_p().func_74779_i("toProvinceID");
            String questId = stack.func_77978_p().func_74779_i("questId");
            if (MessageSetItemReputationAmount.isEmpty(toProvinceID) || MessageSetItemReputationAmount.isEmpty(questId)) {
                return false;
            }
            return inProvince.id.toString().equals(toProvinceID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.reputation = buf.readInt();
        this.messageCode = this.e(buf.readInt());
    }

    private MessageCode e(int i) {
        try {
            return MessageCode.values()[i];
        }
        catch (Exception e) {
            return MessageCode.EMPTY;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.reputation);
        buf.writeInt(this.messageCode.ordinal());
    }

    public static boolean isSet(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return !MessageSetItemReputationAmount.isSet(s);
    }

    public static class Handler
    implements IMessageHandler<MessageSetItemReputationAmount, IMessage> {
        public IMessage onMessage(final MessageSetItemReputationAmount message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    new Worker().work(message);
                }
            });
            return null;
        }
    }

    public static class Worker {
        public void work(MessageSetItemReputationAmount message) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player == null) {
                return;
            }
            VillageLordGuiContainer.setDonateInfo(message);
        }
    }

    public static enum MessageCode {
        EMPTY,
        NOTE,
        STOLEN_ITEM,
        DONATION,
        TROPHY;

    }
}

