/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageSetItemReputationAmount;
import net.torocraft.toroquest.network.message.MessageSetQuestInfo;

public class MessageQuestUpdate
implements IMessage {
    public Action action;
    public int lordEntityId;

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.lordEntityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.lordEntityId);
    }

    public static DonationReward getRepForDonation(ItemStack item) {
        Block block;
        if (item.func_190926_b()) {
            return null;
        }
        if (item.func_77973_b() == Items.field_151166_bC) {
            return new DonationReward(ToroQuestConfiguration.donateEmeraldRepGain * item.func_190916_E(), null);
        }
        if (item.func_77973_b() == Item.func_111206_d((String)"toroquest:bandit_helmet")) {
            return new DonationReward(ToroQuestConfiguration.donateBanditMaskRepGain * item.func_190916_E(), null);
        }
        if (item.func_77973_b() instanceof ItemBlock && Blocks.field_150475_bE == (block = ((ItemBlock)item.func_77973_b()).func_179223_d())) {
            return new DonationReward(ToroQuestConfiguration.donateEmeraldRepGain * 9 * item.func_190916_E(), null);
        }
        for (ToroQuestConfiguration.Donate d : ToroQuestConfiguration.donate) {
            if (item.func_77973_b() != d.item) continue;
            return new DonationReward(d.rep * item.func_190916_E(), null);
        }
        return null;
    }

    public static class DonationReward {
        public Item item;
        public int rep;

        public DonationReward() {
        }

        public DonationReward(int rep, Item item) {
            this.rep = rep;
            this.item = item;
        }
    }

    public static class Handler
    implements IMessageHandler<MessageQuestUpdate, IMessage> {
        public IMessage onMessage(final MessageQuestUpdate message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                return null;
            }
            final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            WorldServer worldServer = player.func_71121_q();
            worldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    new Worker(message.action).work(message, (EntityPlayer)player);
                }
            });
            return null;
        }
    }

    public static class Worker {
        private final Action action;

        public Worker(Action action) {
            this.action = action;
        }

        void work(MessageQuestUpdate message, EntityPlayer player) {
            if (player == null) {
                return;
            }
            EntityVillageLord lord = (EntityVillageLord)player.field_70170_p.func_73045_a(message.lordEntityId);
            Province lordProvince = lord.getHomeProvince();
            Province standingProvince = lord.getStandingInProvince();
            if (lord == null || lord.field_70173_aa <= 100 || lord.getCivilization() == null || lordProvince == null || standingProvince == null || lordProvince != standingProvince) {
                player.func_71053_j();
                return;
            }
            IVillageLordInventory inventory = lord.getInventory(player.func_110124_au());
            if (inventory == null) {
                player.func_71053_j();
                return;
            }
            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f);
            switch (this.action) {
                case ACCEPT: {
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193808_ex, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    this.processAccept(player, lordProvince, inventory);
                    break;
                }
                case COMPLETE: {
                    this.processComplete(player, lordProvince, inventory, lord);
                    break;
                }
                case REJECT: {
                    this.processReject(player, lordProvince, inventory);
                    if (!player.field_70170_p.field_72995_K) {
                        lord.playTameEffect((byte)7);
                        lord.field_70170_p.func_72960_a((Entity)lord, (byte)7);
                    }
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.AMBIENT, 3.0f, 0.6f);
                    break;
                }
                case DONATE: {
                    this.processDonate(player, lordProvince, inventory);
                    if (!player.field_70170_p.field_72995_K) {
                        lord.playTameEffect((byte)8);
                        lord.field_70170_p.func_72960_a((Entity)lord, (byte)8);
                    }
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193808_ex, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid quest action [" + (Object)((Object)this.action) + "]");
                }
            }
        }

        private void processDonate(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            ItemStack donation = inventory.getDonationItem();
            if (MessageSetItemReputationAmount.isNoteForLord(province, donation)) {
                this.writeReplyNote(inventory, donation, player);
                return;
            }
            if (MessageSetItemReputationAmount.isStolenItemForProvince(province, donation)) {
                this.handleReturnStolenItem(player, province, inventory, donation);
                return;
            }
            if (MessageSetItemReputationAmount.isTrophy(province, donation)) {
                this.handleDonateTrophy(player, province, inventory, donation);
                return;
            }
            DonationReward reward = MessageQuestUpdate.getRepForDonation(donation);
            if (reward != null) {
                EventHandlers.adjustPlayerRep(player, province.civilization, reward.rep);
                if (reward.rep > 0) {
                    player.func_184185_a(SoundEvents.field_193808_ex, 1.0f, 1.0f);
                }
                inventory.setDonationItem(ItemStack.field_190927_a);
                try {
                    player.func_191521_c(inventory.getReturnItems().get(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inventory.setReturnItems(new ItemStack(reward.item));
            }
        }

        private void handleDonateTrophy(EntityPlayer player, Province province, IVillageLordInventory inventory, ItemStack stack) {
            if (inventory.addTrophy(stack.func_77973_b())) {
                inventory.setDonationItem(ItemStack.field_190927_a);
                EventHandlers.adjustPlayerRep(player, province.civilization, ToroQuestConfiguration.donateTrophyRepGain);
            }
        }

        private void handleReturnStolenItem(EntityPlayer player, Province province, IVillageLordInventory inventory, ItemStack stack) {
            inventory.setDonationItem(ItemStack.field_190927_a);
            int num = ToroQuestConfiguration.donateArtifactRepGain / 2;
            ItemStack emeralds = new ItemStack(Items.field_151166_bC, num);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
            list.add(emeralds);
            try {
                player.func_191521_c(inventory.getReturnItems().get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            inventory.setReturnItems(list);
            EventHandlers.adjustPlayerRep(player, province.civilization, ToroQuestConfiguration.donateArtifactRepGain);
        }

        private void writeReplyNote(IVillageLordInventory inventory, ItemStack note, EntityPlayer player) {
            inventory.setDonationItem(ItemStack.field_190927_a);
            String fromProvinceID = note.func_77978_p().func_74779_i("fromProvinceID");
            String questId = note.func_77978_p().func_74779_i("questId");
            if (MessageSetItemReputationAmount.isEmpty(fromProvinceID) || MessageSetItemReputationAmount.isEmpty(questId)) {
                return;
            }
            ItemStack itemStack = new ItemStack(Item.func_111206_d((String)"toroquest:lord_reply"));
            itemStack.func_77983_a("fromProvinceID", (NBTBase)new NBTTagString(fromProvinceID));
            itemStack.func_77983_a("questId", (NBTBase)new NBTTagString(questId));
            Province province = CivilizationUtil.getProvinceFromUUID(player.field_70170_p, CivilizationUtil.enumUUID(fromProvinceID));
            itemStack.func_151001_c(province != null ? "Reply Note, From Lord of " + province.getName() : "Reply Note");
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
            list.add(itemStack);
            try {
                player.func_191521_c(inventory.getReturnItems().get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            inventory.setReturnItems(list);
        }

        protected void processAccept(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).acceptQuest(inputItems);
            List<ItemStack> returnItems = inventory.getReturnItems();
            for (ItemStack item : returnItems) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)item);
            }
            if (outputItems == null && inputItems != null) {
                for (ItemStack item : inputItems) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)item);
                }
            }
            if (outputItems != null) {
                int outputItemsSize = outputItems.size();
                int i = 0;
                for (ItemStack item : outputItems) {
                    if (i == outputItemsSize - 1) {
                        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
                        stack.add(outputItems.get(i));
                        inventory.setReturnItems(stack);
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)item);
                    }
                    ++i;
                }
            }
            QuestData currentQuest = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, currentQuest, null), (EntityPlayerMP)player);
        }

        protected void processReject(EntityPlayer player, Province province, IVillageLordInventory inventory) {
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).rejectQuest(inputItems);
            List<ItemStack> returnItems = inventory.getReturnItems();
            if (outputItems != null) {
                for (ItemStack item : outputItems) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)item);
                }
            } else {
                for (ItemStack item : inputItems) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)item);
                }
                inventory.setGivenItems(returnItems);
                return;
            }
            QuestData nextQuest = PlayerCivilizationCapabilityImpl.get(player).getNextQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, null, nextQuest), (EntityPlayerMP)player);
        }

        protected void processComplete(EntityPlayer player, Province province, IVillageLordInventory inventory, EntityVillageLord lord) {
            List<ItemStack> inputItems = inventory.getGivenItems();
            List<ItemStack> outputItems = PlayerCivilizationCapabilityImpl.get(player).completeQuest(inputItems);
            if (outputItems == null) {
                for (ItemStack itemstack : inputItems) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)itemstack);
                }
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187679_dF, SoundCategory.AMBIENT, 3.0f, 0.6f);
                return;
            }
            boolean flag = false;
            for (ItemStack itemstack : outputItems) {
                if (itemstack.func_77973_b() == Items.field_151166_bC && !flag) {
                    flag = true;
                    inventory.setReturnItems(itemstack);
                    continue;
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)itemstack);
            }
            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193808_ex, SoundCategory.AMBIENT, 1.0f, 1.0f);
            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 1.0f);
            if (!player.field_70170_p.field_72995_K) {
                lord.playTameEffect((byte)8);
                lord.field_70170_p.func_72960_a((Entity)lord, (byte)8);
            }
            QuestData nextQuest = PlayerCivilizationCapabilityImpl.get(player).getNextQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, null, nextQuest), (EntityPlayerMP)player);
        }
    }

    public static enum Action {
        ACCEPT,
        REJECT,
        COMPLETE,
        DONATE;

    }
}

