/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.item.armor;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.material.ArmorMaterials;

@Mod.EventBusSubscriber
public class ItemRoyalArmor
extends ItemArmor {
    public static final String NAME = "royal";
    public static ItemRoyalArmor helmetItem;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        helmetItem = new ItemRoyalArmor("royal_helmet", 1, EntityEquipmentSlot.HEAD);
        helmetItem.setRegistryName(new ResourceLocation("toroquest", "royal_helmet"));
        event.getRegistry().register((IForgeRegistryEntry)helmetItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ToroQuestConfiguration.useCrownToCreateNewProvinces) {
            tooltip.add("Crown a Guard within a civilization to create a new Village Lord, or crown a Guard to create a new province under a new ruler!\n\n\u00a7oWho did you kill to get this crown, Kingslayer?");
        } else {
            tooltip.add("Crown a Guard within a civilization to create a new Village Lord!\n\n\u00a7oWho did you kill to get this crown, Kingslayer?");
        }
    }

    public static void registerRenders() {
        ItemRoyalArmor.registerRendersHelmet();
    }

    private static void registerRendersHelmet() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)helmetItem, 0, ItemRoyalArmor.model("helmet"));
    }

    private static ModelResourceLocation model(String model) {
        return new ModelResourceLocation("toroquest:royal_" + model, "inventory");
    }

    public ItemRoyalArmor(String unlocalizedName, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(ArmorMaterials.ROYAL, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(unlocalizedName);
        this.func_77656_e(-1);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        List guards;
        if (playerIn == null || playerIn.field_70170_p == null || worldIn.field_72995_K) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack i = playerIn.func_184586_b(handIn);
        if (i != null && !i.func_190926_b() && playerIn.field_71093_bK == 0 && !(guards = playerIn.field_70170_p.func_72872_a(EntityGuard.class, new AxisAlignedBB(playerIn.func_180425_c()).func_72314_b(3.0, 3.0, 3.0))).isEmpty()) {
            Province provinceOn = CivilizationUtil.getProvinceAt(playerIn.field_70170_p, playerIn.field_70176_ah, playerIn.field_70164_aj);
            if (provinceOn != null) {
                if (provinceOn.hasLord) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("\u00a7oThis province already has a ruler!\u00a7r"), true);
                    return new ActionResult(EnumActionResult.FAIL, (Object)i);
                }
                if (PlayerCivilizationCapabilityImpl.get(playerIn).getReputation(provinceOn.getCiv()) >= 0) {
                    Iterator iterator = guards.iterator();
                    if (iterator.hasNext()) {
                        EntityGuard guard = (EntityGuard)((Object)iterator.next());
                        EntityVillageLord vl = new EntityVillageLord(guard.func_130014_f_(), guard.func_180425_c().func_177958_n(), guard.func_180425_c().func_177956_o(), guard.func_180425_c().func_177952_p());
                        guard.func_70606_j(0.0f);
                        guard.func_70106_y();
                        vl.func_70107_b(guard.field_70165_t, guard.field_70163_u, guard.field_70161_v);
                        vl.addArmor();
                        worldIn.func_72838_d((Entity)vl);
                        vl.playTameEffect((byte)6);
                        worldIn.func_72960_a((Entity)vl, (byte)6);
                        vl.func_184185_a(SoundEvents.field_187722_q, 1.0f, 0.8f);
                        vl.func_184185_a(SoundEvents.field_187698_i, 0.8f, 0.8f);
                        vl.func_184185_a(SoundEvents.field_191243_bm, 1.0f, 1.0f);
                        for (EntityPlayer player : worldIn.field_73010_i) {
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + provinceOn.getName() + " has been founded!\u00a7r"));
                        }
                        vl.pledgeAllegianceTo(provinceOn);
                        return new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
                    }
                    return new ActionResult(EnumActionResult.FAIL, (Object)i);
                }
            } else if (ToroQuestConfiguration.useCrownToCreateNewProvinces) {
                Province provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah + 6, playerIn.field_70164_aj + 6);
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah + 6, playerIn.field_70164_aj - 6);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah - 6, playerIn.field_70164_aj + 6);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah - 6, playerIn.field_70164_aj - 6);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah + 7, playerIn.field_70164_aj);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah, playerIn.field_70164_aj + 7);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah - 7, playerIn.field_70164_aj);
                }
                if (provinceNear == null) {
                    provinceNear = CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah, playerIn.field_70164_aj - 7);
                }
                if (provinceNear != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("\u00a7oToo close to another province!\u00a7r"), true);
                    return new ActionResult(EnumActionResult.FAIL, (Object)i);
                }
                Iterator iterator = guards.iterator();
                if (iterator.hasNext()) {
                    EntityGuard guard = (EntityGuard)((Object)iterator.next());
                    if (CivilizationUtil.getProvinceAt(worldIn, playerIn.field_70176_ah, playerIn.field_70164_aj) == null) {
                        EntityVillageLord vl = new EntityVillageLord(guard.func_130014_f_(), guard.func_180425_c().func_177958_n(), guard.func_180425_c().func_177956_o(), guard.func_180425_c().func_177952_p());
                        CivilizationsWorldSaveData.get(worldIn).register(playerIn.field_70176_ah, playerIn.field_70164_aj, false);
                        provinceOn = CivilizationUtil.getProvinceAt(worldIn, guard.field_70176_ah, guard.field_70164_aj);
                        guard.func_70106_y();
                        guard.func_70606_j(0.0f);
                        if (!worldIn.field_72995_K) {
                            vl.func_70107_b(guard.field_70165_t, guard.field_70163_u, guard.field_70161_v);
                            vl.addArmor();
                            worldIn.func_72838_d((Entity)vl);
                            vl.playTameEffect((byte)6);
                            worldIn.func_72960_a((Entity)vl, (byte)6);
                            vl.func_184185_a(SoundEvents.field_187722_q, 1.0f, 0.8f);
                            vl.func_184185_a(SoundEvents.field_187698_i, 0.8f, 0.8f);
                            vl.func_184185_a(SoundEvents.field_191243_bm, 1.0f, 0.9f);
                            for (EntityPlayer player : worldIn.field_73010_i) {
                                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + provinceOn.getName() + " has been founded!\u00a7r"));
                            }
                            vl.pledgeAllegianceTo(provinceOn);
                        }
                        return new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
                    }
                    return new ActionResult(EnumActionResult.FAIL, (Object)i);
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)i);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)i);
    }
}

