/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;

@Mod.EventBusSubscriber
public class ItemTownScroll
extends Item {
    public static String P_NAME = "null";
    public static final String NAME = "scroll_";
    public static ItemTownScroll INSTANCE;

    public ItemTownScroll(Province province) {
        this.func_77627_a(true);
        this.func_77625_d(16);
    }

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        INSTANCE = new ItemTownScroll(null);
        INSTANCE.setRegistryName(new ResourceLocation("toroquest", NAME + P_NAME));
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public static void registerRenders() {
        ModelResourceLocation model = new ModelResourceLocation("toroquest:scroll_" + P_NAME, "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)INSTANCE, 0, model);
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a((Item)INSTANCE, 0, new ModelResourceLocation("toroquest:scroll_" + P_NAME, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Teleport scroll not bound.");
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 5, 1, true, false));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        try {
            if (!stack.func_77942_o() || stack.func_190926_b()) {
                return stack;
            }
            String uuid = stack.func_77978_p().func_74779_i("province");
            if (uuid == null || uuid == "") {
                return stack;
            }
            Province province = ItemTownScroll.findTeleportProvince(entityplayer, uuid, worldIn);
            if (province == null) {
                return stack;
            }
            BlockPos loc = new BlockPos(province.getCenterPosX(), 0, province.getCenterPosZ());
            BlockPos teleportLocation = EventHandlers.findTeleportLocationFrom(entityplayer.field_70170_p, loc);
            if (teleportLocation == null) {
                return stack;
            }
            if (entityplayer != null && !entityplayer.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (entityplayer instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
            }
            entityplayer.func_70634_a((double)teleportLocation.func_177958_n() + 0.5, (double)teleportLocation.func_177956_o() + 0.5, (double)teleportLocation.func_177952_p() + 0.5);
            entityplayer.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 30, 1, true, false));
            entityplayer.field_70170_p.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187812_eh, SoundCategory.PLAYERS, 0.5f, 1.5f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 64;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        Random rand = new Random();
        playerIn.func_184598_c(handIn);
        double x = playerIn.field_70165_t;
        double y = playerIn.field_70163_u;
        double z = playerIn.field_70161_v;
        playerIn.field_70170_p.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
        playerIn.field_70170_p.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187810_eg, SoundCategory.PLAYERS, 1.0f, 1.5f);
        for (int i = 0; i < 16; ++i) {
            playerIn.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, x + rand.nextDouble() * 2.0 - 1.0, y + rand.nextDouble(), z + rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, new int[]{0});
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    protected static List<Province> getAllProvinces(World world) {
        return CivilizationsWorldSaveData.get(world).getProvinces();
    }

    public static Province findTeleportProvince(EntityPlayer player, String uuid, World world) {
        List<Province> provinces = ItemTownScroll.getAllProvinces(world);
        for (Province province : provinces) {
            if (!province.id.toString().equals(uuid)) continue;
            return province;
        }
        return null;
    }
}

