/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityToroVillager;

@Mod.EventBusSubscriber
public class ItemRecruitmentPapers
extends Item {
    public static ItemRecruitmentPapers INSTANCE;
    public static final String NAME = "recruitment_papers";
    private static ResourceLocation REGISTRY_NAME;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        INSTANCE = new ItemRecruitmentPapers();
        INSTANCE.setRegistryName(REGISTRY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public static void registerRenders() {
        ModelResourceLocation model = new ModelResourceLocation("toroquest:recruitment_papers", "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)INSTANCE, 0, model);
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a((Item)INSTANCE, 0, new ModelResourceLocation("toroquest:recruitment_papers", "inventory"));
    }

    public ItemRecruitmentPapers() {
        this.func_77655_b(NAME);
        this.field_77777_bU = 16;
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ToroQuestConfiguration.recruitBandits) {
            if (ToroQuestConfiguration.recruitVillagers) {
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description0", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description2", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description0", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description4", (Object[])new Object[0]));
            }
        } else if (ToroQuestConfiguration.recruitVillagers) {
            tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description0", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description1", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description3", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description0", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.recruitment_papers.description1", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af() || !ToroQuestConfiguration.recruitVillagers) {
            return super.func_77659_a(worldIn, player, hand);
        }
        player.func_70095_a(false);
        List villagers = player.field_70170_p.func_72872_a(EntityVillager.class, new AxisAlignedBB(player.func_180425_c()).func_72314_b(1.25, 1.25, 1.25));
        for (EntityVillager v : villagers) {
            Province province = CivilizationUtil.getProvinceAt(v.func_130014_f_(), v.func_180425_c().func_177958_n() / 16, v.func_180425_c().func_177952_p() / 16);
            if (province == null) {
                v.func_184185_a(SoundEvents.field_187913_gm, 0.8f, 1.0f);
                return super.func_77659_a(worldIn, player, hand);
            }
            if (v instanceof EntityToroVillager) continue;
            if (!v.func_70089_S() || v.func_70631_g_()) break;
            ItemStack itemstack = player.func_184586_b(hand);
            Item item = itemstack.func_77973_b();
            if (item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers")) && PlayerCivilizationCapabilityImpl.get(player).getReputation(province.getCiv()) >= 0) {
                if (!v.field_70170_p.field_72995_K) {
                    v.func_184185_a(SoundEvents.field_193784_dd, 1.2f, 1.2f);
                    v.func_184185_a(SoundEvents.field_187713_n, 1.0f, 1.0f);
                    v.func_184185_a(SoundEvents.field_187698_i, 0.5f, 0.8f);
                    itemstack.func_190918_g(1);
                    EntityGuard newEntity = new EntityGuard(v.field_70170_p);
                    newEntity.func_70107_b(v.field_70165_t, v.field_70163_u, v.field_70161_v);
                    newEntity.func_180482_a(v.field_70170_p.func_175649_E(new BlockPos((Vec3i)v.func_180425_c())), null);
                    newEntity.func_82149_j((Entity)v);
                    newEntity.actionTimer = 1;
                    v.func_70106_y();
                    v.field_70170_p.func_72838_d((Entity)newEntity);
                    newEntity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                    newEntity.func_70625_a((Entity)player, 30.0f, 30.0f);
                    newEntity.recruitGuard(player, province, "civvillagerrecruit");
                    newEntity.spawnedNearBandits = false;
                }
            } else {
                v.func_184185_a(SoundEvents.field_187913_gm, 0.8f, 1.0f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    static {
        REGISTRY_NAME = new ResourceLocation("toroquest", NAME);
    }
}

