/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.gui;

import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.gui.VillageLordContainer;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageQuestUpdate;
import net.torocraft.toroquest.network.message.MessageSetItemReputationAmount;
import org.lwjgl.input.Mouse;

public class VillageLordGuiContainer
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("toroquest:textures/gui/lord_gui.png");
    private static final int buttonWidth = 59;
    private static final int buttonHeight = 20;
    private static final int MOUSE_COOLDOWN = 200;
    private static long mousePressed = 0L;
    private static int donateRepForItem = 0;
    private static MessageSetItemReputationAmount.MessageCode donateMessageCode = MessageSetItemReputationAmount.MessageCode.EMPTY;
    private static String civName = "";
    private static String questTitle = "";
    private static String questDescription = "";
    private static boolean questAccepted = false;
    private static boolean questCompleted = false;
    private static CivilizationType civ = null;
    private EntityPlayer p = null;
    private final IVillageLordInventory inventory;

    public VillageLordGuiContainer() {
        this(null, null, null);
    }

    public VillageLordGuiContainer(EntityPlayer player, IVillageLordInventory inventory, World world) {
        super((Container)new VillageLordContainer(player, inventory, world));
        this.inventory = inventory;
        this.p = player;
        this.field_146999_f = 238;
        this.field_147000_g = 240;
        mousePressed = Minecraft.func_71386_F();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(guiTexture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawDonateButton(mouseX, mouseY);
        if (questAccepted) {
            if (questCompleted) {
                this.drawQuestCompleteButton(mouseX, mouseY);
                this.drawQuestAbandonButton(mouseX, mouseY);
            } else {
                this.drawCompleteButton(mouseX, mouseY);
                this.drawAbandonButton(mouseX, mouseY);
            }
        } else {
            this.drawAcceptButton(mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int LABEL_XPOS = 5;
        int LABEL_YPOS = 5;
        this.drawGuiTitle(5, 5);
        this.updateReputationDisplay(5, 5);
        this.drawQuestTitle(5, 5);
    }

    private void drawGuiTitle(int xPos, int yPos) {
        String text = I18n.func_135052_a((String)"quest.gui.title", (Object[])new Object[]{civName});
        this.field_146289_q.func_78276_b("\u00a7l" + text + "\u00a7r", xPos + 2, yPos, Color.darkGray.getRGB());
        if (this.p != null && civ != null) {
            int rep = PlayerCivilizationCapabilityImpl.get(this.p).getReputation(civ);
            this.field_146289_q.func_175063_a("\u00a7lPermissions & Perks:\u00a7r", (float)(xPos + 178), (float)(yPos + 134), -200);
            if (rep >= 0) {
                this.field_146289_q.func_175063_a("\u00a7lRecruit guards\u00a7r", (float)(xPos + 178), (float)(yPos + 145), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lRecruit guards\u00a7r", (float)(xPos + 178), (float)(yPos + 145), Color.darkGray.getRGB());
            }
            if (rep >= 50 || !ToroQuestConfiguration.loseReputationForCropGrief) {
                this.field_146289_q.func_175063_a("\u00a7lHarvest crops\u00a7r", (float)(xPos + 178), (float)(yPos + 156), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lHarvest crops\u00a7r", (float)(xPos + 178), (float)(yPos + 156), Color.darkGray.getRGB());
            }
            if (rep >= 100 || !ToroQuestConfiguration.loseReputationForAnimalGrief) {
                this.field_146289_q.func_175063_a("\u00a7lButcher livestock\u00a7r", (float)(xPos + 178), (float)(yPos + 167), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lButcher livestock\u00a7r", (float)(xPos + 178), (float)(yPos + 167), Color.darkGray.getRGB());
            }
            if (rep >= 250 || !ToroQuestConfiguration.loseReputationForBlockGrief) {
                this.field_146289_q.func_175063_a("\u00a7lGrief & firespread\u00a7r", (float)(xPos + 178), (float)(yPos + 178), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lGrief & firespread\u00a7r", (float)(xPos + 178), (float)(yPos + 178), Color.darkGray.getRGB());
            }
            if (rep >= 500) {
                this.field_146289_q.func_175063_a("\u00a7lRename province\u00a7r", (float)(xPos + 178), (float)(yPos + 189), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lRename province\u00a7r", (float)(xPos + 178), (float)(yPos + 189), Color.darkGray.getRGB());
            }
            if (rep >= 1000) {
                this.field_146289_q.func_175063_a("\u00a7lLegendary quests\u00a7r", (float)(xPos + 178), (float)(yPos + 200), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lLegendary quests\u00a7r", (float)(xPos + 178), (float)(yPos + 200), Color.darkGray.getRGB());
            }
            if (rep >= 2000) {
                this.field_146289_q.func_175063_a("\u00a7lDouble quest rewards\u00a7r", (float)(xPos + 178), (float)(yPos + 211), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lDouble quest rewards\u00a7r", (float)(xPos + 178), (float)(yPos + 211), Color.darkGray.getRGB());
            }
            if (rep >= 3000) {
                this.field_146289_q.func_175063_a("\u00a7lQuests grant experience\u00a7r", (float)(xPos + 178), (float)(yPos + 222), Color.white.getRGB());
            } else {
                this.field_146289_q.func_175063_a("\u00a7lQuests grant experience\u00a7r", (float)(xPos + 178), (float)(yPos + 222), Color.darkGray.getRGB());
            }
        }
    }

    private void drawDonateButton(int mouseX, int mouseY) {
        GuiButton submitButton = new GuiButton(0, this.field_147003_i + 84, this.field_147009_r + 16, 59, 20, I18n.func_135052_a((String)"quest.gui.button.donate", (Object[])new Object[0]));
        submitButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 1.0f);
        if (Mouse.getEventButtonState() && Mouse.getEventButton() != -1 && submitButton.func_146116_c(this.field_146297_k, mouseX, mouseY) && this.mouseCooldownOver()) {
            mousePressed = Minecraft.func_71386_F();
            MessageQuestUpdate message = new MessageQuestUpdate();
            message.action = MessageQuestUpdate.Action.DONATE;
            message.lordEntityId = this.inventory.getEntityId();
            ToroQuestPacketHandler.INSTANCE.sendToServer((IMessage)message);
        }
    }

    private void drawAcceptButton(int mouseX, int mouseY) {
        this.drawActionButton("quest.gui.button.accept", MessageQuestUpdate.Action.ACCEPT, mouseX, mouseY, 0);
    }

    private void drawCompleteButton(int mouseX, int mouseY) {
        this.drawActionButton("quest.gui.button.complete", MessageQuestUpdate.Action.COMPLETE, mouseX, mouseY, 0);
    }

    private void drawQuestCompleteButton(int mouseX, int mouseY) {
        this.drawActionButton("quest.gui.button.questcomplete", MessageQuestUpdate.Action.COMPLETE, mouseX, mouseY, 0);
    }

    private void drawAbandonButton(int mouseX, int mouseY) {
        this.drawActionButton("quest.gui.button.reject", MessageQuestUpdate.Action.REJECT, mouseX, mouseY, -65);
    }

    private void drawQuestAbandonButton(int mouseX, int mouseY) {
        this.drawActionButton("quest.gui.button.rejectcomplete", MessageQuestUpdate.Action.REJECT, mouseX, mouseY, -65);
    }

    protected void drawActionButton(String label, MessageQuestUpdate.Action action, int mouseX, int mouseY, int xOffset) {
        GuiButton abandonButton = new GuiButton(0, this.field_147003_i + 84 + xOffset, this.field_147009_r + 131, 59, 20, I18n.func_135052_a((String)label, (Object[])new Object[0]));
        abandonButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 1.0f);
        if (Mouse.getEventButtonState() && Mouse.getEventButton() != -1 && abandonButton.func_146116_c(this.field_146297_k, mouseX, mouseY) && this.mouseCooldownOver()) {
            mousePressed = Minecraft.func_71386_F();
            MessageQuestUpdate message = new MessageQuestUpdate();
            message.action = action;
            message.lordEntityId = this.inventory.getEntityId();
            ToroQuestPacketHandler.INSTANCE.sendToServer((IMessage)message);
        }
    }

    private void updateReputationDisplay(int xPos, int yPos) {
        if (MessageSetItemReputationAmount.MessageCode.DONATION.equals((Object)donateMessageCode)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"quest.gui.rep_for", (Object[])new Object[]{donateRepForItem}), xPos + 2, yPos + 17, Color.darkGray.getRGB());
        } else if (MessageSetItemReputationAmount.MessageCode.NOTE.equals((Object)donateMessageCode)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"quest.gui.reply", (Object[])new Object[0]), xPos + 2, yPos + 17, Color.darkGray.getRGB());
        } else if (MessageSetItemReputationAmount.MessageCode.STOLEN_ITEM.equals((Object)donateMessageCode)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"quest.gui.stolen_item", (Object[])new Object[0]), xPos + 2, yPos + 17, Color.darkGray.getRGB());
        } else if (MessageSetItemReputationAmount.MessageCode.TROPHY.equals((Object)donateMessageCode)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"quest.gui.trophy", (Object[])new Object[0]), xPos + 2, yPos + 17, Color.darkGray.getRGB());
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"quest.gui.empty", (Object[])new Object[0]), xPos + 2, yPos + 17, Color.darkGray.getRGB());
        }
    }

    private void drawQuestTitle(int xPos, int yPos) {
        this.field_146289_q.func_78276_b(questTitle, xPos + 2, yPos + 35, Color.darkGray.getRGB());
        this.field_146289_q.func_78279_b(questDescription, xPos + 25, yPos + 50, 115, Color.darkGray.getRGB());
    }

    private static String translate(String in) {
        if (in == null || in.trim().length() < 1) {
            return "";
        }
        String[] parts = in.split("\\|");
        if (parts.length == 1) {
            return I18n.func_135052_a((String)parts[0], (Object[])new Object[0]);
        }
        Object[] parameters = Arrays.copyOfRange(parts, 1, parts.length);
        VillageLordGuiContainer.processComplexParamters(parameters);
        return I18n.func_135052_a((String)parts[0], (Object[])parameters);
    }

    private static void processComplexParamters(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Object o = parameters[i];
            if (o != null && o instanceof String && o.toString().startsWith("L:")) {
                parameters[i] = VillageLordGuiContainer.processListParamter(o.toString());
                continue;
            }
            if (o == null || !(o instanceof String) || !o.toString().startsWith("D:")) continue;
            parameters[i] = VillageLordGuiContainer.processDirectionsParamter(o.toString());
        }
    }

    private static Object processDirectionsParamter(String s) {
        String[] parts = s.substring(2).split(";");
        if (parts.length != 3) {
            return s;
        }
        return I18n.func_135052_a((String)"quest.directions", (Object[])new Object[]{parts[0], parts[1], parts[2]});
    }

    private static String processListParamter(String s) {
        StringBuilder sb = new StringBuilder();
        String[] sStacks = s.substring(2).split(";");
        boolean isFirst = true;
        for (String sStack : sStacks) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            String[] sStackParts = sStack.split(",");
            if (sStackParts.length == 2) {
                sb.append(I18n.func_135052_a((String)(sStackParts[0] + ".name"), (Object[])new Object[0]));
                sb.append("[").append(sStackParts[1]).append("]");
                continue;
            }
            sb.append(sStackParts);
        }
        return sb.toString();
    }

    public static void setProvinceName(String name) {
        civName = name;
    }

    public static void setCivilization(CivilizationType name) {
        civ = name;
    }

    public static void setDonateInfo(MessageSetItemReputationAmount message) {
        donateRepForItem = message.reputation;
        donateMessageCode = message.messageCode;
    }

    public static void setQuestData(String title, String description, boolean accepted, boolean complete) {
        questTitle = VillageLordGuiContainer.translate(title);
        questDescription = VillageLordGuiContainer.translate(description);
        questAccepted = accepted;
        questCompleted = complete;
    }

    private boolean mouseCooldownOver() {
        return Minecraft.func_71386_F() - mousePressed > 200L;
    }
}

