/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageSetItemReputationAmount;
import net.torocraft.toroquest.network.message.MessageSetQuestInfo;

public class VillageLordContainer
extends Container {
    private final int HOTBAR_SLOT_COUNT = 9;
    private final int INVENTORY_ROW_COUNT = 3;
    private final int INVENTORY_COLUMN_COUNT = 9;
    private final int DONATE_ITEM_ROW_COUNT = 1;
    private final int DONATE_ITEM_COLUMN_COUNT = 1;
    private final int QUEST_INPUT_ITEM_ROW_COUNT = 4;
    private final int QUEST_INPUT_ITEM_COLUMN_COUNT = 1;
    private final int QUEST_OUTPUT_ITEM_ROW_COUNT = 1;
    private final int QUEST_OUTPUT_ITEM_COLUMN_COUNT = 1;
    private final int TROPHY_ROW_COUNT = 4;
    private final int TROPHY_COLUMN_COUNT = 2;
    private final int LORD_INVENTORY_SLOT_COUNT = 13;
    private final int VANILLA_SLOT_COUNT = 36;
    private final int VANILLA_FIRST_SLOT_INDEX = 0;
    private final int LORD_INVENTORY_FIRST_SLOT_INDEX = 36;
    private final int SLOT_X_SPACING = 18;
    private final int SLOT_Y_SPACING = 18;
    private final int HOTBAR_XPOS = 8;
    private final int HOTBAR_YPOS = 215;
    private final int INVENTORY_XPOS = 8;
    private final int INVENTORY_YPOS = 157;
    private final int DONATE_ITEM_XPOS = 152;
    private final int DONATE_ITEM_YPOS = 18;
    private final int QUEST_INPUT_ITEM_XPOS = 8;
    private final int QUEST_INPUT_ITEM_YPOS = 56;
    private final int QUEST_OUTPUT_ITEM_XPOS = 152;
    private final int QUEST_OUTPUT_ITEM_YPOS = 133;
    private final int TROPHY_ITEM_XPOS = 191;
    private final int TROPHY_ITEM_YPOS = 56;
    private final IVillageLordInventory inventory;
    private final EntityPlayer player;
    private final List<Integer> inputSlot = new ArrayList<Integer>();
    private final List<Integer> outputSlot = new ArrayList<Integer>();
    private int donationGuiSlotId;

    public VillageLordContainer(EntityPlayer player, IVillageLordInventory inventory, World world) {
        int yPos;
        int xPos;
        int slotNumber;
        int y;
        int x;
        this.player = player;
        this.inventory = inventory;
        this.inventory.func_174889_b(player);
        this.updateClientQuest();
        this.updateDonationInfo();
        int guiSlotIndex = 0;
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, x, 8 + 18 * x, 215));
            ++guiSlotIndex;
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 9; ++y) {
                slotNumber = 9 + x * 9 + y;
                xPos = 8 + y * 18;
                yPos = 157 + x * 18;
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, slotNumber, xPos, yPos));
                ++guiSlotIndex;
            }
        }
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 1; ++y) {
                slotNumber = x * 1 + y;
                xPos = 8 + y * 18;
                yPos = 56 + x * 18;
                this.func_75146_a(new Slot((IInventory)this.inventory, slotNumber, xPos, yPos));
                this.inputSlot.add(guiSlotIndex);
                ++guiSlotIndex;
            }
        }
        for (x = 0; x < 1; ++x) {
            for (y = 0; y < 1; ++y) {
                slotNumber = x * 1 + y + 4;
                xPos = 152 + y * 18;
                yPos = 18 + x * 18;
                this.func_75146_a(new Slot((IInventory)this.inventory, slotNumber, xPos, yPos));
                this.donationGuiSlotId = guiSlotIndex++;
            }
        }
        for (x = 0; x < 1; ++x) {
            for (y = 0; y < 1; ++y) {
                slotNumber = x * 1 + y + 5;
                xPos = 152 + y * 18;
                yPos = 133 + x * 18;
                this.func_75146_a(new SlotOutput(this.inventory, slotNumber, xPos, yPos));
                this.outputSlot.add(guiSlotIndex);
                ++guiSlotIndex;
            }
        }
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 2; ++y) {
                slotNumber = x * 2 + y + 6;
                xPos = 191 + y * 20;
                yPos = 56 + x * 18;
                this.func_75146_a(new SlotTrophy(this.inventory, slotNumber, xPos, yPos));
                this.outputSlot.add(guiSlotIndex);
                ++guiSlotIndex;
            }
        }
        this.func_75132_a(new IContainerListener(){

            public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
            }

            public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
                if (slotInd == VillageLordContainer.this.donationGuiSlotId) {
                    VillageLordContainer.this.donationItemUpdated(stack);
                }
            }

            public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
            }

            public void func_175173_a(Container containerIn, IInventory inventory) {
            }
        });
    }

    private void donationItemUpdated(ItemStack stack) {
        this.updateDonationInfo();
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        int stackSize;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = slot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (this.indexIsForAVanillaSlot(index)) {
            if (!this.func_75135_a(sourceStack, 36, 49, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (this.indexIsForALordInventorySlot(index) || this.indexIsForLordOutputSlot(index)) {
            if (!this.mergeStackFromLordToPlayer(sourceStack)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if ((stackSize = sourceStack.func_190916_E()) == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return copyOfSourceStack;
    }

    private boolean mergeStackFromLordToPlayer(ItemStack sourceStack) {
        return this.func_75135_a(sourceStack, 0, 36, false);
    }

    private boolean indexIsForAVanillaSlot(int index) {
        return index >= 0 && index < 36;
    }

    private boolean indexIsForALordInventorySlot(int index) {
        return index >= 36 && index < 49;
    }

    private boolean indexIsForLordOutputSlot(int index) {
        return index == 41;
    }

    private boolean indexIsForLordTrophySlot(int index) {
        return index > 41;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.inventory.func_174886_c(player);
    }

    private void updateDonationInfo() {
        if (this.player != null && this.inventory != null) {
            Province province;
            if (!this.player.field_70170_p.field_72995_K) {
                ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetItemReputationAmount(this.inventory), (EntityPlayerMP)this.player);
            }
            if ((province = CivilizationUtil.getProvinceAt(this.player.func_130014_f_(), this.player.field_70176_ah, this.player.field_70164_aj)) == null) {
                return;
            }
            CivilizationDataAccessor worldData = CivilizationsWorldSaveData.get(this.player.field_70170_p);
            if (worldData == null) {
                return;
            }
            if (this.inventory.hasTrophy("item.trophy_beholder")) {
                province.beholderTrophy = true;
                worldData.setTrophyBeholder(province.id, true);
            }
            if (this.inventory.hasTrophy("item.trophy_titan")) {
                province.titanTrophy = true;
                worldData.setTrophyTitan(province.id, true);
            }
            if (this.inventory.hasTrophy("item.dwarven_artifact")) {
                province.lordTrophy = true;
                worldData.setTrophyLord(province.id, true);
            }
            if (this.inventory.hasTrophy("item.legendary_bandit_helmet")) {
                province.banditTrophy = true;
                worldData.setTrophyBandit(province.id, true);
            }
            if (this.inventory.hasTrophy("item.trophy_mage")) {
                province.mageTrophy = true;
                worldData.setTrophyMage(province.id, true);
            }
            if (this.inventory.hasTrophy("item.trophy_skeleton")) {
                province.skeletonTrophy = true;
                worldData.setTrophySkeleton(province.id, true);
            }
            if (this.inventory.hasTrophy("item.trophy_spider")) {
                province.spiderTrophy = true;
                worldData.setTrophySpider(province.id, true);
            }
            if (this.inventory.hasTrophy("item.trophy_pig")) {
                province.zombiepigTrophy = true;
                worldData.setTrophyPig(province.id, true);
            }
        }
    }

    private void updateClientQuest() {
        if (!this.player.field_70170_p.field_72995_K) {
            Province province = CivilizationUtil.getProvinceAt(this.player.func_130014_f_(), this.player.field_70176_ah, this.player.field_70164_aj);
            QuestData currentQuest = PlayerCivilizationCapabilityImpl.get(this.player).getCurrentQuestFor(province);
            QuestData nextQuest = PlayerCivilizationCapabilityImpl.get(this.player).getNextQuestFor(province);
            ToroQuestPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetQuestInfo(province, currentQuest, nextQuest), (EntityPlayerMP)this.player);
        }
    }

    public class SlotTrophy
    extends Slot {
        public SlotTrophy(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }
}

