/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.torocraft.toroquest.block.BlockSmartBanner;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.generation.village.util.BlockMapBuilder;

public abstract class VillagePieceBlockMap
extends StructureVillagePieces.Village {
    static Random rand = new Random();
    public static final Map<String, IBlockState> DEFAULT_PALLETTE = new HashMap<String, IBlockState>();
    protected String name;

    public VillagePieceBlockMap(String name, StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bounds, EnumFacing facing) {
        super(start, type);
        this.name = name;
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
    }

    public VillagePieceBlockMap() {
    }

    protected boolean specialBlockHandling(World world, String c, int x, int y, int z) {
        return false;
    }

    protected int getYOffset() {
        return 0;
    }

    protected boolean specialHandlingForSpawner(World world, int x, int y, int z, List<String> entities) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (this.field_74887_e.func_175898_b((Vec3i)blockpos)) {
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityToroSpawner) {
                return true;
            }
            this.addToroSpawner(world, blockpos, entities);
        }
        return true;
    }

    protected void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        try {
            world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityToroSpawner) {
                TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
                spawner.setEntityIds(entities);
            }
        }
        catch (Exception e) {
            System.out.println("***error spawning ToroQuest entity***");
        }
    }

    protected boolean specialHandlingForSpawnerRaidedKing(World world, int x, int y, int z, List<String> entities) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (this.field_74887_e.func_175898_b((Vec3i)blockpos)) {
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityToroSpawner) {
                return true;
            }
            this.addToroSpawnerRaidedKing(world, blockpos, entities);
        }
        return true;
    }

    protected void addToroSpawnerRaidedKing(World world, BlockPos blockpos, List<String> entities) {
        try {
            world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityToroSpawner) {
                TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
                spawner.setEntityIds(entities);
                spawner.setExtra(1);
            }
        }
        catch (Exception e) {
            System.out.println("***error spawning ToroQuest entity***");
        }
    }

    public boolean func_74875_a(final World world, Random randomIn, final StructureBoundingBox structureBoundingBoxIn) {
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, structureBoundingBoxIn);
            if (this.field_143015_k < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + this.field_74887_e.func_78882_c() - 1 + this.getYOffset(), 0);
        }
        Map<String, IBlockState> palette = this.getBiomeSpecificPalette();
        new BlockMapBuilder(this.name){

            @Override
            protected void setBlockState(IBlockState block, int x, int y, int z) {
                VillagePieceBlockMap.this.func_175811_a(world, block, x, y, z, VillagePieceBlockMap.this.field_74887_e);
            }

            @Override
            protected void replaceAirAndLiquidDownwards(IBlockState block, int x, int y, int z) {
                VillagePieceBlockMap.this.func_175808_b(world, block, x, y, z, VillagePieceBlockMap.this.field_74887_e);
            }

            @Override
            protected boolean specialBlockHandling(String c, int x, int y, int z) {
                return VillagePieceBlockMap.this.specialBlockHandling(world, c, x, y, z);
            }

            @Override
            public String colorChange() {
                try {
                    CivilizationType civ = CivilizationUtil.getProvinceAt((World)world, (int)((structureBoundingBoxIn.field_78897_a + structureBoundingBoxIn.field_78893_d) / 32), (int)((structureBoundingBoxIn.field_78896_c + structureBoundingBoxIn.field_78892_f) / 32)).civilization;
                    switch (civ) {
                        case FIRE: {
                            return "*R";
                        }
                        case EARTH: {
                            return "*G";
                        }
                        case WATER: {
                            return "*U";
                        }
                        case MOON: {
                            return "*B";
                        }
                        case WIND: {
                            return "*W";
                        }
                        case SUN: {
                            return "*Y";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "**";
            }

            @Override
            public String bedChange(String s) {
                try {
                    CivilizationType civ = CivilizationUtil.getProvinceAt((World)world, (int)((structureBoundingBoxIn.field_78897_a + structureBoundingBoxIn.field_78893_d) / 32), (int)((structureBoundingBoxIn.field_78896_c + structureBoundingBoxIn.field_78892_f) / 32)).civilization;
                    switch (civ) {
                        case FIRE: {
                            return s.replace("$", "r");
                        }
                        case WATER: {
                            return s.replace("$", "u");
                        }
                        case EARTH: {
                            return s.replace("$", "g");
                        }
                        case MOON: {
                            return s.replace("$", "b");
                        }
                        case WIND: {
                            return s.replace("$", "y");
                        }
                        case SUN: {
                            return s.replace("$", "w");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.bedChange(s);
            }

            @Override
            public String carpetChange() {
                try {
                    CivilizationType civ = CivilizationUtil.getProvinceAt((World)world, (int)((structureBoundingBoxIn.field_78897_a + structureBoundingBoxIn.field_78893_d) / 32), (int)((structureBoundingBoxIn.field_78896_c + structureBoundingBoxIn.field_78892_f) / 32)).civilization;
                    switch (civ) {
                        case FIRE: {
                            return "*r";
                        }
                        case WATER: {
                            return "*u";
                        }
                        case EARTH: {
                            return "*g";
                        }
                        case MOON: {
                            return "*b";
                        }
                        case SUN: {
                            return "*y";
                        }
                        case WIND: {
                            return "*w";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.carpetChange();
            }

            @Override
            public String woolChange() {
                try {
                    CivilizationType civ = CivilizationUtil.getProvinceAt((World)world, (int)((structureBoundingBoxIn.field_78897_a + structureBoundingBoxIn.field_78893_d) / 32), (int)((structureBoundingBoxIn.field_78896_c + structureBoundingBoxIn.field_78892_f) / 32)).civilization;
                    switch (civ) {
                        case FIRE: {
                            return "wr";
                        }
                        case EARTH: {
                            return "wg";
                        }
                        case WATER: {
                            return "wu";
                        }
                        case MOON: {
                            return "wb";
                        }
                        case WIND: {
                            return "ww";
                        }
                        case SUN: {
                            return "wy";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.woolChange();
            }
        }.build(palette);
        return true;
    }

    private Map<String, IBlockState> getBiomeSpecificPalette() {
        HashMap<String, IBlockState> palette = new HashMap<String, IBlockState>();
        palette.putAll(DEFAULT_PALLETTE);
        this.alterPalette(palette);
        for (Map.Entry entry : palette.entrySet()) {
            entry.setValue(this.func_175847_a((IBlockState)entry.getValue()));
        }
        return palette;
    }

    protected IBlockState func_175847_a(IBlockState in) {
        if ((in = super.func_175847_a(in)).func_177230_c() instanceof BlockDoor) {
            in = this.biomeSpecificDoor(in);
        }
        return in;
    }

    protected IBlockState biomeSpecificDoor(IBlockState in) {
        BlockDoor newBlock;
        switch (this.field_189928_h) {
            case 2: {
                newBlock = Blocks.field_180410_as;
                break;
            }
            case 3: {
                newBlock = Blocks.field_180414_ap;
                break;
            }
            default: {
                newBlock = Blocks.field_180413_ao;
            }
        }
        return newBlock.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, in.func_177229_b((IProperty)BlockDoor.field_176520_a));
    }

    protected abstract void alterPalette(Map<String, IBlockState> var1);

    protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
        return 1;
    }

    public static ItemStack getBlackBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 2);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "mr");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cbo");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "ts");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "mr");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cre");
        patterntag.func_74768_a("Color", 7);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cs");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bs");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cre");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tt");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tl");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tr");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tts");
        patterntag.func_74768_a("Color", 2);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.GREEN, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setBlackBanner(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        ba.placeBlockAt(VillagePieceBlockMap.getBlackBanner(), null, world, pos, facing, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P());
    }

    public static ItemStack getGreenBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 2);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "bs");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cs");
        patterntag.func_74768_a("Color", 3);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "hh");
        patterntag.func_74768_a("Color", 2);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cre");
        patterntag.func_74768_a("Color", 2);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "sku");
        patterntag.func_74768_a("Color", 2);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "flo");
        patterntag.func_74768_a("Color", 10);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "mr");
        patterntag.func_74768_a("Color", 10);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.GREEN, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setGreenBanner(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        ba.placeBlockAt(VillagePieceBlockMap.getGreenBanner(), null, world, pos, EnumFacing.EAST, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P());
    }

    public static ItemStack getBlueBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 15);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "ls");
        patterntag.func_74768_a("Color", 4);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "ts");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "moj");
        patterntag.func_74768_a("Color", 6);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "moj");
        patterntag.func_74768_a("Color", 4);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bs");
        patterntag.func_74768_a("Color", 4);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "gra");
        patterntag.func_74768_a("Color", 6);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.BLUE, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setBlueBanner(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        ba.placeBlockAt(VillagePieceBlockMap.getBlueBanner(), null, world, pos, EnumFacing.EAST, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P());
    }

    public static ItemStack getBrownBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 3);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "gru");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "mc");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bt");
        patterntag.func_74768_a("Color", 3);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bts");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bts");
        patterntag.func_74768_a("Color", 3);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.BROWN, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setBrownBanner(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        ba.placeBlockAt(VillagePieceBlockMap.getBrownBanner(), null, world, pos, facing, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P());
    }

    public static ItemStack getRedBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 1);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "flo");
        patterntag.func_74768_a("Color", 2);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "moj");
        patterntag.func_74768_a("Color", 10);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "lud");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tl");
        patterntag.func_74768_a("Color", 9);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "tts");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cbo");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.RED, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setBannerRotation(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        Rotation rotation = Rotation.NONE;
        switch (facing) {
            case NORTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case SOUTH: {
                rotation = Rotation.NONE;
                break;
            }
            case WEST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        ItemStack banner = ItemStack.field_190927_a;
        try {
            CivilizationType civ = CivilizationUtil.getProvinceAt((World)world, (int)(pos.func_177958_n() / 16), (int)(pos.func_177952_p() / 16)).civilization;
            switch (civ) {
                case FIRE: {
                    banner = VillagePieceBlockMap.getRedBanner();
                    break;
                }
                case EARTH: {
                    banner = VillagePieceBlockMap.getGreenBanner();
                    break;
                }
                case WATER: {
                    banner = VillagePieceBlockMap.getBlueBanner();
                    break;
                }
                case MOON: {
                    banner = VillagePieceBlockMap.getBlackBanner();
                    break;
                }
                case WIND: {
                    banner = VillagePieceBlockMap.getBrownBanner();
                    break;
                }
                case SUN: {
                    banner = VillagePieceBlockMap.getYellowBanner();
                    break;
                }
                default: {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ba.placeBlockAt(banner, null, world, pos, facing, 0.0f, 0.0f, 0.0f, Blocks.field_180394_cL.func_176223_P().func_185907_a(rotation));
        ItemBanner.func_179224_a((World)world, null, (BlockPos)pos, (ItemStack)banner);
    }

    public static ItemStack getYellowBanner() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 14);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "sc");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "cbo");
        patterntag.func_74768_a("Color", 14);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bri");
        patterntag.func_74768_a("Color", 11);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "flo");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "gra");
        patterntag.func_74768_a("Color", 14);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "mc");
        patterntag.func_74768_a("Color", 11);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.ORANGE, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return banner;
    }

    public static void setYellowBanner(World world, BlockPos pos, EnumFacing facing) {
        ItemBanner ba = new ItemBanner();
        ba.placeBlockAt(VillagePieceBlockMap.getRedBanner(), null, world, pos, facing, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P());
    }

    public static void setBanditBanner(World world, BlockPos pos) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("Base", 8);
        NBTTagCompound patterntag = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        patterntag.func_74778_a("Pattern", "hhb");
        patterntag.func_74768_a("Color", 0);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "mr");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "hh");
        patterntag.func_74768_a("Color", 8);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "ms");
        patterntag.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "sku");
        patterntag.func_74768_a("Color", 15);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        patterntag = new NBTTagCompound();
        patterntag.func_74778_a("Pattern", "bo");
        patterntag.func_74768_a("Color", 8);
        nbttaglist.func_74742_a((NBTBase)patterntag);
        nbttagcompound.func_74782_a("Patterns", (NBTBase)nbttaglist);
        ItemBanner ba = new ItemBanner();
        ItemStack banner = ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.GRAY, (NBTTagList)nbttaglist);
        banner.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        Rotation rotation = Rotation.NONE;
        switch (world.field_73012_v.nextInt(4)) {
            case 0: {
                rotation = Rotation.NONE;
                break;
            }
            case 1: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case 3: {
                rotation = Rotation.CLOCKWISE_180;
            }
        }
        EnumFacing direction = EnumFacing.EAST;
        switch (world.field_73012_v.nextInt(4)) {
            case 0: {
                direction = EnumFacing.EAST;
                break;
            }
            case 1: {
                direction = EnumFacing.WEST;
                break;
            }
            case 2: {
                direction = EnumFacing.NORTH;
                break;
            }
            case 3: {
                direction = EnumFacing.SOUTH;
            }
        }
        ba.placeBlockAt(banner, null, world, pos, direction, 0.0f, 0.0f, 0.0f, Blocks.field_180393_cK.func_176223_P().func_185907_a(rotation));
    }

    static {
        DEFAULT_PALLETTE.put("--", Blocks.field_150350_a.func_176223_P());
        DEFAULT_PALLETTE.put("Cs", Blocks.field_150347_e.func_176223_P());
        DEFAULT_PALLETTE.put("Pw", Blocks.field_150344_f.func_176223_P());
        DEFAULT_PALLETTE.put("Sb", Blocks.field_150417_aV.func_176223_P());
        DEFAULT_PALLETTE.put("Dr", Blocks.field_150346_d.func_176223_P());
        DEFAULT_PALLETTE.put("Gr", Blocks.field_150349_c.func_176223_P());
        DEFAULT_PALLETTE.put("GP", Blocks.field_185774_da.func_176223_P());
        DEFAULT_PALLETTE.put("So", Blocks.field_150348_b.func_176223_P());
        DEFAULT_PALLETTE.put("sp", Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
        DEFAULT_PALLETTE.put("st", Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
        DEFAULT_PALLETTE.put("sb", Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
        DEFAULT_PALLETTE.put("Sw", Blocks.field_150376_bx.func_176223_P());
        DEFAULT_PALLETTE.put("pT", Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
        DEFAULT_PALLETTE.put("Fc", Blocks.field_150463_bK.func_176223_P());
        DEFAULT_PALLETTE.put("td", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("ti", Blocks.field_180400_cw.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("tt", Blocks.field_180400_cw.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTrapDoor.field_176285_M, (Comparable)BlockTrapDoor.DoorHalf.TOP));
        DEFAULT_PALLETTE.put("Lg", Blocks.field_150364_r.func_176223_P());
        DEFAULT_PALLETTE.put("Tv", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true)));
        DEFAULT_PALLETTE.put("T^", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true)));
        DEFAULT_PALLETTE.put("T>", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true)));
        DEFAULT_PALLETTE.put("T<", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true)));
        DEFAULT_PALLETTE.put("Lx", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
        DEFAULT_PALLETTE.put("Lz", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
        DEFAULT_PALLETTE.put("vv", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put("^^", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put(">>", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put("<<", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put("k>", Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put("k<", Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        DEFAULT_PALLETTE.put("Ss", Blocks.field_150333_U.func_176223_P());
        DEFAULT_PALLETTE.put("DS", Blocks.field_150334_T.func_176223_P());
        DEFAULT_PALLETTE.put("Gp", Blocks.field_150410_aZ.func_176223_P());
        DEFAULT_PALLETTE.put("Gs", Blocks.field_150426_aN.func_176223_P());
        DEFAULT_PALLETTE.put("cT", Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP).func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        DEFAULT_PALLETTE.put("Sc", Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        DEFAULT_PALLETTE.put("Sv", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("S^", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("S>", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("S<", Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("Gb", Blocks.field_150340_R.func_176223_P());
        DEFAULT_PALLETTE.put("Qs", Blocks.field_150333_U.func_176223_P());
        DEFAULT_PALLETTE.put("Qc", Blocks.field_150371_ca.func_176223_P().func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.CHISELED));
        DEFAULT_PALLETTE.put("Qx", Blocks.field_150371_ca.func_176223_P().func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Z));
        DEFAULT_PALLETTE.put("Qy", Blocks.field_150371_ca.func_176223_P().func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Y));
        DEFAULT_PALLETTE.put("An", Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH));
        DEFAULT_PALLETTE.put("wR", Blocks.field_150348_b.func_176223_P());
        DEFAULT_PALLETTE.put("FF", Blocks.field_150480_ab.func_176223_P());
        DEFAULT_PALLETTE.put("BS", Blocks.field_150342_X.func_176223_P());
        DEFAULT_PALLETTE.put("Wp", Blocks.field_150452_aw.func_176223_P());
        DEFAULT_PALLETTE.put("Fw", Blocks.field_180407_aO.func_176223_P());
        DEFAULT_PALLETTE.put("F<", Blocks.field_150470_am.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("CT", Block.func_149684_b((String)ToroQuestConfiguration.craftingTableResourceName).func_176223_P());
        DEFAULT_PALLETTE.put("CA", Blocks.field_150383_bp.func_176223_P());
        DEFAULT_PALLETTE.put("SK", Blocks.field_150465_bP.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)EnumFacing.UP));
        IBlockState CHAIR_NORTH = Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        IBlockState CHAIR_SOUTH = Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        IBlockState CHAIR_EAST = Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        IBlockState CHAIR_WEST = Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        try {
            CHAIR_NORTH = Block.func_149684_b((String)ToroQuestConfiguration.chairResourceName).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            CHAIR_SOUTH = Block.func_149684_b((String)ToroQuestConfiguration.chairResourceName).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            CHAIR_EAST = Block.func_149684_b((String)ToroQuestConfiguration.chairResourceName).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            CHAIR_WEST = Block.func_149684_b((String)ToroQuestConfiguration.chairResourceName).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("!v", CHAIR_NORTH);
        DEFAULT_PALLETTE.put("!^", CHAIR_SOUTH);
        DEFAULT_PALLETTE.put("!>", CHAIR_EAST);
        DEFAULT_PALLETTE.put("!<", CHAIR_WEST);
        IBlockState LA = Blocks.field_150350_a.func_176223_P();
        try {
            LA = Block.func_149684_b((String)ToroQuestConfiguration.lanternResourceName).func_176223_P().func_177226_a((IProperty)PropertyDirection.func_177714_a((String)"facing"), (Comparable)EnumFacing.DOWN);
        }
        catch (Exception e) {
            try {
                LA = Block.func_149684_b((String)ToroQuestConfiguration.lanternResourceName).func_176223_P();
            }
            catch (Exception ee) {
                LA = Blocks.field_150426_aN.func_176223_P();
            }
        }
        DEFAULT_PALLETTE.put("LA", LA);
        IBlockState CH = Blocks.field_150411_aY.func_176223_P();
        try {
            CH = Block.func_149684_b((String)ToroQuestConfiguration.chainResourceName).func_176223_P();
        }
        catch (Exception e) {
            try {
                CH = Block.func_149684_b((String)"futuremc:chain").func_176223_P();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DEFAULT_PALLETTE.put("CH", CH);
        IBlockState CHICKEN = Blocks.field_150414_aQ.func_176223_P();
        try {
            CHICKEN = Block.func_149684_b((String)ToroQuestConfiguration.turkeyBlockResourceName).func_176223_P();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("!C", CHICKEN);
        IBlockState CAKE = Blocks.field_150414_aQ.func_176223_P();
        try {
            CAKE = Block.func_149684_b((String)ToroQuestConfiguration.cakeBlockResourceName).func_176223_P();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("!D", CAKE);
        IBlockState TABLE = Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
        try {
            TABLE = Block.func_149684_b((String)ToroQuestConfiguration.tableResourceName).func_176223_P();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("!T", TABLE);
        IBlockState CHANDELIER = Blocks.field_150364_r.func_176223_P();
        try {
            CHANDELIER = Block.func_149684_b((String)ToroQuestConfiguration.chandelierResourceName).func_176223_P();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("!A", CHANDELIER);
        DEFAULT_PALLETTE.put("l^", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("lv", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("l<", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("l>", Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("Qv", Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("Q^", Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("Q>", Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("Q<", Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("Cv", Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("C^", Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("C>", Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("C<", Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("dv", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("d^", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("d>", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("d<", Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.WEST));
        DEFAULT_PALLETTE.put("cv", Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("c^", Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("c>", Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("c<", Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST));
        IBlockState TORCH = Blocks.field_150478_aa.func_176223_P();
        IBlockState TORCH_NORTH = TORCH.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
        IBlockState TORCH_SOUTH = TORCH.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
        IBlockState TORCH_EAST = TORCH.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
        IBlockState TORCH_WEST = TORCH.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
        try {
            IBlockState CANDLE = Block.func_149684_b((String)ToroQuestConfiguration.candleResourceName).func_176223_P();
            TORCH_NORTH = CANDLE.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH);
            TORCH_SOUTH = CANDLE.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH);
            TORCH_EAST = CANDLE.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
            TORCH_WEST = CANDLE.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
        }
        catch (Exception CANDLE) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("t^", TORCH_NORTH);
        DEFAULT_PALLETTE.put("tv", TORCH_SOUTH);
        DEFAULT_PALLETTE.put("t<", TORCH_EAST);
        DEFAULT_PALLETTE.put("t>", TORCH_WEST);
        DEFAULT_PALLETTE.put("t.", TORCH);
        DEFAULT_PALLETTE.put("bv", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH));
        DEFAULT_PALLETTE.put("b^", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.SOUTH));
        DEFAULT_PALLETTE.put("b>", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.EAST));
        DEFAULT_PALLETTE.put("b<", Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.WEST));
        IBlockState ET = Blocks.field_150381_bn.func_176223_P();
        try {
            ET = Block.func_149684_b((String)ToroQuestConfiguration.enchantingTableResourceName).func_176223_P();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PALLETTE.put("ET", ET);
        DEFAULT_PALLETTE.put("IP", Blocks.field_150443_bT.func_176223_P());
        DEFAULT_PALLETTE.put("LP", Blocks.field_150445_bS.func_176223_P());
        DEFAULT_PALLETTE.put("JJ", Blocks.field_150421_aI.func_176223_P());
        DEFAULT_PALLETTE.put("FL", Blocks.field_150457_bL.func_176223_P());
        DEFAULT_PALLETTE.put("EM", Blocks.field_150475_bE.func_176223_P());
        DEFAULT_PALLETTE.put("*r", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
        DEFAULT_PALLETTE.put("*g", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GREEN));
        DEFAULT_PALLETTE.put("*u", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN));
        DEFAULT_PALLETTE.put("*b", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK));
        DEFAULT_PALLETTE.put("*w", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN));
        DEFAULT_PALLETTE.put("*y", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW));
        DEFAULT_PALLETTE.put("*c", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        DEFAULT_PALLETTE.put("cc", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        DEFAULT_PALLETTE.put("co", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE));
        DEFAULT_PALLETTE.put("cp", Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.PURPLE));
        DEFAULT_PALLETTE.put("wr", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
        DEFAULT_PALLETTE.put("wg", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GREEN));
        DEFAULT_PALLETTE.put("wu", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN));
        DEFAULT_PALLETTE.put("wb", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK));
        DEFAULT_PALLETTE.put("ww", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN));
        DEFAULT_PALLETTE.put("wy", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW));
        DEFAULT_PALLETTE.put("wc", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        DEFAULT_PALLETTE.put("WW", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        DEFAULT_PALLETTE.put("WO", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE));
        DEFAULT_PALLETTE.put("WP", Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.PURPLE));
        DEFAULT_PALLETTE.put("*R", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
        DEFAULT_PALLETTE.put("*G", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GREEN));
        DEFAULT_PALLETTE.put("*U", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN));
        DEFAULT_PALLETTE.put("*B", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK));
        DEFAULT_PALLETTE.put("*W", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN));
        DEFAULT_PALLETTE.put("*Y", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW));
        DEFAULT_PALLETTE.put("*C", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        DEFAULT_PALLETTE.put("CC", Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE));
        BlockSmartBanner banner = new BlockSmartBanner();
        banner.setFacing(EnumFacing.NORTH);
        DEFAULT_PALLETTE.put("@v", banner.func_176223_P());
        banner = new BlockSmartBanner();
        banner.setFacing(EnumFacing.SOUTH);
        DEFAULT_PALLETTE.put("@^", banner.func_176223_P());
        banner = new BlockSmartBanner();
        banner.setFacing(EnumFacing.EAST);
        DEFAULT_PALLETTE.put("@>", banner.func_176223_P());
        banner = new BlockSmartBanner();
        banner.setFacing(EnumFacing.WEST);
        DEFAULT_PALLETTE.put("@<", banner.func_176223_P());
        DEFAULT_PALLETTE.put("tA", Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
    }
}

