/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village.util;

import java.io.IOException;
import java.util.Map;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.torocraft.toroquest.generation.village.util.BlockMapBase;

public abstract class BlockMapBuilder
extends BlockMapBase {
    private Map<String, IBlockState> palette;

    protected abstract void setBlockState(IBlockState var1, int var2, int var3, int var4);

    protected abstract void replaceAirAndLiquidDownwards(IBlockState var1, int var2, int var3, int var4);

    public BlockMapBuilder(String name) {
        super(name);
    }

    public void build(Map<String, IBlockState> palette) {
        this.palette = palette;
        this.load();
        this.x = 0;
        this.y = 0;
        this.z = 0;
        if (this.reader == null) {
            return;
        }
        try {
            while ((this.line = this.reader.readLine()) != null) {
                this.handleLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to build village piece NAME[" + this.name + "]: " + e.getMessage());
        }
    }

    private void handleLine() {
        if (this.line == null) {
            return;
        }
        if (this.line.matches("#{4,}")) {
            ++this.y;
            this.z = 0;
            return;
        }
        this.x = 0;
        char[] a = this.line.toCharArray();
        for (int i = 0; i < a.length - 1; i += 2) {
            this.placeBlock(String.valueOf(a[i]) + String.valueOf(a[i + 1]));
            ++this.x;
        }
        ++this.z;
    }

    protected abstract boolean specialBlockHandling(String var1, int var2, int var3, int var4);

    public String colorChange() {
        return "CC";
    }

    public String carpetChange() {
        return "cc";
    }

    public void bannerChange(String s) {
    }

    public String bedChange(String s) {
        return s;
    }

    public String woolChange() {
        return "WW";
    }

    public String flowerChange() {
        return "FL";
    }

    private void placeBlock(String c) {
        if (c.equals("  ")) {
            return;
        }
        if (this.specialBlockHandling(c, this.x, this.y, this.z)) {
            return;
        }
        IBlockState block = this.palette.get(c);
        if (c.equals("*C")) {
            block = this.palette.get(this.colorChange());
        } else if (c.equals("*c")) {
            block = this.palette.get(this.carpetChange());
        } else if (c.equals("wc")) {
            block = this.palette.get(this.woolChange());
        } else if (c.equals("FL")) {
            block = this.palette.get(this.flowerChange());
        }
        if (block == null) {
            return;
        }
        if (this.y == 0 && this.blockIsRepeatable(block)) {
            this.replaceAirAndLiquidDownwards(block, this.x, this.y, this.z);
        } else {
            this.setBlockState(block, this.x, this.y, this.z);
            this.handleExtraBedBlock(block, c);
            this.handleExtraDoorBlock(block, c);
        }
    }

    private boolean blockIsRepeatable(IBlockState block) {
        return !(block instanceof BlockStairs) && !(block instanceof BlockDoor);
    }

    private void handleExtraDoorBlock(IBlockState block, String c) {
        if (!this.isDoor(c)) {
            return;
        }
        block = block.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
        this.setBlockState(block, this.x, this.y + 1, this.z);
    }

    private boolean isDoor(String c) {
        return c.startsWith("d") && (c.equals("d^") || c.equals("dv") || c.equals("d<") || c.equals("d>"));
    }

    protected void handleExtraBedBlock(IBlockState block, String c) {
        if (!this.isBed(c)) {
            return;
        }
        block = block.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
        switch ((EnumFacing)block.func_177229_b((IProperty)BlockBed.field_185512_D)) {
            case EAST: {
                this.setBlockState(block, this.x + 1, this.y, this.z);
                break;
            }
            case NORTH: {
                this.setBlockState(block, this.x, this.y, this.z + 1);
                break;
            }
            case SOUTH: {
                this.setBlockState(block, this.x, this.y, this.z - 1);
                break;
            }
            case WEST: {
                this.setBlockState(block, this.x - 1, this.y, this.z);
                break;
            }
        }
    }

    protected boolean isBed(String c) {
        return c.startsWith("b") && (c.equals("b^") || c.equals("bv") || c.equals("b<") || c.equals("b>"));
    }
}

