/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.torocraft.toroquest.generation.village.VillageHandlerShop;
import net.torocraft.toroquest.generation.village.util.VillagePieceBlockMap;

public class VillageHandlerWall
implements VillagerRegistry.IVillageCreationHandler {
    protected static final String NAME = "tqr_wall";

    public static void init() {
        MapGenStructureIO.func_143031_a(VillagePieceWall.class, (String)NAME);
        MapGenStructureIO.func_143031_a(VillagePieceWall.class, (String)"tqr_wall_destroyed");
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerWall());
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        return new StructureVillagePieces.PieceWeight(VillagePieceWall.class, 30, 2);
    }

    public Class<?> getComponentClass() {
        return VillagePieceWall.class;
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        return VillagePieceWall.createPiece(startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public static void registerComponent(Class<? extends StructureVillagePieces.Village> clazz, int weight, int min, int max) {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerWall());
    }

    public static void setBlock(World world, int i, int dy, int j, IBlockState blockBase, int blockBaseMeta) {
        world.func_175656_a(new BlockPos(i, dy, j), blockBase);
    }

    public static void setBlock(World world, int i, int j, int k, IBlockState blockBase, int blockBaseMeta, boolean b) {
        world.func_175656_a(new BlockPos(i, j, k), blockBase);
    }

    public static class VillagePieceWall
    extends VillagePieceBlockMap {
        private StructureVillagePieces.Start start;
        private List pieces;
        private boolean hasMadeWallBlock;

        public VillagePieceWall() {
        }

        public static VillageHandlerShop.VillagePieceShop createPiece(StructureVillagePieces.Start start, List<StructureComponent> structures, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            BlockPos size = new BlockPos(0, 1, 0);
            StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)size.func_177958_n(), (int)size.func_177956_o(), (int)size.func_177952_p(), (EnumFacing)facing);
            return VillagePieceWall.func_74895_a((StructureBoundingBox)bounds) && StructureComponent.func_74883_a(structures, (StructureBoundingBox)bounds) == null ? new VillageHandlerShop.VillagePieceShop(VillageHandlerWall.NAME, start, type, rand, bounds, facing) : null;
        }

        public VillagePieceWall(String name, StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bounds, EnumFacing facing) {
            super(name, start, type, rand, bounds, facing);
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> pieces, Random rand) {
            super.func_74861_a(component, pieces, rand);
            this.pieces = pieces;
        }

        @Override
        public boolean func_74875_a(World world, Random rand, StructureBoundingBox bounds) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(world, bounds);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            boolean x = true;
            boolean z = true;
            int xCoord = this.func_74865_a(1, 1);
            int yCoord = this.func_74862_a(1);
            int zCoord = this.func_74873_b(1, 1);
            if (this.pieces != null && bounds.func_175898_b(new Vec3i(xCoord, yCoord, zCoord))) {
                BlockVillageWallGen.TileEntityVillageWallGen tile = new BlockVillageWallGen.TileEntityVillageWallGen();
                tile.func_174878_a(new BlockPos(xCoord, yCoord, zCoord));
                tile.setStructure(this.pieces, this.start);
            }
            return true;
        }

        public static void placeWalls(World world, List<StructureBounds> bb, int xCoord, int yCoord, int zCoord, Biome biome, boolean desert) {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            System.out.println("Generating town walls at " + xCoord + " " + yCoord + " " + zCoord);
            for (int i = 0; i < bb.size(); ++i) {
                minX = Math.min(bb.get((int)i).field_78897_a, minX);
                minZ = Math.min(bb.get((int)i).field_78896_c, minZ);
                maxX = Math.max(bb.get((int)i).field_78893_d, maxX);
                maxZ = Math.max(bb.get((int)i).field_78892_f, maxZ);
            }
            if (maxX != Integer.MIN_VALUE && minX != Integer.MAX_VALUE && maxZ != Integer.MIN_VALUE && minZ != Integer.MAX_VALUE) {
                byte[][] a = new byte[maxX - minX + 3][maxZ - minZ + 3];
                short[][] b = new short[maxX - minX + 3][maxZ - minZ + 3];
                for (int j = 0; j < bb.size(); ++j) {
                    int w = bb.get((int)j).field_78893_d - bb.get((int)j).field_78897_a + 1;
                    int wMid = w / 2 + bb.get((int)j).field_78897_a - 1;
                    int h = bb.get((int)j).field_78892_f - bb.get((int)j).field_78896_c + 1;
                    int hMid = h / 2 + bb.get((int)j).field_78896_c - 1;
                    for (int x = bb.get((int)j).field_78897_a; x <= bb.get((int)j).field_78893_d; ++x) {
                        for (int z = bb.get((int)j).field_78896_c; z <= bb.get((int)j).field_78892_f; ++z) {
                            int mx = x - minX + 1;
                            int mz = z - minZ + 1;
                            a[mx][mz] = !bb.get((int)j).ew && (z == bb.get((int)j).field_78896_c || z == bb.get((int)j).field_78892_f) && x >= wMid - 1 && x <= wMid + 1 ? 3 : (bb.get((int)j).ew && (x == bb.get((int)j).field_78897_a || x == bb.get((int)j).field_78893_d) && z >= hMid - 1 && z <= hMid + 1 ? 3 : 2);
                        }
                    }
                }
                int range = 7;
                for (int x2 = 1; x2 < a.length - range; ++x2) {
                    for (int z2 = 1; z2 < a[x2].length - range; ++z2) {
                        if (a[x2][z2] != 2) continue;
                        for (int p = 1; p < range; ++p) {
                            int p2;
                            if (a[x2 + p][z2] == 2 && a[x2 + p - 1][z2] == 0) {
                                for (p2 = p; p2 > 0; --p2) {
                                    a[x2 + p2][z2] = 2;
                                }
                            }
                            if (a[x2][z2 + p] != 2 || a[x2][z2 + p - 1] != 0) continue;
                            for (p2 = p; p2 > 0; --p2) {
                                a[x2][z2 + p2] = 2;
                            }
                        }
                    }
                }
                for (int x2 = 1; x2 < a.length - 1; ++x2) {
                    for (int z2 = 1; z2 < a[x2].length - 1; ++z2) {
                        boolean nw;
                        boolean n = a[x2][z2 - 1] == 0;
                        boolean s = a[x2][z2 + 1] == 0;
                        boolean e = a[x2 + 1][z2] == 0;
                        boolean w2 = a[x2 - 1][z2] == 0;
                        boolean ne = a[x2 + 1][z2 - 1] == 0;
                        boolean sw = a[x2 - 1][z2 + 1] == 0;
                        boolean se = a[x2 + 1][z2 + 1] == 0;
                        boolean bl = nw = a[x2 - 1][z2 - 1] == 0;
                        if (n || s || e || w2 || ne || se || nw || sw) continue;
                        a[x2][z2] = 1;
                    }
                }
                IBlockState blockBase = Blocks.field_150417_aV.func_176223_P();
                IBlockState blockFence = Blocks.field_150463_bK.func_176223_P();
                IBlockState stairsBlock = Blocks.field_150390_bg.func_176223_P();
                int blockBaseMeta = 0;
                int guardDist = 0;
                for (int x3 = 1; x3 < a.length - 1; ++x3) {
                    for (int z3 = 1; z3 < a[x3].length - 1; ++z3) {
                        int lowestY;
                        boolean nw2;
                        boolean n2 = a[x3][z3 - 1] >= 2;
                        boolean s2 = a[x3][z3 + 1] >= 2;
                        boolean e2 = a[x3 + 1][z3] >= 2;
                        boolean w3 = a[x3 - 1][z3] >= 2;
                        boolean ne2 = a[x3 + 1][z3 - 1] >= 2;
                        boolean sw2 = a[x3 - 1][z3 + 1] >= 2;
                        boolean se2 = a[x3 + 1][z3 + 1] >= 2;
                        boolean bl = nw2 = a[x3 - 1][z3 - 1] >= 2;
                        if (a[x3][z3] < 2) continue;
                        int dx = minX + x3;
                        int dz = minZ + z3;
                        boolean solidCount = false;
                        int dy = 0;
                        int minHeight = 9;
                        int startY = dy + 9;
                        int near = Math.max(Math.max(Math.max(b[x3 - 1][z3], b[x3 + 1][z3]), b[x3][z3 + 1]), b[x3][z3 - 1]);
                        if (near > 0) {
                            if (near > startY) {
                                startY = near - 1;
                            } else if (near < startY) {
                                startY = near + 1;
                            }
                        }
                        if (startY - (lowestY = dy) > 0) {
                            b[x3][z3] = (short)Math.min(Math.max(startY, 0), Short.MAX_VALUE);
                        }
                        for (dy = startY; dy > lowestY; --dy) {
                            boolean wg;
                            boolean gate;
                            if (dy == startY) {
                                if (!(ne2 || n2 || e2)) {
                                    VillageHandlerWall.setBlock(world, dx + 2, dy, dz - 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy, dz - 1, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 1, dy, dz - 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy + 1, dz - 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy + 1, dz - 1, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx + 1, dy + 1, dz - 2, blockBase, blockBaseMeta, false);
                                }
                                if (!(nw2 || n2 || w3)) {
                                    VillageHandlerWall.setBlock(world, dx - 2, dy, dz - 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 1, dy, dz - 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy, dz - 1, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy + 1, dz - 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx - 1, dy + 1, dz - 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy + 1, dz - 1, blockBase, blockBaseMeta, false);
                                }
                                if (!(se2 || s2 || e2)) {
                                    VillageHandlerWall.setBlock(world, dx + 2, dy, dz + 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 1, dy, dz + 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy, dz + 1, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy + 1, dz + 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx + 1, dy + 1, dz + 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy + 1, dz + 1, blockBase, blockBaseMeta, false);
                                }
                                if (!(sw2 || s2 || w3)) {
                                    VillageHandlerWall.setBlock(world, dx - 2, dy, dz + 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 1, dy, dz + 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy, dz + 1, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy + 1, dz + 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx - 1, dy + 1, dz + 2, blockBase, blockBaseMeta, false);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy + 1, dz + 1, blockBase, blockBaseMeta, false);
                                }
                                if (!(n2 || ne2 || nw2)) {
                                    VillageHandlerWall.setBlock(world, dx, dy, dz - 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx, dy + 1, dz - 2, stairsBlock, 0, false);
                                }
                                if (!(e2 || se2 || ne2)) {
                                    VillageHandlerWall.setBlock(world, dx + 2, dy, dz, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx + 2, dy + 1, dz, stairsBlock, 2, false);
                                }
                                if (!(s2 || se2 || sw2)) {
                                    VillageHandlerWall.setBlock(world, dx, dy, dz + 2, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx, dy + 1, dz + 2, stairsBlock, 0, false);
                                }
                                if (!(w3 || nw2 || sw2)) {
                                    VillageHandlerWall.setBlock(world, dx - 2, dy, dz, blockBase, blockBaseMeta);
                                    VillageHandlerWall.setBlock(world, dx - 2, dy + 1, dz, stairsBlock, 2, false);
                                }
                                if (++guardDist <= 200) continue;
                                guardDist = 0;
                                continue;
                            }
                            int distCheck = 4;
                            boolean bl2 = gate = a[x3][z3] == 3 && (x3 > 4 && x3 < a.length - 4 && a[x3 - 4][z3] == 2 && a[x3 + 4][z3] == 2 || z3 > 4 && z3 < a[x3].length - 4 && a[x3][z3 - 4] == 2 && a[x3][z3 + 4] == 2);
                            if (gate && dy == startY - 3) {
                                world.func_175656_a(new BlockPos(dx, dy, dz), blockFence);
                                if (a[x3 + 1][z3] != 3 || a[x3 - 1][z3] != 3) {
                                    if (a[x3 + 1][z3] == 3) {
                                        world.func_175656_a(new BlockPos(dx, dy, dz - 1), stairsBlock);
                                        world.func_175656_a(new BlockPos(dx, dy, dz + 1), stairsBlock);
                                    } else if (a[x3 - 1][z3] == 3) {
                                        world.func_175656_a(new BlockPos(dx, dy, dz - 1), stairsBlock);
                                        world.func_175656_a(new BlockPos(dx, dy, dz + 1), stairsBlock);
                                    } else if (a[x3][z3 + 1] != 3 || a[x3][z3 - 1] != 3) {
                                        if (a[x3][z3 - 1] == 3) {
                                            world.func_175656_a(new BlockPos(dx, dy, dz - 1), stairsBlock);
                                            world.func_175656_a(new BlockPos(dx, dy, dz + 1), stairsBlock);
                                        } else if (a[x3][z3 + 1] == 3) {
                                            world.func_175656_a(new BlockPos(dx, dy, dz - 1), stairsBlock);
                                            world.func_175656_a(new BlockPos(dx, dy, dz + 1), stairsBlock);
                                        }
                                    }
                                }
                            }
                            if (gate && dy <= startY - 3) continue;
                            world.func_175656_a(new BlockPos(dx, dy, dz), blockBase);
                            boolean ng = a[x3][z3 - 1] == 3;
                            boolean sg = a[x3][z3 + 1] == 3;
                            boolean eg = a[x3 + 1][z3] == 3;
                            boolean bl3 = wg = a[x3 - 1][z3] == 3;
                            if (!ng) {
                                world.func_175656_a(new BlockPos(dx, dy, dz - 1), blockBase);
                            }
                            if (!ng && !eg) {
                                world.func_175656_a(new BlockPos(dx + 1, dy, dz - 1), blockBase);
                            }
                            if (!ng && !wg) {
                                world.func_175656_a(new BlockPos(dx - 1, dy, dz - 1), blockBase);
                            }
                            if (!eg) {
                                world.func_175656_a(new BlockPos(dx + 1, dy, dz), blockBase);
                            }
                            if (!sg) {
                                world.func_175656_a(new BlockPos(dx, dy, dz + 1), blockBase);
                            }
                            if (!sg && !eg) {
                                world.func_175656_a(new BlockPos(dx + 1, dy, dz + 1), blockBase);
                            }
                            if (!sg && !wg) {
                                world.func_175656_a(new BlockPos(dx - 1, dy, dz + 1), blockBase);
                            }
                            if (wg) continue;
                            world.func_175656_a(new BlockPos(dx - 1, dy, dz), blockBase);
                        }
                    }
                }
            }
        }

        @Override
        protected void alterPalette(Map<String, IBlockState> palette) {
        }

        public static class BlockVillageWallGen
        extends BlockContainer {
            public BlockVillageWallGen() {
                super(Material.field_151579_a);
            }

            public TileEntity func_149915_a(World worldIn, int meta) {
                return new TileEntityVillageWallGen();
            }

            public static class TileEntityVillageWallGen
            extends TileEntity
            implements ITickable {
                private List<StructureBounds> bb;
                private Biome biome;
                private boolean desert;

                public void func_73660_a() {
                    if (!this.func_145831_w().field_72995_K && this.bb != null) {
                        VillagePieceWall.placeWalls(this.func_145831_w(), this.bb, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.biome, this.desert);
                        this.bb = null;
                        this.func_145831_w().func_175698_g(this.func_174877_v());
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    } else if (!this.func_145831_w().field_72995_K) {
                        this.bb = null;
                        this.func_145831_w().func_175698_g(this.func_174877_v());
                        this.func_145831_w().func_175713_t(this.func_174877_v());
                    }
                }

                public void setStructure(List<StructureComponent> pieces, StructureVillagePieces.Start start) {
                    this.biome = start.biome;
                    this.desert = this.biome.field_76752_A instanceof BlockSand;
                    this.bb = new ArrayList<StructureBounds>();
                    for (StructureComponent obj : pieces) {
                        if (!(obj instanceof StructureVillagePieces.Path)) continue;
                        this.bb.add(new StructureBounds((StructureVillagePieces.Path)obj, 20, 7));
                    }
                }
            }
        }

        public static class StructureBounds
        extends StructureBoundingBox {
            public final boolean ew;

            public StructureBounds(StructureVillagePieces.Path path, int expansionX, int expansionZ) {
                this(path.func_74874_b(), expansionX, expansionZ);
            }

            public StructureBounds(StructureBoundingBox bb, int expansionX, int expansionZ) {
                this(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c, bb.field_78893_d, bb.field_78894_e, bb.field_78892_f, expansionX, expansionZ);
            }

            public StructureBounds(int x, int y, int z, int x2, int y2, int z2, int expansionX, int expansionZ) {
                boolean bl = this.ew = x2 - x > z2 - z;
                if (this.ew) {
                    this.field_78897_a = x - expansionZ;
                    this.field_78893_d = x2 + expansionZ;
                    this.field_78896_c = z - expansionX;
                    this.field_78892_f = z2 + expansionX;
                } else {
                    this.field_78897_a = x - expansionX;
                    this.field_78893_d = x2 + expansionX;
                    this.field_78896_c = z - expansionZ;
                    this.field_78892_f = z2 + expansionZ;
                }
                this.field_78895_b = y;
                this.field_78894_e = y2;
            }
        }
    }
}

