/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityVillageLord;
import net.torocraft.toroquest.generation.village.util.BlockMapMeasurer;
import net.torocraft.toroquest.generation.village.util.VillagePieceBlockMap;

public class VillageHandlerKeep
implements VillagerRegistry.IVillageCreationHandler {
    protected static final String NAME = "tqr_keep";

    public static void init() {
        MapGenStructureIO.func_143031_a(VillagePieceKeep.class, (String)NAME);
        MapGenStructureIO.func_143031_a(VillagePieceKeep.class, (String)"tqr_keep_destroyed");
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerKeep());
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        return new StructureVillagePieces.PieceWeight(VillagePieceKeep.class, 30, 1);
    }

    public Class<?> getComponentClass() {
        return VillagePieceKeep.class;
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        return VillagePieceKeep.createPiece(startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public static void setSlot(TileEntityChest chest, int index, @Nullable ItemStack stack) {
        if (chest.func_70301_a(index).func_190926_b()) {
            chest.func_70299_a(index, stack);
        }
    }

    public static class VillagePieceKeep
    extends VillagePieceBlockMap {
        @Override
        protected int getYOffset() {
            return -1;
        }

        public static VillagePieceKeep createPiece(StructureVillagePieces.Start start, List<StructureComponent> structures, Random rand, int x, int y, int z, EnumFacing facing, int p_175850_7_) {
            BlockPos size;
            StructureBoundingBox bounds;
            if (ToroQuestConfiguration.disableKeep) {
                return null;
            }
            int i = ToroQuestConfiguration.destroyedVillagesNearSpawnDistance;
            String nameType = VillageHandlerKeep.NAME;
            if (i > 0 && Math.abs(x) < i && Math.abs(z) < i) {
                nameType = nameType + "_destroyed";
            }
            return VillagePieceKeep.func_74895_a((StructureBoundingBox)(bounds = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)1, (int)0, (int)-4, (int)(size = new BlockMapMeasurer(nameType).measure()).func_177958_n(), (int)size.func_177956_o(), (int)size.func_177952_p(), (EnumFacing)EnumFacing.NORTH))) && StructureComponent.func_74883_a(structures, (StructureBoundingBox)bounds) == null ? new VillagePieceKeep(nameType, start, p_175850_7_, rand, bounds, EnumFacing.NORTH) : null;
        }

        public VillagePieceKeep(String name, StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bounds, EnumFacing facing) {
            super(name, start, type, rand, bounds, EnumFacing.NORTH);
            this.func_186164_a(EnumFacing.NORTH);
        }

        public VillagePieceKeep() {
        }

        @Override
        protected boolean specialBlockHandling(World world, String c, int x, int y, int z) {
            if (world.field_72995_K) {
                return false;
            }
            if (c.equals("xx")) {
                ArrayList<String> entities = new ArrayList<String>();
                entities.add("toroquest:" + EntityGuard.NAME);
                return this.specialHandlingForSpawner(world, x, y, z, entities);
            }
            if (c.equals("xl")) {
                ArrayList<String> villageLord = new ArrayList<String>();
                villageLord.add("toroquest:" + EntityVillageLord.NAME);
                return this.specialHandlingForSpawner(world, x, y, z, villageLord);
            }
            if (c.equals("BB")) {
                ArrayList<String> bandit = new ArrayList<String>();
                bandit.add("toroquest:" + EntitySentry.NAME);
                return this.specialHandlingForSpawner(world, x, y, z, bandit);
            }
            if (c.equals("cv")) {
                this.setChestBlockState(world, Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH), x, y, z, this.field_74887_e);
                return true;
            }
            if (c.equals("c^")) {
                this.setChestBlockState(world, Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), x, y, z, this.field_74887_e);
                return true;
            }
            if (c.equals("c>")) {
                this.setChestBlockState(world, Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST), x, y, z, this.field_74887_e);
                return true;
            }
            if (c.equals("c<")) {
                this.setChestBlockState(world, Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST), x, y, z, this.field_74887_e);
                return true;
            }
            if (c.equals("xr")) {
                ArrayList<String> villageLord = new ArrayList<String>();
                villageLord.add("toroquest:" + EntityVillageLord.NAME);
                return this.specialHandlingForSpawnerRaidedKing(world, x, y, z, villageLord);
            }
            return false;
        }

        protected void setChestBlockState(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            if (worldIn.field_72995_K) {
                return;
            }
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingboxIn.func_175898_b((Vec3i)blockpos) && !(worldIn.func_180495_p(blockpos) instanceof BlockChest)) {
                this.func_175811_a(worldIn, blockstateIn, x, y, z, this.field_74887_e);
                TileEntity tileentity = worldIn.func_175625_s(blockpos);
                if (tileentity instanceof TileEntityChest) {
                    int i;
                    TileEntityChest t = (TileEntityChest)tileentity;
                    VillageHandlerKeep.setSlot(t, worldIn.field_73012_v.nextInt(27), new ItemStack(Item.func_111206_d((String)"toroquest:recruitment_papers"), 1));
                    for (i = worldIn.field_73012_v.nextInt(3); i > 0; --i) {
                        VillageHandlerKeep.setSlot(t, worldIn.field_73012_v.nextInt(27), new ItemStack(Items.field_151166_bC, 1));
                    }
                    for (i = worldIn.field_73012_v.nextInt(2); i > 0; --i) {
                        VillageHandlerKeep.setSlot(t, worldIn.field_73012_v.nextInt(27), new ItemStack(Items.field_151043_k, 1));
                    }
                    for (i = worldIn.field_73012_v.nextInt(3); i > 0; --i) {
                        VillageHandlerKeep.setSlot(t, worldIn.field_73012_v.nextInt(27), new ItemStack(Items.field_151074_bl, worldIn.field_73012_v.nextInt(5) + 1));
                    }
                }
            }
        }

        @Override
        protected void alterPalette(Map<String, IBlockState> palette) {
        }
    }
}

