/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation.village;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.generation.village.util.BlockMapMeasurer;
import net.torocraft.toroquest.generation.village.util.VillagePieceBlockMap;

public class VillageHandlerGuardTower
implements VillagerRegistry.IVillageCreationHandler {
    protected static final String NAME = "tqr_guardtower";

    public static void init() {
        MapGenStructureIO.func_143031_a(VillagePieceGuardTower.class, (String)NAME);
        MapGenStructureIO.func_143031_a(VillagePieceGuardTower.class, (String)"tqr_guardtower_destroyed");
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerGuardTower());
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        return new StructureVillagePieces.PieceWeight(VillagePieceGuardTower.class, 15, 3);
    }

    public Class<?> getComponentClass() {
        return VillagePieceGuardTower.class;
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        return VillagePieceGuardTower.createPiece(startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public static class VillagePieceGuardTower
    extends VillagePieceBlockMap {
        @Override
        protected int getYOffset() {
            return -1;
        }

        public static VillagePieceGuardTower createPiece(StructureVillagePieces.Start start, List<StructureComponent> structures, Random rand, int x, int y, int z, EnumFacing facing, int p_175850_7_) {
            BlockPos size;
            StructureBoundingBox bounds;
            if (ToroQuestConfiguration.disableGuardTower) {
                return null;
            }
            int i = ToroQuestConfiguration.destroyedVillagesNearSpawnDistance;
            String nameType = VillageHandlerGuardTower.NAME;
            if (i > 0 && Math.abs(x) < i && Math.abs(z) < i) {
                nameType = nameType + "_destroyed";
            }
            return VillagePieceGuardTower.func_74895_a((StructureBoundingBox)(bounds = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)1, (int)0, (int)1, (int)(size = new BlockMapMeasurer(nameType).measure()).func_177958_n(), (int)size.func_177956_o(), (int)size.func_177952_p(), (EnumFacing)facing))) && StructureComponent.func_74883_a(structures, (StructureBoundingBox)bounds) == null ? new VillagePieceGuardTower(nameType, start, p_175850_7_, rand, bounds, facing) : null;
        }

        public VillagePieceGuardTower(String name, StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox bounds, EnumFacing facing) {
            super(name, start, type, rand, bounds, EnumFacing.NORTH);
            this.func_186164_a(EnumFacing.NORTH);
        }

        public VillagePieceGuardTower() {
        }

        @Override
        protected boolean specialBlockHandling(World world, String c, int x, int y, int z) {
            if (world.field_72995_K) {
                return false;
            }
            if (c.equals("xx")) {
                ArrayList<String> entities = new ArrayList<String>();
                entities.add("toroquest:" + EntityGuard.NAME);
                return this.specialHandlingForSpawner(world, x, y, z, entities);
            }
            if (c.equals("BB")) {
                ArrayList<String> bandit = new ArrayList<String>();
                bandit.add("toroquest:" + EntitySentry.NAME);
                return this.specialHandlingForSpawner(world, x, y, z, bandit);
            }
            return false;
        }

        @Override
        protected void alterPalette(Map<String, IBlockState> palette) {
        }
    }
}

