/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.torocraft.toroquest.generation.BastionsLairGenerator;
import net.torocraft.toroquest.generation.GraveyardGenerator;
import net.torocraft.toroquest.generation.MageTowerGenerator;
import net.torocraft.toroquest.generation.MonolithGenerator;
import net.torocraft.toroquest.generation.PigPortalGenerator;
import net.torocraft.toroquest.generation.SpiderLairGenerator;
import net.torocraft.toroquest.generation.ThroneRoomGenerator;

public class WorldGenPlacer
implements IWorldGenerator {
    public static final Random random = new Random();

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlacer(), (int)2);
    }

    public void generate(Random random, int x, int z, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
    }

    public static void clearTrees(World world, BlockPos start, int radius) {
        double x = start.func_177958_n();
        double y = start.func_177956_o() - 32;
        double z = start.func_177952_p();
        for (int xx = -radius; xx < radius; ++xx) {
            for (int zz = -radius; zz < radius; ++zz) {
                int distFromCenter = (int)MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                if (radius < distFromCenter) continue;
                for (int yy = 0; 64 > yy; ++yy) {
                    BlockPos pos = new BlockPos(x + (double)xx, y + (double)yy, z + (double)zz);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof BlockLeaves) && !(block instanceof BlockLog)) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void genMageTower(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new MageTowerGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genBastionsLair(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new BastionsLairGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genSpiderLair(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new SpiderLairGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genPigPortal(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new PigPortalGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genMonolith(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new MonolithGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genThroneRoom(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, 40, z);
        if (new ThroneRoomGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }

    public static void genGraveyardTitan(World world, int x, int z) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        if (new GraveyardGenerator().func_180709_b(world, random, pos)) {
            // empty if block
        }
    }
}

