/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntityBanditLord;

public class ThroneRoomGenerator
extends WorldGenerator {
    protected final IBlockState stone = Blocks.field_150348_b.func_176223_P();
    protected final IBlockState andesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH);
    protected final IBlockState diorite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
    protected final IBlockState ironBars = Blocks.field_150411_aY.func_176223_P();
    protected final IBlockState stoneBrick = Blocks.field_150417_aV.func_176223_P();
    protected final IBlockState stoneBrickChiseled = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
    protected final IBlockState air = Blocks.field_150350_a.func_176223_P();
    protected final IBlockState goldBlock = Blocks.field_150371_ca.func_176223_P();
    protected final IBlockState redstoneBlock = Blocks.field_150371_ca.func_176223_P().func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Y);
    protected final IBlockState lava = Blocks.field_150356_k.func_176223_P();
    protected final IBlockState redCarpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.RED);
    protected final IBlockState blackCarpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.BLACK);
    protected final IBlockState stoneBrickStairsN = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
    protected final IBlockState stoneBrickStairsS = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
    protected final IBlockState stoneBrickStairsE = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
    protected final IBlockState stoneBrickStairsW = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
    protected final IBlockState doubleSlab = Blocks.field_150334_T.func_176223_P();
    private int width = 30;
    private int length = 64;
    private int height = 14;
    IBlockState blockSlab = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    IBlockState blockFire = Blocks.field_150480_ab.func_176223_P();

    public boolean func_180709_b(World worldIn, Random rand, BlockPos origin) {
        this.buildThroneRoom(worldIn, rand, origin);
        this.addToroSpawner(worldIn, origin.func_177982_a(15, 0, 75), this.getDefaultEnemies());
        return true;
    }

    private void buildThroneRoom(World world, Random rand, BlockPos startPos) {
        for (int y = 0; y <= this.height; ++y) {
            for (int x = 0; x <= this.width; ++x) {
                for (int z = 0; z <= this.length; ++z) {
                    IBlockState currentBlock = this.air;
                    if (this.isThroneSideLavaDitch(y, x, z)) {
                        if (x == 4 || x == this.width - 4) {
                            world.func_175656_a(startPos.func_177982_a(x, y, z), Blocks.field_150334_T.func_176223_P());
                            continue;
                        }
                        world.func_175656_a(startPos.func_177982_a(x, y, z), this.lava);
                        continue;
                    }
                    if (this.isFloor(y, x, z)) {
                        currentBlock = (x + z) % 2 == 0 ? this.andesite : this.diorite;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isWall(y, x, z)) {
                        if (y % 4 == 0) {
                            if (y == 12 && (x == 0 || x == this.width) && z % 4 == 0) {
                                currentBlock = this.lava;
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                            currentBlock = this.ironBars;
                            world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                            continue;
                        }
                        currentBlock = this.stoneBrick;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneCarpet(y, x, z)) {
                        currentBlock = this.redCarpet;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceStoneBrick(y, x, z)) {
                        currentBlock = this.stoneBrick;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceOpening(y, x, z)) {
                        currentBlock = this.air;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (z == 0 && y == 7 && x == 13) {
                        currentBlock = this.stoneBrickStairsW.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (z == 0 && y == 7 && x == 17) {
                        currentBlock = this.stoneBrickStairsE.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceCarpet(y, x, z)) {
                        if (x == 15 && y == 4) {
                            currentBlock = Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH);
                            world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                            TileEntity tileentity = world.func_175625_s(new BlockPos(x, y, z));
                            if (!(tileentity instanceof TileEntityChest)) continue;
                            if (rand.nextBoolean()) {
                                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186428_j, world.field_73012_v.nextLong());
                            } else {
                                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186427_i, world.field_73012_v.nextLong());
                            }
                            if (rand.nextBoolean()) {
                                ((TileEntityChest)tileentity).func_70299_a(world.field_73012_v.nextInt(20) + 2, new ItemStack(Items.field_151043_k, 5));
                            }
                            if (!rand.nextBoolean()) continue;
                            ((TileEntityChest)tileentity).func_70299_a(world.field_73012_v.nextInt(20) + 2, new ItemStack(Items.field_151043_k, 5));
                            continue;
                        }
                        currentBlock = this.redCarpet;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntrancePlatform(y, x, z)) {
                        if (x >= 13 && x <= 15) {
                            if (y == 3) {
                                currentBlock = Blocks.field_150335_W.func_176223_P();
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                            if (y == 2) {
                                currentBlock = Blocks.field_150335_W.func_176223_P();
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                            if (y == 1) {
                                currentBlock = Blocks.field_150335_W.func_176223_P();
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                        }
                        currentBlock = this.stone;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceStairsEast(y, x, z)) {
                        currentBlock = this.stoneBrickStairsE;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceStairsWest(y, x, z)) {
                        currentBlock = this.stoneBrickStairsW;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isEntranceStairsNorth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsN;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThronePlatform(y, x, z)) {
                        currentBlock = this.stone;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isAisleCarpet(y, x, z)) {
                        if (x == 13 || x == 17) {
                            currentBlock = this.blackCarpet;
                            world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                            continue;
                        }
                        currentBlock = this.redCarpet;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneArms(y, x, z)) {
                        currentBlock = this.goldBlock;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isBackOfThrone(y, x, z)) {
                        if (y == 10) {
                            if (x == 15) {
                                currentBlock = Blocks.field_180398_cJ.func_176223_P();
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                            if (x == 14) {
                                currentBlock = Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
                                world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                                continue;
                            }
                            if (x != 16) continue;
                            currentBlock = Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
                            world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                            continue;
                        }
                        currentBlock = this.redstoneBlock;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneStairsNorth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsN;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneStairsEast(y, x, z)) {
                        currentBlock = this.stoneBrickStairsE;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneStairsWest(y, x, z)) {
                        currentBlock = this.stoneBrickStairsW;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isThroneStairsSouth(y, x, z)) {
                        currentBlock = this.stoneBrickStairsS;
                        world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                        continue;
                    }
                    if (this.isInTorchGrid(y, x, z)) {
                        if ((z - 2) % 12 == 0) {
                            currentBlock = this.doubleSlab;
                            for (int yy = 0; yy < this.height; ++yy) {
                                world.func_175656_a(startPos.func_177982_a(x, y + yy, z), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x - 1, y + yy, z - 1), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x - 1, y + yy, z), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x - 1, y + yy, z + 1), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x, y + yy, z + 1), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x, y + yy, z - 1), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x + 1, y + yy, z - 1), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x + 1, y + yy, z), currentBlock);
                                world.func_175656_a(startPos.func_177982_a(x + 1, y + yy, z + 1), currentBlock);
                            }
                            continue;
                        }
                        world.func_175656_a(startPos.func_177982_a(x, y - 1, z), Blocks.field_189877_df.func_176223_P());
                        world.func_175656_a(startPos.func_177982_a(x - 1, y, z - 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x - 1, y, z), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x - 1, y, z + 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x, y, z + 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x, y, z - 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x + 1, y, z - 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x + 1, y, z), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x + 1, y, z + 1), this.blockSlab);
                        world.func_175656_a(startPos.func_177982_a(x, y, z), this.blockFire);
                        continue;
                    }
                    if (world.func_180495_p(startPos.func_177982_a(x, y, z)) == this.doubleSlab || world.func_180495_p(startPos.func_177982_a(x, y, z)) == Blocks.field_150333_U.func_176223_P() || world.func_180495_p(startPos.func_177982_a(x, y, z)) == this.blockFire) continue;
                    world.func_175656_a(startPos.func_177982_a(x, y, z), currentBlock);
                }
            }
        }
    }

    private boolean isAisleCarpet(int y, int x, int z) {
        return y == 1 && x >= 13 && x <= 17 && z > 6 && z < this.length - 10;
    }

    private boolean isInTorchGrid(int y, int x, int z) {
        return y == 1 && (x == 8 || x == this.width - 8) && (z - 2) % 6 == 0;
    }

    private boolean isFloor(int y, int x, int z) {
        return y == 0 || y == this.height;
    }

    private boolean isWall(int y, int x, int z) {
        return x == 0 || x == this.width || z == 0 || z == this.length;
    }

    private boolean isEntranceStoneBrick(int y, int x, int z) {
        return z == 0 && (y == 3 || y == 8) & x >= 12 && x <= 18 || z == 0 && (x == 12 || x == 18) && y >= 4 && y <= 7 || z == 0 && (x == 13 || x == 17) && y == 4;
    }

    private boolean isEntranceOpening(int y, int x, int z) {
        return z == 0 && y >= 4 && y <= 7 && x >= 14 && x <= 16;
    }

    private boolean isThroneStairsSouth(int y, int x, int z) {
        return y == 1 && z == this.length - 10 && x >= 12 && x <= 18 || y == 2 && z == this.length - 9 && x >= 13 && x <= 17 || y == 3 && z == this.length - 8 && x >= 14 && x <= 16 || y == 4 && z == this.length - 5 && x >= 14 && x <= 16 || y == 5 && z == this.length - 4 && x >= 14 && x <= 16;
    }

    private boolean isThroneStairsWest(int y, int x, int z) {
        return y == 1 && x == 19 && z <= this.length - 6 && z >= this.length - 10 || y == 2 && x == 18 && z <= this.length - 7 && z >= this.length - 9 || y == 3 && x == 17 && z <= this.length - 7 && z >= this.length - 8;
    }

    private boolean isThroneStairsEast(int y, int x, int z) {
        return y == 1 && x == 11 && z <= this.length - 6 && z >= this.length - 10 || y == 2 && x == 12 && z <= this.length - 7 && z >= this.length - 9 || y == 3 && x == 13 && z <= this.length - 7 && z >= this.length - 8;
    }

    private boolean isThroneStairsNorth(int y, int x, int z) {
        return y == 1 && (x == 11 || x == 12 || x == 18 || x == 19) && z == this.length - 5 || y == 2 && (x == 12 || x == 18) && z == this.length - 6;
    }

    private boolean isThroneSideLavaDitch(int y, int x, int z) {
        return y == 0 && (x < 5 || x > this.width - 5);
    }

    private boolean isBackOfThrone(int y, int x, int z) {
        return y >= 6 && y <= 10 && x > 13 && x < 17 && z == this.length - 1;
    }

    private boolean isEntranceCarpet(int y, int x, int z) {
        return y == 2 && x > 13 && x < 17 && z == 5 || y == 3 && z == 3 && x > 13 && x < 17 || y == 4 && z == 1 && x > 13 && x < 17;
    }

    private boolean isThroneCarpet(int y, int x, int z) {
        return y == 6 && x > 13 && x < 17 && (z == this.length - 3 || z == this.length - 2) || y == 4 && x > 13 && x < 17 && (z == this.length - 6 || z == this.length - 7);
    }

    private boolean isThroneArms(int y, int x, int z) {
        return y == 3 && (x == 13 || x == 17) && z == this.length - 6 || y == 4 && (x == 13 || x == 17) && z == this.length - 5 || y == 5 && (x == 13 || x == 17) && z == this.length - 4 || y == 6 && (x == 13 || x == 17) && (z == this.length - 3 || z == this.length - 2) || y == 7 && (x == 13 || x == 17) && z == this.length - 1;
    }

    private boolean isThronePlatform(int y, int x, int z) {
        return y == 1 && x >= 13 && x <= 17 && z >= this.length - 9 || y == 1 && (x == 12 || x == 18) && z >= this.length - 9 && z <= this.length - 6 || y == 2 && x >= 13 && x <= 17 && z >= this.length - 8 || y == 3 && x >= 13 && x <= 17 && z >= this.length - 5 || y == 3 && x >= 14 && x <= 16 && z >= this.length - 7 || y == 4 && x >= 13 && x <= 17 && z >= this.length - 4 || y == 5 && x >= 13 && x <= 17 && z >= this.length - 3 || y == 6 && (x == 13 || x == 17) && z == this.length - 1;
    }

    private boolean isEntranceStairsNorth(int y, int x, int z) {
        return y == 1 && z == 6 && x >= 10 && x <= this.width - 10 || y == 2 && z == 4 && x >= 12 && x <= this.width - 12 || y == 3 && z == 2 && x >= 14 && x <= this.width - 14;
    }

    private boolean isEntranceStairsWest(int y, int x, int z) {
        return y == 1 && x == this.width - 9 && z > 0 && z <= 6 || y == 2 && x == this.width - 11 && z > 0 && z <= 4 || y == 3 && x == this.width - 13 && z > 0 && z <= 2;
    }

    private boolean isEntranceStairsEast(int y, int x, int z) {
        return y == 1 && x == 9 && z > 0 && z <= 6 || y == 2 && x == 11 && z > 0 && z <= 4 || y == 3 && x == 13 && z > 0 && z <= 2;
    }

    private boolean isEntrancePlatform(int y, int x, int z) {
        return y == 1 && x >= 10 && x <= this.width - 10 && z <= 5 || y == 2 && x >= 12 && x <= this.width - 12 && z <= 3 || y == 3 && x >= 14 && x <= this.width - 14 && z == 1;
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        blockpos = blockpos.func_177981_b(2);
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
        } else {
            System.out.println("tile entity is missing");
            EntityBanditLord e = new EntityBanditLord(world);
            e.func_70634_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)e);
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_bandit_lord");
        for (int i = 8; i > 0; --i) {
            entity.add("toroquest:toroquest_sentry");
        }
        return entity;
    }
}

