/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntitySpiderLord;

public class SpiderLairGenerator
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        this.createWebs(world, rand, pos);
        this.addToroSpawner(world, pos);
        return true;
    }

    protected void createWebPatch(World world, BlockPos start) {
        int radius = 17;
        int x = start.func_177958_n();
        int z = start.func_177952_p();
        block0: for (int xx = -radius / 2; xx < radius / 2; ++xx) {
            for (int zz = -radius / 2; zz < radius / 2; ++zz) {
                int distFromCenter = (int)(Math.pow(Math.abs(xx) + 4, 2.0) + Math.pow(Math.abs(zz) + 4, 2.0));
                if (world.field_73012_v.nextInt(distFromCenter) >= 64 || distFromCenter > 181) continue;
                BlockPos pos = new BlockPos(x + xx, 0, z + zz);
                if ((pos = this.getSurfacePosition(world, pos)) == null) continue block0;
                pos = pos.func_177984_a();
                world.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
            }
        }
    }

    protected void createWebs(World world, Random rand, BlockPos origin) {
        double x = origin.func_177958_n();
        double z = origin.func_177952_p();
        int radius = 64;
        for (int webs = 0; webs < 64; ++webs) {
            int xx = rand.nextInt(radius) * (rand.nextInt(2) * 2 - 1);
            int zz = rand.nextInt(radius) * (rand.nextInt(2) * 2 - 1);
            BlockPos pos = new BlockPos((Vec3i)new BlockPos(x + (double)xx, 0.0, z + (double)zz));
            this.createWebPatch(world, pos);
        }
    }

    private BlockPos getSurfacePosition(World world, BlockPos start) {
        IBlockState blockState;
        BlockPos search = new BlockPos(start.func_177958_n(), world.func_72940_L() / 2, start.func_177952_p());
        while (search.func_177956_o() > 0 && !this.isLiquid(blockState = world.func_180495_p(search = search.func_177977_b())) && !blockState.func_185914_p()) {
        }
        return search;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private void addToroSpawner(World world, BlockPos blockpos) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(this.getDefaultEnemies());
            spawner.setSpawnRadius(8);
        } else {
            EntitySpiderLord e = new EntitySpiderLord(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            e.func_70107_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o() + 1, (double)blockpos.func_177952_p() + 0.5);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_spider_lord");
        return entity;
    }
}

