/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntityPigLord;

public class PigPortalGenerator
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        pos = this.getSurface(world, pos);
        this.createPatches(world, rand, pos);
        this.addPigs(world, pos, this.getPigs());
        this.generatePortal(world, pos);
        this.spawnPigLord(world, pos);
        return true;
    }

    private void spawnPigLord(World world, BlockPos pos) {
        this.addToroBossSpawner(world, pos, this.getDefaultEnemies());
    }

    private void addToroBossSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
        } else {
            EntityPigLord e = new EntityPigLord(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            e.func_70107_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o() + 1, (double)blockpos.func_177952_p() + 0.5);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_pig_lord");
        return entity;
    }

    protected void createPortalPatch(World world, BlockPos start, boolean netherrack, int r) {
        int radius = world.field_73012_v.nextInt(r) + r;
        int x = start.func_177958_n();
        int z = start.func_177952_p();
        for (int xx = -radius; xx < radius; ++xx) {
            for (int zz = -radius; zz < radius; ++zz) {
                BlockPos pos;
                int distFromCenter = (int)MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                if (radius < distFromCenter || (pos = this.getCorruptionSurface(world, x + xx, z + zz)) == null) continue;
                if (netherrack) {
                    if (world.field_73012_v.nextInt(3) == 0) {
                        world.func_175656_a(pos, Blocks.field_189877_df.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
                    continue;
                }
                world.func_175656_a(pos, Blocks.field_150425_aM.func_176223_P());
                if (world.field_73012_v.nextInt(9) != 0) continue;
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150388_bm.func_176223_P());
            }
        }
    }

    protected void createPatches(World world, Random rand, BlockPos origin) {
        double x = origin.func_177958_n();
        double z = origin.func_177952_p();
        for (int patch = 0; patch < 8; ++patch) {
            int xx = rand.nextInt(32) * (rand.nextInt(2) * 2 - 1);
            int zz = rand.nextInt(32) * (rand.nextInt(2) * 2 - 1);
            BlockPos pos = new BlockPos((Vec3i)new BlockPos(x + (double)xx, 0.0, z + (double)zz));
            this.createPortalPatch(world, pos, false, 6);
            xx = rand.nextInt(28) * (rand.nextInt(2) * 2 - 1);
            zz = rand.nextInt(28) * (rand.nextInt(2) * 2 - 1);
            pos = new BlockPos((Vec3i)new BlockPos(x + (double)xx, 0.0, z + (double)zz));
            this.createPortalPatch(world, pos, true, 4);
        }
        this.createPortalPatch(world, origin, true, 8);
    }

    private BlockPos getCorruptionSurface(World world, int x, int z) {
        BlockPos search = new BlockPos(x, world.func_72940_L() / 2, z);
        while (search.func_177956_o() > 4) {
            Block block = world.func_180495_p(search = search.func_177977_b()).func_177230_c();
            if (block instanceof BlockLiquid) {
                world.func_180501_a(search, Blocks.field_150353_l.func_176223_P(), 0);
                continue;
            }
            if (!(block instanceof BlockGrass) && !(block instanceof BlockDirt) && !(block instanceof BlockStone) && !(block instanceof BlockSand)) continue;
            break;
        }
        return search;
    }

    private BlockPos getSurface(World world, BlockPos start) {
        IBlockState blockState;
        BlockPos search = new BlockPos(start.func_177958_n(), world.func_72940_L(), start.func_177952_p());
        while (!(search.func_177956_o() <= 40 || this.isLiquid(blockState = world.func_180495_p(search = search.func_177977_b())) || blockState.func_185914_p() && !(blockState.func_177230_c() instanceof BlockLog))) {
        }
        return search;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockLiquid;
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(16);
        } else {
            System.out.println("tile entity is missing");
        }
    }

    private void addPigs(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(40);
        } else {
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getPigs() {
        ArrayList<String> entity = new ArrayList<String>();
        for (int i = 0; 20 > i; ++i) {
            entity.add("minecraft:pig");
        }
        return entity;
    }

    public void generatePortal(World world, BlockPos origin) {
        int x = origin.func_177958_n() - 16;
        int y = origin.func_177956_o() - 12;
        int z = origin.func_177952_p() + 8;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("assets/toroquest/structures/portal.txt"), "UTF-8"));
            String line = null;
            int yy = 0;
            int zz = 0;
            block2: while ((line = reader.readLine()) != null) {
                ++zz;
                String[] s = line.split("");
                int sLength = s.length;
                for (int xx = 0; sLength > xx; ++xx) {
                    if (xx == 0 && s[0].equals("#")) {
                        ++yy;
                        zz = 0;
                        continue block2;
                    }
                    IBlockState block = this.getBlock(s[xx]);
                    if (block == null) continue;
                    world.func_180501_a(new BlockPos(xx + x, yy + y, zz + z), block, 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR:" + e);
        }
    }

    private IBlockState getBlock(String block) {
        switch (block) {
            case "O": {
                return Blocks.field_150343_Z.func_176223_P();
            }
            case "X": {
                return Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)EnumFacing.Axis.X);
            }
        }
        return null;
    }
}

