/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntityMonolithEye;

public class MonolithGenerator
extends WorldGenerator {
    protected IBlockState getObsidianBlock() {
        return Blocks.field_150343_Z.func_176223_P();
    }

    protected IBlockState getEyeBlock() {
        return Blocks.field_180398_cJ.func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        this.placeMonolith(world, rand, pos);
        return true;
    }

    protected void placeChest(World world, BlockPos placementPos) {
        this.func_175903_a(world, placementPos, Blocks.field_150486_ae.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186421_c, world.field_73012_v.nextLong());
        }
    }

    public void placeSpawner(World world, BlockPos pos) {
        this.func_175903_a(world, pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        logic.func_190894_a(new ResourceLocation("magma_cube"));
    }

    private void spawnMonolithEye(World world, BlockPos pos) {
        this.addToroSpawner(world, pos, this.getDefaultEnemies());
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(0);
        } else {
            EntityMonolithEye e = new EntityMonolithEye(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            e.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            world.func_72838_d((Entity)e);
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_monolitheye");
        return entity;
    }

    private void spawnCrystal(World world, BlockPos pos) {
        EntityEnderCrystal e = new EntityEnderCrystal(world);
        e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
    }

    private BlockPos findPillarSurface(World world, BlockPos start) {
        IBlockState blockState;
        BlockPos search = new BlockPos(start.func_177958_n(), world.func_72940_L(), start.func_177952_p());
        while (!(search.func_177956_o() <= 40 || this.isLiquid(blockState = world.func_180495_p(search = search.func_177977_b())) || blockState.func_185914_p() && !(blockState.func_177230_c() instanceof BlockLog))) {
        }
        return search;
    }

    public static boolean isAir(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150350_a;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private void placeMonolith(World world, Random rand, BlockPos pos) {
        pos = this.findPillarSurface(world, pos);
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 38, pos.func_177956_o(), pos.func_177952_p() + 10));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 30, pos.func_177956_o(), pos.func_177952_p() + 30));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 10, pos.func_177956_o(), pos.func_177952_p() + 38));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 10, pos.func_177956_o(), pos.func_177952_p() + 38));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 32, pos.func_177956_o(), pos.func_177952_p() + 32));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 38, pos.func_177956_o(), pos.func_177952_p() + 10));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 38, pos.func_177956_o(), pos.func_177952_p() - 10));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 30, pos.func_177956_o(), pos.func_177952_p() - 30));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() - 10, pos.func_177956_o(), pos.func_177952_p() - 38));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 10, pos.func_177956_o(), pos.func_177952_p() - 38));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 30, pos.func_177956_o(), pos.func_177952_p() - 30));
        this.placePillar(world, rand, new BlockPos(pos.func_177958_n() + 38, pos.func_177956_o(), pos.func_177952_p() - 10));
        this.spawnMonolithEye(world, pos);
    }

    private void placePillar(World world, Random rand, BlockPos pos) {
        pos = this.findPillarSurface(world, pos);
        int height = rand.nextInt(8) + 4;
        pos = pos.func_177981_b(height);
        if (!world.field_72995_K) {
            this.spawnCrystal(world, pos);
        }
        for (int i = 0; i < 16 + height; ++i) {
            pos = pos.func_177977_b();
            this.func_175903_a(world, pos, Blocks.field_150343_Z.func_176223_P());
        }
    }

    public static void placeBlock(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, block.func_176223_P());
    }
}

