/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntityGraveTitan;

public class GraveyardGenerator
extends WorldGenerator {
    private BlockPos origin;
    private World world;
    private Random rand;
    private static final IBlockState GRAVE_TOP = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
    private static final IBlockState FENCE = Blocks.field_180407_aO.func_176223_P();
    private static final IBlockState GRAVE_STONE = Blocks.field_150472_an.func_176223_P();
    private static final IBlockState GRAVE_TOP_2 = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH);
    private static final IBlockState FENCE_2 = Blocks.field_150463_bK.func_176223_P();
    private static final IBlockState GRAVE_STONE_2 = Blocks.field_150463_bK.func_176223_P();
    private static final IBlockState GRAVE_DIRT = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
    private static final Item[] NICE_STUFF = new Item[]{Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj};

    public boolean func_180709_b(World world, Random rand, BlockPos origin) {
        this.world = world;
        this.rand = rand;
        this.origin = origin;
        int rows = 3 + rand.nextInt(3);
        int cols = 5 + rand.nextInt(4);
        int theme = rand.nextInt(2);
        if (this.levelEnough(origin, rows, cols)) {
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    this.genGrave(theme, col * 2, row * 4);
                }
            }
            for (int x = -2; x <= cols * 2; ++x) {
                this.place(this.fencePos(x, -2), this.getWall(theme));
                this.place(this.fencePos(x, rows * 4 - 1), this.getWall(theme));
            }
            for (int z = -1; z <= rows * 4 - 2; ++z) {
                this.place(this.fencePos(-2, z), this.getWall(theme));
                this.place(this.fencePos(2 * cols, z), this.getWall(theme));
            }
        }
        this.addToroSpawner(world, origin, this.getDefaultEnemies());
        return true;
    }

    private void spawnGraveTitan(World world, BlockPos pos) {
        EntityGraveTitan e = new EntityGraveTitan(world);
        e.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        blockpos = blockpos.func_177981_b(2);
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(20);
        } else {
            System.out.println("tile entity is missing");
            this.spawnGraveTitan(world, blockpos.func_177984_a());
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_grave_titan");
        return entity;
    }

    private boolean levelEnough(BlockPos pos, int rows, int cols) {
        int max = 0;
        int min = 1000;
        for (int x = -2; x <= cols * 2; ++x) {
            for (int z = -1; z <= rows * 4 - 2; ++z) {
                BlockPos surf = this.findSurface(pos.func_177982_a(x, 0, z));
                if (surf == null) {
                    return false;
                }
                int y = surf.func_177956_o();
                max = Math.max(y, max);
                min = Math.min(y, min);
            }
        }
        return max - min < 5;
    }

    private IBlockState getWall(int theme) {
        if (theme == 0) {
            return FENCE;
        }
        return FENCE_2;
    }

    private IBlockState getGraveTop(int theme) {
        if (theme == 0) {
            return GRAVE_TOP;
        }
        return GRAVE_TOP_2;
    }

    private IBlockState getGraveStone(int theme) {
        if (theme == 0) {
            return GRAVE_STONE;
        }
        return GRAVE_STONE_2;
    }

    protected BlockPos fencePos(int x, int z) {
        BlockPos sur = this.findSurface(this.origin.func_177982_a(x, 0, z));
        if (sur == null) {
            return null;
        }
        return sur.func_177982_a(0, 1, 0);
    }

    private void genGrave(int theme, int x, int z) {
        try {
            BlockPos surface = this.findSurface(this.origin.func_177982_a(x, 0, z));
            if (surface == null) {
                return;
            }
            this.place(surface.func_177982_a(0, 0, 0), this.getGraveTop(theme));
            this.place(surface.func_177982_a(0, 0, 1), this.getGraveTop(theme));
            this.placeChest(surface.func_177982_a(0, -1, 0));
            this.placeChest(surface.func_177982_a(0, -1, 1));
            this.placeDownward(surface.func_177982_a(1, 0, -1), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(1, 0, 0), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(1, 0, 1), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(1, 0, 2), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(-1, 0, -1), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(-1, 0, 0), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(-1, 0, 1), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(-1, 0, 2), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(0, 0, -1), GRAVE_DIRT);
            this.placeDownward(surface.func_177982_a(0, 0, 2), GRAVE_DIRT);
            this.place(surface.func_177982_a(1, 1, -1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(1, 1, 0), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(1, 1, 1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(1, 1, 2), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(-1, 1, -1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(-1, 1, 0), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(-1, 1, 1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(-1, 1, 2), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(0, 1, -1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(0, 1, 0), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(0, 1, 1), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(0, 1, 2), Blocks.field_150350_a.func_176223_P());
            this.place(surface.func_177982_a(0, 1, -1), this.getGraveStone(theme));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void placeChest(BlockPos pos) {
        this.place(pos, Blocks.field_150486_ae.func_176223_P());
        this.addLootToChest(pos);
    }

    protected void addLootToChest(BlockPos placementPos) {
        TileEntity tileentity = this.world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            this.addLootToChest((IInventory)((TileEntityChest)tileentity));
        }
    }

    protected void addLootToChest(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            int roll = this.rand.nextInt(8);
            if (roll == 0) {
                chest.func_70299_a(i, new ItemStack(Items.field_151103_aS, this.rand.nextInt(5) + 1));
                continue;
            }
            if (roll == 1) {
                chest.func_70299_a(i, new ItemStack(Items.field_151078_bh, this.rand.nextInt(5) + 1));
                continue;
            }
            if (roll == 2) {
                chest.func_70299_a(i, new ItemStack(Items.field_151074_bl, 1 + this.rand.nextInt(2) * 4));
                continue;
            }
            if (roll != 3) continue;
            if (this.rand.nextInt(20) == 0) {
                chest.func_70299_a(i, new ItemStack(NICE_STUFF[this.rand.nextInt(NICE_STUFF.length)]));
                continue;
            }
            if (this.rand.nextInt(20) != 0) continue;
            chest.func_70299_a(i, EventHandlers.randomStolenItem(this.world, null));
        }
    }

    private void placeDownward(BlockPos pos, IBlockState block) {
        IBlockState blockState = null;
        while (pos.func_177956_o() > 0 && !this.isGroundBlock(blockState)) {
            this.place(pos, block);
            pos = pos.func_177977_b();
            blockState = this.world.func_180495_p(pos);
        }
    }

    private BlockPos findSurface(BlockPos start) {
        BlockPos surface = new BlockPos(start.func_177958_n(), this.world.func_72940_L(), start.func_177952_p());
        while (surface.func_177956_o() > 5) {
            IBlockState blockState = this.world.func_180495_p(surface);
            if (this.isLiquid(blockState)) {
                return null;
            }
            if (this.isGroundBlock(blockState)) {
                return surface;
            }
            surface = surface.func_177977_b();
        }
        return null;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        try {
            Block b = blockState.func_177230_c();
            if (b == null) {
                return false;
            }
            if (b instanceof BlockGrass || b instanceof BlockDirt || b == Blocks.field_150348_b || b instanceof BlockSand || b instanceof BlockSnow || b instanceof BlockClay || b instanceof BlockGravel || b instanceof BlockMycelium || b instanceof BlockSand || b instanceof BlockSandStone) {
                return blockState.func_185914_p();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void place(BlockPos pos, IBlockState block) {
        if (block == null || pos == null) {
            return;
        }
        this.func_175903_a(this.world, pos, block);
    }
}

