/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;
import net.torocraft.toroquest.entities.EntityBas;
import net.torocraft.toroquest.generation.BastionsLairEntranceGenerator;

public class BastionsLairGenerator
extends WorldGenerator {
    private final int width = 40;
    private final int height = 25;
    private BlockPos origin;
    private int x;
    private int y;
    private int z;
    private World world;
    private Random rand;
    private IBlockState block;
    IBlockState blockMossy = Blocks.field_150351_n.func_176223_P();
    IBlockState blockSlab = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    IBlockState blockSlab2 = Blocks.field_150334_T.func_176223_P();
    IBlockState blockFire = Blocks.field_150480_ab.func_176223_P();
    private int radiusSq;
    private final int walkwayHeight = 15;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.world = world;
        this.rand = rand;
        this.findOrigin(pos);
        if (this.origin == null) {
            return false;
        }
        this.genMainChamber();
        this.genEntrance(42, 0, EnumFacing.WEST);
        this.genEntrance(0, -42, EnumFacing.NORTH);
        this.genEntrance(0, 42, EnumFacing.SOUTH);
        this.genEntrance(-42, 0, EnumFacing.EAST);
        this.spawnBas(world, this.origin.func_177982_a(0, 17, 0));
        return true;
    }

    protected void findOrigin(BlockPos pos) {
        this.origin = null;
        BlockPos a = this.getSurfacePosition(pos.func_177982_a(40, 0, 0));
        BlockPos b = this.getSurfacePosition(pos.func_177982_a(0, 0, -40));
        BlockPos c = this.getSurfacePosition(pos.func_177982_a(0, 0, 40));
        BlockPos d = this.getSurfacePosition(pos.func_177982_a(-40, 0, 0));
        if (a == null || b == null || c == null || d == null) {
            return;
        }
        this.origin = a;
        if (b.func_177956_o() < this.origin.func_177956_o()) {
            this.origin = b;
        }
        if (c.func_177956_o() < this.origin.func_177956_o()) {
            this.origin = c;
        }
        if (d.func_177956_o() < this.origin.func_177956_o()) {
            this.origin = d;
        }
        this.origin = this.origin.func_177979_c(50);
        if (this.origin.func_177956_o() < 5) {
            this.origin = new BlockPos(this.origin.func_177958_n(), 5, this.origin.func_177952_p());
        }
    }

    protected void genEntrance(int x, int z, EnumFacing facing) {
        BastionsLairEntranceGenerator g = new BastionsLairEntranceGenerator();
        g.setEntrance(facing);
        g.func_180709_b(this.world, this.rand, new BlockPos(x, 15, z).func_177971_a((Vec3i)this.origin));
    }

    private BlockPos getSurfacePosition(BlockPos start) {
        BlockPos search = new BlockPos(start.func_177958_n(), this.world.func_72940_L() / 2, start.func_177952_p());
        while (search.func_177956_o() > 0) {
            IBlockState blockState = this.world.func_180495_p(search = search.func_177977_b());
            if (this.isLiquid(blockState)) {
                return null;
            }
            if (!this.isGroundBlock(blockState)) continue;
            break;
        }
        return search;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        Block b = blockState.func_177230_c();
        if (b == null) {
            return false;
        }
        if (b instanceof BlockGrass || b instanceof BlockDirt || b == Blocks.field_150348_b || b instanceof BlockSand || b instanceof BlockSnow || b instanceof BlockClay || b instanceof BlockGravel || b instanceof BlockMycelium || b instanceof BlockSand || b instanceof BlockSandStone) {
            return blockState.func_185914_p();
        }
        return false;
    }

    private void genMainChamber() {
        this.y = 0;
        while (this.y <= 25) {
            this.x = -40;
            while (this.x <= 40) {
                this.z = -40;
                while (this.z <= 40) {
                    this.placeTombBlock();
                    ++this.z;
                }
                ++this.x;
            }
            ++this.y;
        }
    }

    protected void placeTombBlock() {
        this.block = null;
        this.radiusSq = this.x * this.x + this.z * this.z;
        if (this.isOutside()) {
            return;
        }
        if (this.isWall() || this.isRoof()) {
            this.block = this.rand.nextBoolean() ? Blocks.field_150348_b.func_176223_P() : Blocks.field_150417_aV.func_176223_P();
        } else if (this.isFloor()) {
            this.block = Blocks.field_150351_n.func_176223_P();
        } else if (this.isPlatform()) {
            this.block = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        } else if (this.isWalkway()) {
            if (this.isWalkwayEdge()) {
                this.func_175903_a(this.world, this.origin.func_177982_a(this.x, this.y + 1, this.z), this.blockSlab);
                this.block = Blocks.field_150348_b.func_176223_P();
            } else {
                this.block = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
            }
        } else if (this.isWalkwayTorch()) {
            this.block = this.blockFire;
            BlockPos pos = this.origin.func_177982_a(this.x, this.y, this.z);
            this.func_175903_a(this.world, pos.func_177982_a(0, -1, 0), Blocks.field_189877_df.func_176223_P());
            this.func_175903_a(this.world, pos.func_177982_a(-1, 0, -1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(-1, 0, 0), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(-1, 0, 1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(0, 0, 1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(0, 0, -1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(1, 0, 1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(1, 0, -1), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(1, 0, 0), this.blockSlab);
            this.func_175903_a(this.world, pos.func_177982_a(-1, -1, -1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(-1, -1, 0), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(-1, -1, 1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(0, -1, 1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(0, -1, -1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(1, -1, 1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(1, -1, -1), this.blockSlab2);
            this.func_175903_a(this.world, pos.func_177982_a(1, -1, 0), this.blockSlab2);
            this.func_175903_a(this.world, pos, this.blockFire);
        } else if (this.isWalkwaySubstructure()) {
            this.block = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        } else {
            if (this.isLootChest()) {
                BlockPos pos = this.origin.func_177982_a(this.x, this.y, this.z);
                this.block = this.randomChest();
                this.func_175903_a(this.world, pos.func_177982_a(0, 0, 0), this.block);
                this.addLootToChest();
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(1, 0, 1), this.blockMossy);
                }
                this.func_175903_a(this.world, pos.func_177982_a(1, 0, 0), this.blockMossy);
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(1, 0, 1), this.blockMossy);
                }
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(0, 0, 1), this.blockMossy);
                }
                this.func_175903_a(this.world, pos.func_177982_a(0, 0, 1), this.blockMossy);
                this.func_175903_a(this.world, pos.func_177982_a(1, 0, 1), this.blockMossy);
                this.func_175903_a(this.world, pos.func_177982_a(1, 0, 2), this.blockMossy);
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(1, 0, 3), this.blockMossy);
                }
                this.func_175903_a(this.world, pos.func_177982_a(1, 0, 0), this.blockMossy);
                this.func_175903_a(this.world, pos.func_177982_a(2, 0, 0), this.blockMossy);
                this.func_175903_a(this.world, pos.func_177982_a(1, 0, 1), this.blockMossy);
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(1, 0, 2), this.blockMossy);
                }
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(2, 0, 1), this.blockMossy);
                }
                this.func_175903_a(this.world, pos.func_177982_a(1, 1, 1), this.blockMossy);
                if (this.rand.nextBoolean()) {
                    this.func_175903_a(this.world, pos.func_177982_a(1, 2, 1), this.blockMossy);
                }
                return;
            }
            this.block = Blocks.field_150350_a.func_176223_P();
        }
        this.placeBlock();
    }

    protected boolean isHiddenUnderPlatformChest() {
        return this.y == 1 && this.x == 0 && this.z == 0;
    }

    private IBlockState randomChest() {
        int roll = this.rand.nextInt(4);
        switch (roll) {
            case 1: {
                return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH);
            }
            case 2: {
                return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH);
            }
            case 3: {
                return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST);
            }
        }
        return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST);
    }

    protected void addLootToChest() {
        TileEntity tileentity;
        if (this.block == null) {
            return;
        }
        if (this.block.func_177230_c() == Blocks.field_150486_ae && (tileentity = this.world.func_175625_s(this.origin.func_177982_a(this.x, this.y, this.z))) instanceof TileEntityChest) {
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186428_j, this.world.field_73012_v.nextLong());
            } else {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186427_i, this.world.field_73012_v.nextLong());
            }
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(20) + 2, new ItemStack(Items.field_151079_bi));
            }
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(20) + 2, new ItemStack(Items.field_151079_bi));
            }
            ItemStack stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185234_f);
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(20) + 2, stack);
            }
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_70299_a(this.rand.nextInt(20) + 2, stack);
            }
        }
    }

    private boolean isLootChest() {
        return this.y == 1 && this.rand.nextInt(400) == 0;
    }

    protected boolean isPlatform() {
        return this.y <= 15 && this.radiusSq < 55;
    }

    private boolean isWalkwayEdge() {
        if (Math.abs(this.x) <= 3 && Math.abs(this.z) <= 3) {
            return false;
        }
        return Math.abs(this.x) == 3 || Math.abs(this.z) == 3;
    }

    private boolean isWalkwaySubstructure() {
        if (this.y >= 15 || this.y < 10) {
            return false;
        }
        if (Math.abs(this.x) >= 4 && Math.abs(this.z) >= 4) {
            return false;
        }
        int distanceUnderWalkway = 15 - this.y;
        if (distanceUnderWalkway > 5 || distanceUnderWalkway < 1) {
            return false;
        }
        int distanceFromWalkwayMiddle = Math.min(Math.abs(this.z), Math.abs(this.x));
        return distanceFromWalkwayMiddle + distanceUnderWalkway < 5;
    }

    private boolean isWalkway() {
        return this.y == 15 && (Math.abs(this.x) < 4 || Math.abs(this.z) < 4);
    }

    private boolean isWalkwayTorch() {
        return !(this.y != 16 || !this.isWalkwayEdge() || this.x % 6 != 0 && this.z % 6 != 0 || Math.abs(this.x) <= 4 && Math.abs(this.z) <= 4);
    }

    private boolean isFloor() {
        return this.y == 0;
    }

    private boolean isRoof() {
        return this.y == 25;
    }

    protected void placeBlock() {
        if (this.block == null) {
            return;
        }
        if (this.world.func_180495_p(this.origin.func_177982_a(this.x, this.y, this.z)) == this.blockSlab || this.world.func_180495_p(this.origin.func_177982_a(this.x, this.y, this.z)) == this.blockFire || this.world.func_180495_p(this.origin.func_177982_a(this.x, this.y, this.z)) == this.blockSlab2 || this.world.func_180495_p(this.origin.func_177982_a(this.x, this.y, this.z)) == this.blockMossy) {
            return;
        }
        this.func_175903_a(this.world, this.origin.func_177982_a(this.x, this.y, this.z), this.block);
    }

    private boolean isWall() {
        return Math.abs(this.x) + Math.abs(this.z) == 44;
    }

    protected boolean isOutside() {
        return Math.abs(this.x) + Math.abs(this.z) > 44;
    }

    private void spawnBas(World world, BlockPos origin) {
        this.addToroSpawner(world, origin);
    }

    private void addToroSpawner(World world, BlockPos blockpos) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(this.getDefaultEnemies());
            spawner.setSpawnRadius(4);
        } else {
            EntityBas e = new EntityBas(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            e.func_70107_b((double)this.origin.func_177958_n() + 0.5, this.origin.func_177956_o() + 15 + 1, (double)this.origin.func_177952_p() + 0.5);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_bas");
        return entity;
    }
}

