/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.block.BlockToroSpawner;
import net.torocraft.toroquest.block.TileEntityToroSpawner;

public class BanditFortressGenerator
extends WorldGenerator {
    Random rand = new Random();

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        this.clearTrees(world, pos, 32);
        return true;
    }

    protected void placeChest(World world, BlockPos placementPos) {
        this.func_175903_a(world, placementPos, Blocks.field_150486_ae.func_176223_P());
        TileEntity tileentity = world.func_175625_s(placementPos);
        if (tileentity instanceof TileEntityChest) {
            if (this.rand.nextBoolean()) {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186428_j, world.field_73012_v.nextLong());
            } else {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186427_i, world.field_73012_v.nextLong());
            }
        }
    }

    private void spawnMonolithEye(World world, BlockPos pos) {
        this.addToroSpawner(world, pos, this.getDefaultEnemies());
    }

    private void addToroSpawner(World world, BlockPos blockpos, List<String> entities) {
        world.func_175656_a(blockpos, BlockToroSpawner.INSTANCE.func_176223_P());
        TileEntity tileentity = world.func_175625_s(blockpos);
        if (tileentity instanceof TileEntityToroSpawner) {
            TileEntityToroSpawner spawner = (TileEntityToroSpawner)tileentity;
            spawner.setTriggerDistance(80);
            spawner.setEntityIds(entities);
            spawner.setSpawnRadius(0);
        } else {
            System.out.println("tile entity is missing");
        }
    }

    private List<String> getDefaultEnemies() {
        ArrayList<String> entity = new ArrayList<String>();
        entity.add("toroquest:toroquest_sentry");
        return entity;
    }

    private void spawnCrystal(World world, BlockPos pos) {
        EntityEnderCrystal e = new EntityEnderCrystal(world);
        e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)e);
    }

    private BlockPos findPillarSurface(World world, BlockPos start) {
        IBlockState blockState;
        BlockPos search = new BlockPos(start.func_177958_n(), world.func_72940_L(), start.func_177952_p());
        while (!(search.func_177956_o() <= 40 || this.isLiquid(blockState = world.func_180495_p(search = search.func_177977_b())) || blockState.func_185914_p() && !(blockState.func_177230_c() instanceof BlockLog))) {
        }
        return search;
    }

    public boolean isAir(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150350_a;
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    public void clearTrees(World world, BlockPos start, int radius) {
        double x = start.func_177958_n();
        double z = start.func_177952_p();
        for (int i = 3; i > 0; --i) {
            for (int xx = -radius; xx < radius; ++xx) {
                for (int zz = -radius; zz < radius; ++zz) {
                    BlockPos pos;
                    int distFromCenter = (int)MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                    if (radius != distFromCenter + 1 || (pos = this.findSurface(world, (int)(x + (double)xx), (int)(z + (double)zz), true)) == null || i != 2 && this.rand.nextInt(3) == 0) continue;
                    this.placePillar(world, pos);
                }
            }
            ++radius;
        }
    }

    public BlockPos findSurface(World world, int x, int z, boolean force) {
        BlockPos pos = new BlockPos(x, world.func_72940_L(), z);
        while (pos.func_177956_o() > 0) {
            IBlockState blockState = world.func_180495_p(pos);
            if (!force && (this.isLiquid(blockState) || EventHandlers.isStructureBlock(blockState))) {
                return null;
            }
            if (!(blockState.func_177230_c() instanceof BlockLog) && this.isGroundBlock(blockState)) break;
            pos = pos.func_177977_b();
        }
        return pos.func_177984_a();
    }

    protected boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockLeaves || blockState.func_177230_c() instanceof BlockLog || blockState.func_177230_c() instanceof BlockBush || blockState.func_177230_c() instanceof BlockSlab) {
            return false;
        }
        return blockState.func_185914_p();
    }

    private void placePillar(World world, BlockPos pos) {
        int height = this.rand.nextInt(2) + this.rand.nextInt(2) + this.rand.nextInt(2) + this.rand.nextInt(2) + this.rand.nextInt(2) + this.rand.nextInt(2) + 2;
        pos = pos.func_177981_b(height);
        for (int i = 0; i < 16 + height; ++i) {
            pos = pos.func_177977_b();
            this.func_175903_a(world, pos, Blocks.field_150364_r.func_176223_P());
        }
    }

    public void placeBlock(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, block.func_176223_P());
    }
}

