/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.render;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.model.ModelGuard;

@SideOnly(value=Side.CLIENT)
public class RenderGuard
extends RenderBiped<EntityGuard> {
    private final ModelGuard defaultModel;
    private static final ResourceLocation DEFAULT = new ResourceLocation("toroquest:textures/entity/guard/guard_null.png");
    private static final ResourceLocation TEXTURES_SUN = new ResourceLocation("toroquest:textures/entity/guard/guard_sun.png");
    private static final ResourceLocation TEXTURES_MOON = new ResourceLocation("toroquest:textures/entity/guard/guard_moon.png");
    private static final ResourceLocation TEXTURES_EARTH = new ResourceLocation("toroquest:textures/entity/guard/guard_earth.png");
    private static final ResourceLocation TEXTURES_WIND = new ResourceLocation("toroquest:textures/entity/guard/guard_wind.png");
    private static final ResourceLocation TEXTURES_FIRE = new ResourceLocation("toroquest:textures/entity/guard/guard_fire.png");
    private static final ResourceLocation TEXTURES_WATER = new ResourceLocation("toroquest:textures/entity/guard/guard_water.png");

    public RenderGuard(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBiped)new ModelGuard(), 0.5f);
        this.defaultModel = (ModelGuard)this.field_77045_g;
        if (ToroQuestConfiguration.renderArrowLayer) {
            this.func_177094_a((LayerRenderer)new LayerArrow((RenderLivingBase)this));
        }
    }

    public void doRender(EntityGuard entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.setModelVisibilities(entity);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    private void setModelVisibilities(EntityGuard entity) {
        ItemStack itemstack = entity.func_184614_ca();
        ItemStack itemstack1 = entity.func_184592_cb();
        this.defaultModel.func_178719_a(true);
        ModelBiped.ArmPose modelbiped$armpose = ModelBiped.ArmPose.EMPTY;
        ModelBiped.ArmPose modelbiped$armpose1 = ModelBiped.ArmPose.EMPTY;
        if (itemstack != null) {
            modelbiped$armpose = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0) {
                EnumAction enumaction = itemstack.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    modelbiped$armpose = ModelBiped.ArmPose.BLOCK;
                } else if (enumaction == EnumAction.BOW) {
                    modelbiped$armpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        if (itemstack1 != null) {
            EnumAction enumaction1;
            modelbiped$armpose1 = ModelBiped.ArmPose.ITEM;
            if (entity.func_184605_cv() > 0 && (enumaction1 = itemstack1.func_77975_n()) == EnumAction.BLOCK) {
                modelbiped$armpose1 = ModelBiped.ArmPose.BLOCK;
            }
        }
        this.defaultModel.field_187076_m = modelbiped$armpose;
        this.defaultModel.field_187075_l = modelbiped$armpose1;
    }

    protected ResourceLocation getEntityTexture(EntityGuard entity) {
        CivilizationType civ = entity.getCivilization();
        if (civ == null) {
            return DEFAULT;
        }
        switch (civ) {
            case FIRE: {
                return TEXTURES_FIRE;
            }
            case EARTH: {
                return TEXTURES_EARTH;
            }
            case MOON: {
                return TEXTURES_MOON;
            }
            case SUN: {
                return TEXTURES_SUN;
            }
            case WIND: {
                return TEXTURES_WIND;
            }
            case WATER: {
                return TEXTURES_WATER;
            }
        }
        return DEFAULT;
    }
}

