/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityShopkeeper;
import net.torocraft.toroquest.entities.EntityToroVillager;

public class EntityAIToroVillagerMate
extends EntityAIBase {
    private final EntityToroVillager villager;
    private EntityToroVillager mate;
    private final World world;
    private int matingTimeout;
    Village village;
    private final int toroVillagerMateChance = ToroQuestConfiguration.toroVillagerMateChance;
    private final double villageDoorsModifier = ToroQuestConfiguration.villageDoorsModifier;
    private final int maxVillagersPerVillage = ToroQuestConfiguration.maxVillagersPerVillage;

    public EntityAIToroVillagerMate(EntityToroVillager villagerIn) {
        this.villager = villagerIn;
        this.world = villagerIn.field_70170_p;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.villager.func_70874_b() != 0 || this.villager.func_70631_g_() || this.villager.underAttack != null || this.villager.blockedTrade >= 1 || !this.villager.func_70089_S()) {
            return false;
        }
        if (this.villager.func_70681_au().nextInt(this.toroVillagerMateChance) != 0 || this.villager.isUnderAttack()) {
            return false;
        }
        this.village = this.world.func_175714_ae().func_176056_a(new BlockPos((Entity)this.villager), 0);
        if (this.village == null) {
            return false;
        }
        Province prov = CivilizationUtil.getProvinceAt(this.villager.field_70170_p, this.villager.field_70176_ah, this.villager.field_70164_aj);
        if (prov == null || prov.civilization == null) {
            return false;
        }
        List players = this.world.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.villager.func_180425_c()).func_72314_b(25.0, 12.0, 25.0), (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return true;
            }
        });
        int rep = 0;
        EntityPlayer p = null;
        for (EntityPlayer player : players) {
            int tempRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(prov.civilization);
            if (tempRep <= rep) continue;
            rep = tempRep;
            p = player;
        }
        if (p == null) {
            return false;
        }
        if (this.checkSufficientDoorsPresentForNewVillager(rep) && this.villager.func_175550_n(true)) {
            List entities = this.world.func_175647_a(EntityToroVillager.class, new AxisAlignedBB(this.villager.func_180425_c()).func_72314_b(10.0, 6.0, 10.0), (Predicate)new Predicate<EntityToroVillager>(){

                public boolean apply(@Nullable EntityToroVillager entity) {
                    return !(entity instanceof EntityShopkeeper);
                }
            });
            Collections.shuffle(entities);
            for (EntityToroVillager entity : entities) {
                if (entity == this.villager || entity.func_70874_b() != 0 || entity.func_70631_g_() || entity.underAttack != null || entity.blockedTrade >= 1 || !entity.func_70089_S()) continue;
                this.mate = entity;
                this.mate.bedLocation = this.villager.bedLocation;
                if (!this.mate.func_70661_as().func_75492_a((double)this.villager.bedLocation.func_177958_n(), (double)this.villager.bedLocation.func_177956_o(), (double)this.villager.bedLocation.func_177952_p(), 0.5) || !this.villager.func_70661_as().func_75492_a((double)this.villager.bedLocation.func_177958_n(), (double)this.villager.bedLocation.func_177956_o(), (double)this.villager.bedLocation.func_177952_p(), 0.5)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.matingTimeout = 256;
        this.villager.func_70947_e(true);
    }

    public void func_75251_c() {
        this.village = null;
        this.mate = null;
        this.villager.func_70947_e(false);
    }

    public boolean func_75253_b() {
        return this.matingTimeout >= 0 && this.villager.func_70874_b() == 0;
    }

    public void func_75246_d() {
        if (this.villager != null && this.villager.bedLocation != null && this.mate != null && this.mate.bedLocation != null) {
            --this.matingTimeout;
            this.villager.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
            this.mate.func_70671_ap().func_75651_a((Entity)this.villager, 10.0f, 30.0f);
            if ((this.villager.func_70011_f(this.villager.bedLocation.func_177958_n(), this.villager.bedLocation.func_177956_o(), this.villager.bedLocation.func_177952_p()) < 1.75 || this.villager.func_70661_as().func_75492_a((double)this.villager.bedLocation.func_177958_n(), (double)this.villager.bedLocation.func_177956_o(), (double)this.villager.bedLocation.func_177952_p(), 0.5)) && (this.mate.func_70011_f(this.villager.bedLocation.func_177958_n(), this.villager.bedLocation.func_177956_o(), this.villager.bedLocation.func_177952_p()) < 1.75 || this.mate.func_70661_as().func_75492_a((double)this.villager.bedLocation.func_177958_n(), (double)this.villager.bedLocation.func_177956_o(), (double)this.villager.bedLocation.func_177952_p(), 0.5)) && (double)this.villager.func_70032_d((Entity)this.mate) < 2.25) {
                if (this.matingTimeout == 0 && this.mate.func_70941_o()) {
                    this.villager.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
                    this.villager.func_184185_a(SoundEvents.field_187915_go, 1.25f, 1.0f + this.world.field_73012_v.nextFloat() * 0.4f);
                    this.world.func_72960_a((Entity)this.villager, (byte)12);
                    this.giveBirth();
                } else if (this.villager.func_70681_au().nextInt(25) == 0) {
                    if (!this.world.field_72995_K) {
                        Vec3d velocityVector = new Vec3d(this.villager.field_70165_t - this.mate.field_70165_t, 0.0, this.villager.field_70161_v - this.mate.field_70161_v);
                        double push = 2.25 + this.villager.func_70068_e((Entity)this.mate);
                        this.villager.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                        this.villager.field_70133_I = true;
                    }
                    this.villager.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
                    this.villager.func_184185_a(SoundEvents.field_187915_go, 1.0f, 0.8f + this.world.field_73012_v.nextFloat() * 0.4f);
                    this.world.func_72960_a((Entity)this.villager, (byte)12);
                }
            }
        } else {
            this.func_75251_c();
        }
    }

    private boolean checkSufficientDoorsPresentForNewVillager(double repMod) {
        if (this.village.func_75562_e() > this.maxVillagersPerVillage) {
            return false;
        }
        return this.village.func_75562_e() < (int)((double)this.village.func_75567_c() * this.villageDoorsModifier * (1.0 + repMod / 800.0));
    }

    private void giveBirth() {
        EntityVillager EntityToroVillager2 = this.villager.func_90011_a((EntityAgeable)this.mate);
        this.villager.func_70873_a(10000);
        this.mate.func_70873_a(10000);
        this.villager.func_175549_o(false);
        this.mate.func_175549_o(false);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.villager, (EntityLiving)this.mate, (EntityAgeable)EntityToroVillager2);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getChild() == null) {
            return;
        }
        EntityToroVillager2 = event.getChild();
        EntityToroVillager2.func_70873_a(-30000);
        EntityToroVillager2.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)EntityToroVillager2);
        this.world.func_72960_a((Entity)EntityToroVillager2, (byte)12);
    }
}

