/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.torocraft.toroquest.entities.EntityGuard;

public class EntityAISmartTempt
extends EntityAIBase {
    public final EntityCreature temptedEntity;
    public final double speed;
    public double targetX;
    public double targetY;
    public double targetZ;
    public double pitch;
    public double yaw;
    public EntityPlayer temptingPlayer;
    public int delayTemptCounter;
    public boolean isRunning;
    public final Set<Item> temptItem;

    public EntityAISmartTempt(EntityCreature temptedEntityIn, double speedIn, Item temptItemIn) {
        this(temptedEntityIn, speedIn, Sets.newHashSet((Object[])new Item[]{temptItemIn}));
    }

    public EntityAISmartTempt(EntityCreature temptedEntityIn, double speedIn, Set<Item> temptItemIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.func_75248_a(3);
        if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_72890_a((Entity)this.temptedEntity, 25.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        if (this.temptItem == Items.field_190931_a) {
            if (this.temptedEntity instanceof EntityGuard) {
                return true;
            }
            return true;
        }
        return this.isTempting(this.temptingPlayer.func_184614_ca()) || this.isTempting(this.temptingPlayer.func_184592_cb());
    }

    public boolean isTempting(ItemStack stack) {
        return this.temptItem.contains(stack.func_77973_b());
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.field_70165_t;
        this.targetY = this.temptingPlayer.field_70163_u;
        this.targetZ = this.temptingPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = 40;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 4.5) {
            this.temptedEntity.func_70661_as().func_75499_g();
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

