/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIRaid
extends EntityAIBase {
    public final EntityCreature entity;
    private final int minDistanceFromCenter = 16;
    private final int moveDistance = 8;
    private final double movementSpeed;
    private int centerX;
    private int centerZ;
    private boolean enabled = false;

    public EntityAIRaid(EntityCreature entity, int x, int z, double speedIn) {
        this.entity = entity;
        if (x != 0 || z != 0) {
            this.enabled = true;
            this.entity.func_110163_bv();
        }
        this.movementSpeed = speedIn;
        this.centerX = x;
        this.centerZ = z;
        this.func_75248_a(1);
    }

    private boolean move(World world, BlockPos start) {
        double x = this.centerX - start.func_177958_n();
        double z = this.centerZ - start.func_177952_p();
        double xz = Math.abs(x) + Math.abs(z);
        if (xz < (double)this.minDistanceFromCenter) {
            return false;
        }
        x = x / xz * (double)(world.field_73012_v.nextInt(this.moveDistance) + this.moveDistance) + (double)start.func_177958_n();
        z = z / xz * (double)(world.field_73012_v.nextInt(this.moveDistance) + this.moveDistance) + (double)start.func_177952_p();
        BlockPos moveTo = EntityAIRaid.findValidSurface(world, new BlockPos(x, (double)start.func_177956_o(), z), 8);
        if (moveTo != null && this.entity.func_70661_as().func_75492_a((double)moveTo.func_177958_n(), (double)moveTo.func_177956_o(), (double)moveTo.func_177952_p(), this.movementSpeed)) {
            return true;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.entity, (int)16, (int)8, (Vec3d)new Vec3d(x, this.entity.field_70163_u, z));
        return vec3d != null && this.entity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.movementSpeed) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.entity, (int)8, (int)8, (Vec3d)new Vec3d(x, this.entity.field_70163_u, z))) != null && this.entity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.movementSpeed) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.entity, (int)12, (int)8, (Vec3d)new Vec3d(x, this.entity.field_70163_u, z))) != null && this.entity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.movementSpeed) || (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)12, (int)8, (Vec3d)new Vec3d(x, this.entity.field_70163_u, z))) != null && this.entity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.movementSpeed);
    }

    public static BlockPos findValidSurface(World world, BlockPos startPos, int yOffset) {
        IBlockState blockState;
        int y;
        BlockPos pos = startPos.func_177977_b();
        boolean airspace = false;
        boolean floor = false;
        for (y = 0; yOffset > y; ++y) {
            blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().func_176223_P() != Blocks.field_150355_j) {
                return null;
            }
            if (!blockState.func_177230_c().func_176223_P().func_185917_h()) {
                if (floor) {
                    if (airspace) {
                        return pos.func_177977_b();
                    }
                    airspace = true;
                }
            } else {
                floor = true;
                airspace = false;
            }
            pos = pos.func_177984_a();
        }
        pos = startPos.func_177984_a();
        airspace = false;
        floor = false;
        for (y = 0; yOffset > y; ++y) {
            blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() instanceof BlockLiquid && blockState.func_177230_c().func_176223_P() != Blocks.field_150355_j) {
                return null;
            }
            if (!blockState.func_177230_c().func_176223_P().func_185917_h()) {
                if (airspace) {
                    floor = true;
                } else {
                    airspace = true;
                }
            } else {
                if (airspace && floor) {
                    return pos;
                }
                airspace = false;
                floor = false;
            }
            pos = pos.func_177977_b();
        }
        return null;
    }

    public boolean func_75250_a() {
        if (!this.enabled) {
            return false;
        }
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        return !this.inCorrectPosition();
    }

    public void func_75246_d() {
        if (this.entity.field_70170_p.field_73012_v.nextBoolean() && this.entity.func_70661_as().func_75500_f() || this.entity.field_70170_p.field_73012_v.nextInt(32) == 0) {
            this.move(this.entity.field_70170_p, this.entity.func_180425_c());
        }
    }

    public boolean inCorrectPosition() {
        return (double)this.minDistanceFromCenter > this.entity.func_70011_f(this.entity.field_70165_t - (double)this.centerX, this.entity.field_70163_u, this.entity.field_70165_t - (double)this.centerX);
    }

    public void func_75249_e() {
        this.move(this.entity.field_70170_p, this.entity.func_180425_c());
    }
}

