/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityOrc;
import net.torocraft.toroquest.entities.EntitySentry;
import net.torocraft.toroquest.entities.EntityToroMob;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.item.armor.ItemBanditArmor;
import net.torocraft.toroquest.item.armor.ItemLegendaryBanditArmor;

public class EntityAIBanditAttack
extends EntityAITarget {
    protected final EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<EntityLivingBase> targetEntitySelector;
    protected EntityLivingBase targetEntity;
    protected EntityToroMob field_75299_d;
    protected Province province;
    Random rand = new Random();

    public EntityAIBanditAttack(EntityToroMob npc) {
        super((EntityCreature)npc, false, false);
        this.field_75299_d = npc;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this.field_75299_d);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase target) {
                if (!EntityAITarget.func_179445_a((EntityLiving)EntityAIBanditAttack.this.field_75299_d, (EntityLivingBase)target, (boolean)false, (boolean)false)) {
                    return false;
                }
                if (target instanceof EntityGuard) {
                    if (EntityAIBanditAttack.this.field_75299_d instanceof EntityOrc) {
                        return true;
                    }
                    EntityGuard g = (EntityGuard)target;
                    if (!g.getPlayerGuard().equals("") && g.spawnedNearBandits) {
                        return false;
                    }
                }
                if (target instanceof EntityToroNpc || target instanceof EntityVillager || target instanceof EntityPlayer && EntityAIBanditAttack.this.shouldAttackPlayer((EntityPlayer)target)) {
                    return true;
                }
                if (target instanceof EntitySentry) {
                    if (target instanceof EntityOrc) {
                        return !(EntityAIBanditAttack.this.field_75299_d instanceof EntityOrc);
                    }
                    return EntityAIBanditAttack.this.field_75299_d instanceof EntityOrc;
                }
                return false;
            }
        };
    }

    public boolean shouldAttackPlayer(EntityPlayer player) {
        if (this.field_75299_d.func_70643_av() != null && this.field_75299_d.func_70643_av() == player) {
            return true;
        }
        if (this.field_75299_d.enemy == player) {
            return true;
        }
        if (this.field_75299_d instanceof EntityOrc) {
            if (!ToroQuestConfiguration.orcsDropMasks) {
                return this.field_75299_d.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
            }
        } else if (this.field_75299_d instanceof EntitySentry) {
            EntitySentry sentry = (EntitySentry)this.field_75299_d;
            if (sentry.enemy == player) {
                return true;
            }
            if (!(player.func_184614_ca().func_77973_b() != Items.field_151166_bC && player.func_184592_cb().func_77973_b() != Items.field_151166_bC || sentry.getBribed() || sentry.passiveTimer != -1)) {
                sentry.passiveTimer = 4;
                sentry.func_70661_as().func_75497_a((Entity)player, 0.45 + this.rand.nextDouble() / 10.0);
                boolean flag = true;
                if (sentry.emeraldGreeting && sentry.func_70032_d((Entity)player) < 12.0f) {
                    sentry.chat(player, "emeralds", null);
                    sentry.emeraldGreeting = false;
                }
                List bandits = sentry.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(sentry.func_180425_c()).func_72314_b(25.0, 12.0, 25.0));
                for (EntitySentry bandit : bandits) {
                    if (bandit.getBribed() || bandit.passiveTimer != -1) continue;
                    bandit.passiveTimer = 4;
                    bandit.func_70661_as().func_75497_a((Entity)player, 0.45 + this.rand.nextDouble() / 10.0);
                    bandit.emeraldGreeting = flag;
                }
                return false;
            }
            if (sentry.getBribed() || sentry.passiveTimer > 0) {
                return false;
            }
            if (sentry.passiveTimer == 0) {
                if (sentry.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    return false;
                }
                sentry.chat(player, "betray", null);
                return true;
            }
            int totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.EARTH);
            totalRep += PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.FIRE);
            totalRep += PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.MOON);
            totalRep += PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WATER);
            totalRep += PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.SUN);
            if ((totalRep += PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WIND)) <= -50) {
                String bandit = "";
                totalRep = 0;
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.EARTH) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.EARTH);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.earth.name", (Object[])new Object[0]).toString();
                }
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.FIRE) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.FIRE);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.fire.name", (Object[])new Object[0]).toString();
                }
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.MOON) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.MOON);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.moon.name", (Object[])new Object[0]).toString();
                }
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WATER) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WATER);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.water.name", (Object[])new Object[0]).toString();
                }
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.SUN) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.SUN);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.sun.name", (Object[])new Object[0]).toString();
                }
                if (PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WIND) < totalRep) {
                    totalRep = PlayerCivilizationCapabilityImpl.get(player).getReputation(CivilizationType.WIND);
                    bandit = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.wind.name", (Object[])new Object[0]).toString();
                }
                sentry.chat(player, "outlaw", TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"civilization.house.name", (Object[])new Object[0]).toString() + " " + bandit);
                return false;
            }
            for (ItemStack i : player.field_71071_by.field_70460_b) {
                if (!(i.func_77973_b() instanceof ItemBanditArmor) && !(i.func_77973_b() instanceof ItemLegendaryBanditArmor)) continue;
                if (sentry.helloGreeting && sentry.func_70032_d((Entity)player) < 12.0f) {
                    sentry.chat(player, "hello", null);
                    sentry.helloGreeting = false;
                    List bandits = sentry.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(sentry.func_180425_c()).func_72314_b(25.0, 12.0, 25.0));
                    for (EntitySentry bandit : bandits) {
                        bandit.helloGreeting = false;
                    }
                }
                return false;
            }
        }
        return this.field_75299_d.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_75250_a() {
        if (this.field_75299_d.func_70638_az() != null || this.rand.nextInt(12) != 0) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.field_75299_d.func_180425_c()).func_72314_b(30.0, 12.0, 30.0), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        for (EntityLivingBase npc : list) {
            if (!this.field_75299_d.func_70685_l((Entity)npc) || npc.func_82150_aj() || npc instanceof EntityPlayer && !npc.func_70051_ag() && this.rand.nextInt((int)this.field_75299_d.func_70032_d((Entity)npc) + 8) > (npc.func_70093_af() ? 16 : 8)) continue;
            this.targetEntity = npc;
            return true;
        }
        for (EntityLivingBase npc : list) {
            if (!(npc instanceof EntityVillager) && !((double)this.field_75299_d.func_70032_d((Entity)npc) <= 5.0)) continue;
            this.targetEntity = npc;
            return true;
        }
        this.targetEntity = null;
        return false;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    @Nullable
    private BlockPos getRandPos(World worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos blockpos = new BlockPos(entityIn);
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o();
        int k = blockpos.func_177952_p();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos blockpos1 = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = i - horizontalRange; l <= i + horizontalRange; ++l) {
            for (int i1 = j - verticalRange; i1 <= j + verticalRange; ++i1) {
                for (int j1 = k - horizontalRange; j1 <= k + horizontalRange; ++j1) {
                    float f1;
                    blockpos$mutableblockpos.func_181079_c(l, i1, j1);
                    IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                    if (iblockstate.func_185904_a() != Material.field_151586_h || !((f1 = (float)((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f)) continue;
                    f = f1;
                    blockpos1 = new BlockPos((Vec3i)blockpos$mutableblockpos);
                }
            }
        }
        return blockpos1;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

