/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities.ai;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroVillager;

public class EntityAIAvoidEnemies
extends EntityAIBase {
    protected EntityToroVillager entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected EntityLivingBase closestLivingEntity;
    private Path path;
    private final PathNavigate navigation;

    public EntityAIAvoidEnemies(EntityToroVillager entityIn, double farSpeedIn, double nearSpeedIn) {
        this.entity = entityIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.navigation = entityIn.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70681_au().nextInt(30) != 0) {
            return false;
        }
        List list = this.entity.field_70170_p.func_175647_a(EntityLiving.class, new AxisAlignedBB(this.entity.func_180425_c()).func_72314_b(12.0, 6.0, 12.0), (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving enemy) {
                return enemy instanceof IMob || enemy instanceof EntityMob;
            }
        });
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Vec3d vec3d;
            EntityLiving e = (EntityLiving)iterator.next();
            this.closestLivingEntity = e;
            if (ToroQuestConfiguration.iMobAttackVillagers && e.func_70638_az() != null) {
                e.func_70624_b((EntityLivingBase)this.entity);
            }
            if ((vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)8, (Vec3d)new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v))) == null || e.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) < e.func_70068_e((Entity)this.entity)) {
                vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)8, (Vec3d)new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v));
            }
            if (vec3d == null) {
                return false;
            }
            this.path = this.navigation.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return this.path != null;
        }
        EntityPlayer player = this.entity.field_70170_p.func_72890_a((Entity)this.entity, 12.0);
        if (player != null) {
            this.closestLivingEntity = player;
            Province province = CivilizationUtil.getProvinceAt(player.field_70170_p, player.field_70176_ah, player.field_70164_aj);
            if (province == null) {
                return false;
            }
            CivilizationType civ = province.getCiv();
            if (civ == null) {
                return false;
            }
            if (PlayerCivilizationCapabilityImpl.get(player).getReputation(civ) > -50) {
                return false;
            }
            Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)8, (Vec3d)new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            if (vec3d == null || player.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) < player.func_70068_e((Entity)this.entity)) {
                vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)8, (Vec3d)new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            }
            if (vec3d == null) {
                return false;
            }
            this.path = this.navigation.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return this.path != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, this.farSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        if (this.entity.func_70068_e((Entity)this.closestLivingEntity) < 40.0) {
            this.entity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.entity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

