/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAIZombieLeap;

public class EntityZombieRaider
extends EntityZombie
implements IMob {
    public static DataParameter<Integer> DESPAWN_TIMER = EntityDataManager.func_187226_a(EntityZombieRaider.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_X = EntityDataManager.func_187226_a(EntityZombieRaider.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_Z = EntityDataManager.func_187226_a(EntityZombieRaider.class, (DataSerializer)DataSerializers.field_187192_b);
    public static String NAME = "zombie_raider";

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DESPAWN_TIMER, (Object)100);
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("customDespawnTimer", this.despawnTimer().intValue());
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDespawnTimer(compound.func_74762_e("customDespawnTimer"));
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidZ"));
    }

    public Integer despawnTimer() {
        return (Integer)this.func_184212_Q().func_187225_a(DESPAWN_TIMER);
    }

    public Integer despawnTick() {
        int d = this.despawnTimer() - 1;
        this.func_184212_Q().func_187227_b(DESPAWN_TIMER, (Object)d);
        return d;
    }

    public void setDespawnTimer(int i) {
        this.func_184212_Q().func_187227_b(DESPAWN_TIMER, (Object)i);
    }

    protected void setRaidLocation(Integer x, Integer z) {
        if (x != null && z != null && x != 0 && z != 0) {
            this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
            this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
        }
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_110175_bO() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 100 == 0) {
            Vec3d vector3d;
            if (this.despawnTick() < 0 && (this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0)).isEmpty() || this.field_70170_p.func_72820_D() == 22000L && this.despawnTimer() < -50 || this.despawnTimer() < -100)) {
                this.func_70606_j(0.0f);
                this.func_70106_y();
                return;
            }
            if (this.func_70638_az() == null) {
                return;
            }
            if (this.func_70661_as().func_75494_a((Entity)this.func_70638_az()) == null && (vector3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)8, (int)8, (Vec3d)this.func_70638_az().func_174791_d())) != null) {
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.8);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIZombieLeap((EntityLiving)this, 0.38f, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIZombieAttack((EntityZombie)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.8, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 20, false, false, (Predicate)new Predicate<EntityVillager>(){

            public boolean apply(EntityVillager target) {
                return true;
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityToroNpc.class, 20, true, false, (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(EntityToroNpc target) {
                return true;
            }
        }));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 20, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(EntityPlayer target) {
                return true;
            }
        }));
    }

    protected void func_175456_n() {
    }

    public EntityZombieRaider(World worldIn) {
        super(worldIn);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        int x = this.getRaidLocationX();
        int z = this.getRaidLocationZ();
        if (x != 0 || z != 0) {
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIRaid((EntityCreature)this, this.getRaidLocationX(), this.getRaidLocationZ(), 0.8));
        }
    }

    public EntityZombieRaider(World worldIn, int x, int z) {
        super(worldIn);
        this.setRaidLocation(x + this.field_70146_Z.nextInt(33) - 16, z + this.field_70146_Z.nextInt(33) - 16);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityZombieRaider.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0, (int)0xE000000);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

