/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.ToroQuestTriggers;
import net.torocraft.toroquest.civilization.CivilizationDataAccessor;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.EntityToroVillager;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.render.RenderVillageLord;
import net.torocraft.toroquest.gui.VillageLordGuiHandler;
import net.torocraft.toroquest.inventory.IVillageLordInventory;
import net.torocraft.toroquest.inventory.VillageLordInventory;
import net.torocraft.toroquest.item.armor.ItemRoyalArmor;

public class EntityVillageLord
extends EntityToroNpc
implements IInventoryChangedListener {
    protected int isAnnoyedTimer = 0;
    protected EntityLivingBase underAttack = null;
    protected int underAttackTimer = 0;
    protected EntityPlayer murderWitness = null;
    protected int murderTimer = 0;
    protected boolean inCombat = false;
    public static String NAME = "village_lord";
    protected Map<UUID, VillageLordInventory> inventories = new HashMap<UUID, VillageLordInventory>();

    public EntityVillageLord(World world, Province p) {
        super(world);
        this.initInventories();
        this.pledgeAllegianceTo(p);
    }

    public EntityVillageLord(World world, int x, int y, int z) {
        this(world, null);
        this.setRaidLocation(x, y, z);
    }

    public EntityVillageLord(World world) {
        this(world, null);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_184641_n(false);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ToroQuestConfiguration.guardBaseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)ToroQuestConfiguration.guardArmor);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)ToroQuestConfiguration.guardArmorToughness);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.36);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    public boolean func_174833_aM() {
        return false;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityVillageLord.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)15508876, (int)12194504);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityVillageLord.class, (IRenderFactory)new IRenderFactory<EntityVillageLord>(){

            public Render<EntityVillageLord> createRenderFor(RenderManager manager) {
                return new RenderVillageLord(manager);
            }
        });
    }

    public void func_70624_b(EntityLivingBase e) {
        super.func_70624_b(null);
    }

    protected int getInventorySize() {
        return 14;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (this.field_70173_aa % 100 == 0) {
            BlockPos pos;
            this.pledgeAllegianceIfUnaffiliated(false);
            if (this.func_110143_aJ() >= this.func_110138_aP()) {
                this.hitSafety = true;
            } else {
                this.func_70691_i(1.0f);
            }
            --this.isAnnoyedTimer;
            if (!this.actionReady()) {
                --this.actionTimer;
            }
            if (this.underAttackTimer > 0 && --this.underAttackTimer < 1) {
                this.underAttack = null;
            }
            if (this.murderTimer > 0 && --this.murderTimer < 1) {
                this.murderWitness = null;
            }
            if ((pos = EntityAIRaid.findValidSurface(this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 8)) != null && !this.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.25)) {
                this.returnToPost();
            }
            if (this.talkingWith != null && this.func_70032_d((Entity)this.talkingWith) > 7.0f) {
                this.talkingWith = null;
            }
        }
    }

    public IVillageLordInventory getInventory(UUID playerId) {
        if (this.inventories.get(playerId) == null) {
            this.inventories.put(playerId, new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize()));
        }
        return this.inventories.get(playerId);
    }

    protected void initInventories() {
        HashMap<UUID, VillageLordInventory> newInventories = new HashMap<UUID, VillageLordInventory>();
        for (UUID playerId : this.inventories.keySet()) {
            newInventories.put(playerId, this.initInventory(this.inventories.get(playerId)));
        }
    }

    protected VillageLordInventory initInventory(VillageLordInventory prevInventory) {
        VillageLordInventory newInventory = new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize());
        newInventory.func_110133_a(this.func_70005_c_());
        if (prevInventory != null) {
            prevInventory.func_110132_b(this);
            int i = Math.min(prevInventory.func_70302_i_(), newInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = prevInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                newInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        newInventory.func_110134_a(this);
        return newInventory;
    }

    public void openGUI(EntityPlayer player) {
        player.openGui((Object)ToroQuest.INSTANCE, VillageLordGuiHandler.getGuiID(), this.field_70170_p, this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o(), this.func_180425_c().func_177952_p());
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == null || !this.func_70089_S() || hand == null) {
            return true;
        }
        this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        this.func_70625_a((Entity)player, 30.0f, 30.0f);
        this.talkingWith = player;
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.func_70631_g_()) {
            return true;
        }
        if (this.getCivilization() == null || this.getUUID() == null || player.func_82150_aj()) {
            return true;
        }
        Province homeProvince = this.getHomeProvince();
        if (homeProvince == null) {
            return true;
        }
        Province standingProvince = this.getStandingInProvince();
        if (standingProvince == null) {
            return true;
        }
        if (homeProvince != standingProvince) {
            return true;
        }
        int rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(homeProvince.civilization);
        if (rep < -50 || this.murderWitness != null && this.murderWitness == player || this.underAttack != null && this.underAttack == player) {
            this.setAnnoyed(player);
            if (this.actionReady()) {
                this.chat(this, player, "crime", homeProvince.getName());
            }
            return true;
        }
        if (this.isAnnoyedAt(player)) {
            this.setAnnoyed(player);
            if (this.actionReady()) {
                this.chatfriendly("annoyed", player, homeProvince.getName());
            }
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        String name = itemstack.func_82833_r();
        if (itemstack.func_77973_b() == Item.func_111206_d((String)"toroquest:city_key")) {
            if (name.equals("Key to the City")) {
                this.chatfriendly("incorrectname", player, name);
                return true;
            }
            if (rep >= 500) {
                CivilizationDataAccessor worldData = CivilizationsWorldSaveData.get(player.field_70170_p);
                if (worldData == null) {
                    return true;
                }
                homeProvince.setName(name);
                worldData.setName(homeProvince.getUUID(), name);
                this.chatfriendly("rename", player, name);
                return true;
            }
            this.chatfriendly("renameconsider", player, name);
            return true;
        }
        this.openGUI(player);
        return true;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return super.func_70005_c_();
    }

    private void chatfriendly(String message, EntityPlayer player, @Nullable String extra) {
        if (ToroQuestConfiguration.guardsHaveDialogue) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            this.func_70625_a((Entity)player, 30.0f, 30.0f);
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            try {
                int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.lord." + message), (Object[])new Object[0]).func_150260_c()));
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.lord." + message + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.func_70005_c_() + "\u00a7r: " + s));
            }
            catch (Exception e) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.lord." + message), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.func_70005_c_() + "\u00a7r: " + s));
            }
            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191243_bm, SoundCategory.AMBIENT, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
            this.actionTimer = 2;
        }
    }

    @Override
    public void chat(EntityToroNpc guard, EntityPlayer player, String message, @Nullable String extra) {
        guard.callForHelp((EntityLivingBase)player);
        if (ToroQuestConfiguration.guardsHaveDialogue && this.actionReady()) {
            guard.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            guard.func_70625_a((Entity)player, 30.0f, 30.0f);
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            try {
                int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c()));
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + guard.func_70005_c_() + "\u00a7r: " + s));
            }
            catch (Exception e) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.guard." + message), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s = s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + guard.func_70005_c_() + "\u00a7r: " + s));
            }
            guard.func_184185_a(SoundEvents.field_191243_bm, 1.0f, 0.9f + guard.field_70170_p.field_73012_v.nextFloat() / 5.0f);
            guard.actionTimer = 2;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.55));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f){

            public boolean func_75250_a() {
                if (EntityVillageLord.this.talkingWith != null) {
                    this.field_75334_a = EntityVillageLord.this.talkingWith;
                    return true;
                }
                return false;
            }

            public boolean func_75253_b() {
                if (EntityVillageLord.this.talkingWith == null) {
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.pledgeAllegianceIfUnaffiliated(false);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_110177_bN();
        this.addArmor();
        this.func_184641_n(false);
        this.pledgeAllegianceIfUnaffiliated(false);
        return livingdata;
    }

    @Override
    public boolean func_110175_bO() {
        return false;
    }

    public void addArmor() {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemRoyalArmor.helmetItem, 1));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151171_ah, 1));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151149_ai, 1));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151151_aj, 1));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityLivingBase) || source.func_76346_g() instanceof EntityToroNpc) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            if (this.func_70638_az() != entity && this.func_70643_av() != entity && !this.func_130014_f_().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(3.0, 3.0, 3.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(@Nullable EntityLivingBase entity) {
                    return entity instanceof IMob || entity instanceof EntityMob;
                }
            }).isEmpty()) {
                return false;
            }
            if (this.hitSafety) {
                this.hitSafety = false;
                this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            this.dropRepTo((Entity)player, -((int)MathHelper.func_76131_a((float)(amount * 20.0f), (float)25.0f, (float)(this.func_110143_aJ() * 20.0f))));
            this.setUnderAttack(player);
            boolean flag = false;
            List guards = this.field_70170_p.func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityGuard>(){

                public boolean apply(@Nullable EntityGuard entity) {
                    return true;
                }
            });
            for (EntityGuard guard : guards) {
                if (guard.func_70638_az() != null) continue;
                this.func_70661_as().func_75497_a((Entity)guard, 0.4);
                guard.setAnnoyed(player);
                if (!flag && guard.actionReady() && (double)guard.func_70032_d(entity) <= 8.0) {
                    guard.chat((EntityPlayer)entity, "attacklord", null);
                    flag = true;
                }
                guard.func_70624_b((EntityLivingBase)player);
            }
            List villagers = this.func_130014_f_().func_175647_a(EntityToroVillager.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityToroVillager>(){

                public boolean apply(@Nullable EntityToroVillager entity) {
                    return true;
                }
            });
            for (EntityToroVillager villager : villagers) {
                villager.setUnderAttack((EntityLivingBase)player);
            }
        } else if (entity instanceof EntityLivingBase) {
            this.callForHelp((EntityLivingBase)entity);
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void callForHelp(EntityLivingBase attacker) {
        if (attacker == null || !attacker.func_70089_S() || attacker instanceof EntityToroNpc || attacker instanceof EntityVillager) {
            return;
        }
        List guards = this.func_130014_f_().func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityGuard>(){

            public boolean apply(@Nullable EntityGuard entity) {
                return true;
            }
        });
        for (EntityGuard guard : guards) {
            if (attacker instanceof EntityPlayer) {
                guard.setAnnoyed((EntityPlayer)attacker);
            }
            guard.func_70624_b(attacker);
        }
        List villagers = this.func_130014_f_().func_175647_a(EntityToroVillager.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0), (Predicate)new Predicate<EntityToroVillager>(){

            public boolean apply(@Nullable EntityToroVillager entity) {
                return true;
            }
        });
        for (EntityToroVillager villager : villagers) {
            villager.setUnderAttack(attacker);
        }
    }

    private boolean dropRepTo(Entity entity, int amount) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        CivilizationType civ = this.getCivilization();
        if (civ == null) {
            return false;
        }
        EventHandlers.adjustPlayerRep(player, civ, amount);
        return true;
    }

    public void func_76316_a(IInventory invBasic) {
    }

    public void func_70645_a(DamageSource cause) {
        if (this.getCivilization() != null) {
            this.setHasLord(true, this.getHomeProvince());
            if (cause.func_76346_g() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)cause.func_76346_g();
                ToroQuestTriggers.KINGSLAYER_ACHIEVEMENT.trigger(player);
                switch (this.getCivilization()) {
                    case FIRE: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_RED.trigger(player);
                        break;
                    }
                    case EARTH: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_GREEN.trigger(player);
                        break;
                    }
                    case WATER: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_BLACK.trigger(player);
                        break;
                    }
                    case MOON: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_BLACK.trigger(player);
                        break;
                    }
                    case WIND: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_BROWN.trigger(player);
                        break;
                    }
                    case SUN: {
                        ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT_YELLOW.trigger(player);
                        break;
                    }
                }
                if (player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_red"))).func_192105_a() && player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_green"))).func_192105_a() && player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_blue"))).func_192105_a() && player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_black"))).func_192105_a() && player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_brown"))).func_192105_a() && player.func_192039_O().func_192747_a(player.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation("toroquest:murderhobo_yellow"))).func_192105_a()) {
                    ToroQuestTriggers.MURDERHOBO_ACHIEVEMENT.trigger(player);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.inventories != null) {
            this.killer(cause);
        }
        this.func_174820_d(100 + EntityEquipmentSlot.HEAD.func_188454_b(), ItemStack.field_190927_a);
        this.dropLoot();
        super.func_70645_a(cause);
    }

    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K && this.getCivilization() != null) {
            ItemStack head = new ItemStack(Item.func_111206_d((String)"toroquest:royal_helmet"), 1);
            EntityItem dropHead = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, head.func_77946_l());
            this.field_70170_p.func_72838_d((Entity)dropHead);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void killer(DamageSource cause) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = cause.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer && this.dropRepTo(entity, -3000)) {
            for (IVillageLordInventory iVillageLordInventory : this.inventories.values()) {
                this.dropInventory(iVillageLordInventory);
            }
        }
        if (this.getHomeProvince() != null) {
            if (ToroQuestConfiguration.broadcastLordSlain) {
                for (EntityPlayer entityPlayer : this.field_70170_p.field_73010_i) {
                    entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextComponentHelper.createComponentTranslation((ICommandSender)entityPlayer, (String)"entity.toroquest.lord.slaincivilization", (Object[])new Object[0]).func_150260_c().replace("@e", this.getHomeProvince().getName())), true);
                }
            }
            if (ToroQuestConfiguration.removeProvinceOnLordDeath) {
                void var4_8;
                List<Province> provinces = CivilizationsWorldSaveData.get(this.field_70170_p).getProvinces();
                boolean bl = false;
                while (var4_8 < provinces.size()) {
                    Province province = provinces.get((int)var4_8);
                    if (province.equals(this.getHomeProvince())) {
                        province.chunkX = 0;
                        province.chunkZ = 0;
                        province.area = 0;
                        province.lowerVillageBoundX = 0;
                        province.lowerVillageBoundZ = 0;
                        province.xLength = 0;
                        province.zLength = 0;
                        province.hasLord = false;
                    }
                    province = null;
                    provinces.set((int)var4_8, null);
                    ++var4_8;
                }
            }
        }
    }

    protected void dropInventory(IVillageLordInventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public static void registerFixesVillageLord(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVillageLord.class);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(EntityVillageLord.class, new String[]{"Items"}));
    }

    public void setHasLord(boolean hasLord, @Nullable Province province) {
        CivilizationDataAccessor worldData;
        if (province == null) {
            return;
        }
        if (!this.func_70089_S()) {
            hasLord = false;
        }
        if ((worldData = CivilizationsWorldSaveData.get(this.field_70170_p)).provinceHasLord(province.id) == hasLord) {
            return;
        }
        if (!hasLord) {
            worldData.setTrophyPig(province.id, false);
            worldData.setTrophyMage(province.id, false);
            worldData.setTrophySpider(province.id, false);
            worldData.setTrophySkeleton(province.id, false);
            worldData.setTrophyBandit(province.id, false);
            worldData.setTrophyLord(province.id, false);
            worldData.setTrophyTitan(province.id, false);
            worldData.setTrophyBeholder(province.id, false);
        }
        worldData.setProvinceHasLord(province.id, hasLord);
    }

    @Override
    protected boolean pledgeAllegianceIfUnaffiliated(boolean force) {
        Province p;
        if ((force || this.getCivilization() == null || this.getUUID() == null) && this.pledgeAllegiance(p = this.getStandingInProvince())) {
            if (force) {
                this.playTameEffect((byte)6);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            this.setHasLord(true, p);
            return true;
        }
        return false;
    }

    @Override
    public boolean pledgeAllegianceTo(Province p) {
        if (this.pledgeAllegiance(p)) {
            this.playTameEffect((byte)6);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        for (Map.Entry<UUID, VillageLordInventory> e : this.inventories.entrySet()) {
            c.func_74782_a(e.getKey().toString(), (NBTBase)e.getValue().saveAllItems());
        }
        compound.func_74782_a("Items", (NBTBase)c);
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("Items");
        this.inventories = new HashMap<UUID, VillageLordInventory>();
        for (String sPlayerId : c.func_150296_c()) {
            VillageLordInventory inv = new VillageLordInventory(this, "VillageLordInventory", this.getInventorySize());
            inv.loadAllItems(c.func_150295_c(sPlayerId, 10));
            this.inventories.put(UUID.fromString(sPlayerId), inv);
        }
        super.func_70037_a(compound);
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

