/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityBas;
import net.torocraft.toroquest.entities.render.RenderVampireBat;

public class EntityVampireBat
extends EntityMob
implements IMob {
    public static String NAME = "vampire_bat";
    private EntityBas nearbyBas;
    private BlockPos spawnPosition;

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityVampireBat.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)8213, (int)0x909090);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityVampireBat.class, (IRenderFactory)new IRenderFactory<EntityVampireBat>(){

            public Render<EntityVampireBat> createRenderFor(RenderManager manager) {
                return new RenderVampireBat(manager);
            }
        });
    }

    public EntityVampireBat(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.95f, 0.95f);
        this.field_70728_aV = 0;
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.6, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.nearbyBas != null) {
                this.nearbyBas.func_70691_i(16.0f);
                this.spawnSweepParticles();
                this.func_184185_a(SoundEvents.field_187664_bz, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
                this.func_184185_a(SoundEvents.field_187922_gv, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
            }
            return true;
        }
        return false;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187740_w;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x *= (double)0.6f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.batAiEdit();
    }

    protected void batAiEdit() {
        EntityLivingBase target = this.func_70638_az();
        this.spawnPosition = target == null || this.field_70146_Z.nextInt(100) > 50 ? this.nonAttackLocation() : target.func_180425_c().func_177984_a();
        double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
        double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
        double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
        this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
        this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
        float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
        float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
        this.field_191988_bg = 0.5f;
        this.field_70177_z += f1;
    }

    protected BlockPos nonAttackLocation() {
        if (this.nearbyBas == null || this.nearbyBas.field_70128_L) {
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.searchForBas();
            }
            return this.randomNearByPlace();
        }
        return new BlockPos((int)this.nearbyBas.field_70165_t + this.field_70146_Z.nextInt(30) - 15, (int)this.nearbyBas.field_70163_u + this.field_70146_Z.nextInt(8) + 4, (int)this.nearbyBas.field_70161_v + this.field_70146_Z.nextInt(30) - 15);
    }

    protected BlockPos randomNearByPlace() {
        return new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
    }

    private void searchForBas() {
        List list = this.field_70170_p.func_72872_a(EntityBas.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(64.0, 32.0, 64.0));
        if (list.size() < 1) {
            return;
        }
        this.nearbyBas = (EntityBas)((Object)list.get(this.field_70146_Z.nextInt(list.size())));
    }

    public void spawnSweepParticles() {
        double xx = this.field_70165_t + (double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))));
        double yy = this.field_70163_u + 0.5 + (double)this.field_70131_O * 0.5;
        double zz = this.field_70161_v + (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            for (int i = 16; i > 0; --i) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.REDSTONE, xx + this.field_70146_Z.nextGaussian() / 6.0, yy + this.field_70146_Z.nextGaussian() / 6.0, zz + this.field_70146_Z.nextGaussian() / 6.0, 0, 0.0, 0.0, 0.0, 0.02, new int[0]);
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public static void registerFixesBat(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVampireBat.class);
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186377_ab;
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        super.func_191958_b(strafe, up, forward, friction);
    }

    public boolean func_70617_f_() {
        return false;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

