/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.EventHandlers;
import net.torocraft.toroquest.SoundHandler;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.QuestTradeWithVillagers;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityToroNpc;
import net.torocraft.toroquest.entities.ai.EntityAIAvoidEnemies;
import net.torocraft.toroquest.entities.ai.EntityAISmartTempt;
import net.torocraft.toroquest.entities.ai.EntityAIToroHarvestFarmland;
import net.torocraft.toroquest.entities.ai.EntityAIToroVillagerMate;
import net.torocraft.toroquest.entities.trades.ToroVillagerTrades;

public class EntityToroVillager
extends EntityVillager
implements INpc,
IMerchant {
    public short canTalk = 0;
    public boolean uiClick = true;
    public short chattingWithGuard = 0;
    public short blockedTrade = 0;
    public static String NAME = "toro_villager";
    public EntityLivingBase underAttack = null;
    public BlockPos bedLocation = null;
    public ItemStack treasureMap = null;
    public Integer varient = null;
    boolean hitSafety = false;
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityToroVillager.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isMating;
    private boolean isPlaying;
    public Village field_70954_d;
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean isWillingToMate;
    private int wealth;
    public boolean unlockedGatedTrades;
    private int careerId;
    private int careerLevel;
    private boolean isLookingForHome = true;
    private boolean areAdditionalTasksSet = false;
    private final InventoryBasic villagerInventory;
    private boolean needsInitilization = true;
    private VillagerRegistry.VillagerProfession prof;

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEnemies(this, 0.5, 0.65));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.65){

            public boolean func_75250_a() {
                if (EntityToroVillager.this.isUnderAttack() && this.field_75267_a.func_70685_l((Entity)EntityToroVillager.this.underAttack) || EntityToroVillager.this.func_70027_ad()) {
                    return this.func_190863_f();
                }
                return false;
            }

            protected boolean func_190863_f() {
                Vec3d vec3d = null;
                vec3d = EntityToroVillager.this.isUnderAttack() && EntityToroVillager.this.underAttack.func_174791_d() != null ? RandomPositionGenerator.func_75461_b((EntityCreature)this.field_75267_a, (int)16, (int)8, (Vec3d)EntityToroVillager.this.underAttack.func_174791_d()) : RandomPositionGenerator.func_75461_b((EntityCreature)this.field_75267_a, (int)16, (int)8, (Vec3d)this.field_75267_a.func_174791_d());
                if (vec3d == null) {
                    return false;
                }
                this.field_75266_c = vec3d.field_72450_a;
                this.field_75263_d = vec3d.field_72448_b;
                this.field_75264_e = vec3d.field_72449_c;
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIToroVillagerMate(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookAtTradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISmartTempt((EntityCreature)this, 0.4, Items.field_151166_bC){

            @Override
            public boolean func_75250_a() {
                super.func_75250_a();
                if (EntityToroVillager.this.isUnderAttack() || !EntityToroVillager.this.canTrade() || EntityToroVillager.this.func_70940_q() || EntityToroVillager.this.func_70027_ad() || EntityToroVillager.this.func_70941_o()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5){

            public boolean func_75250_a() {
                Vec3d vec3d;
                if (EntityToroVillager.this.func_70941_o() || EntityToroVillager.this.func_70940_q() || EntityToroVillager.this.isUnderAttack() || EntityToroVillager.this.chattingWithGuard > 0) {
                    return false;
                }
                if (!this.field_179482_g) {
                    if (this.field_75457_a.func_70654_ax() >= 100) {
                        return false;
                    }
                    if (!this.field_75457_a.func_70090_H() && !this.field_75457_a.func_180799_ab() && this.field_75457_a.func_70681_au().nextInt(this.field_179481_f) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.func_190864_f()) == null) {
                    return false;
                }
                this.field_75455_b = vec3d.field_72450_a;
                this.field_75456_c = vec3d.field_72448_b;
                this.field_75453_d = vec3d.field_72449_c;
                this.field_179482_g = false;
                return true;
            }

            protected Vec3d func_190864_f() {
                if (!this.field_75457_a.func_70781_l() && (this.field_75457_a.func_70090_H() || this.field_75457_a.func_180799_ab())) {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)16, (int)8);
                    return vec3d == null ? super.func_190864_f() : vec3d;
                }
                return this.field_75457_a.func_70681_au().nextFloat() >= this.field_190865_h ? RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)12, (int)6) : super.func_190864_f();
            }
        });
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f){

            public boolean func_75250_a() {
                if (EntityToroVillager.this.isUnderAttack() || !EntityToroVillager.this.canTrade() || EntityToroVillager.this.func_70027_ad() || EntityToroVillager.this.func_70941_o() || EntityToroVillager.this.func_70781_l()) {
                    this.field_75334_a = null;
                    return false;
                }
                if (EntityToroVillager.this.func_70931_l_() != null) {
                    this.field_75334_a = EntityToroVillager.this.func_70931_l_();
                    return true;
                }
                this.field_75334_a = null;
                return false;
            }
        });
    }

    public String func_70005_c_() {
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        if (this.field_70170_p.field_72995_K || !this.func_70089_S() || this.func_70940_q() || this.func_70631_g_() || this.func_70941_o() || this.func_70027_ad()) {
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        for (ItemStack itemStack : player.func_184193_aE()) {
            if (!itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:bandit_helmet")) && !itemStack.func_77973_b().equals(Item.func_111206_d((String)"toroquest:legendary_bandit_helmet"))) continue;
            this.callForHelp((EntityLivingBase)player, true);
            if (this.canTalk < 1) {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP() * 1.2f, this.func_70647_i());
                this.canTalk = (short)2;
            }
            this.setUnderAttack((EntityLivingBase)player);
            return true;
        }
        RepData repData = this.getReputation(player);
        if (repData == null || repData.civ == null || repData.rep == null) {
            if (this.canTalk < 1) {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
                this.canTalk = (short)2;
            }
            return true;
        }
        if (this.underAttack == player || repData.rep != null && repData.rep < -50) {
            this.callForHelp((EntityLivingBase)player, true);
            if (this.canTalk < 1) {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP() * 1.2f, this.func_70647_i());
                this.canTalk = (short)2;
            }
            this.setUnderAttack((EntityLivingBase)player);
            return true;
        }
        Item item = itemstack.func_77973_b();
        if (ToroQuestConfiguration.recruitVillagers && player.func_70093_af() && item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers"))) {
            player.func_70095_a(false);
            if (repData.rep != null && repData.rep >= 0 && this.canTrade() && !this.isUnderAttack()) {
                this.func_184185_a(SoundEvents.field_193784_dd, 1.2f, 1.2f);
                this.func_184185_a(SoundEvents.field_187713_n, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187698_i, 0.5f, 0.8f);
                itemstack.func_190918_g(1);
                EntityGuard newEntity = new EntityGuard(this.field_70170_p);
                newEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                newEntity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Vec3i)this.func_180425_c())), null);
                newEntity.func_82149_j((Entity)this);
                newEntity.actionTimer = 1;
                this.func_70106_y();
                this.field_70170_p.func_72838_d((Entity)newEntity);
                newEntity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                newEntity.func_70625_a((Entity)player, 30.0f, 30.0f);
                newEntity.recruitGuard(player, repData.prov, "civvillagerrecruit");
                newEntity.spawnedNearBandits = false;
            } else if (this.canTalk <= 0) {
                this.playTameEffect(false);
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
                this.canTalk = (short)2;
            }
            return true;
        }
        if (this.blockedTrade > 0) {
            if (this.canTalk <= 0) {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP() * 1.2f, this.func_70647_i() * 0.9f);
                this.canTalk = 1;
            }
            return true;
        }
        this.getRecipes(player, repData);
        if (this.buyingList == null || this.buyingList.isEmpty()) {
            if (this.canTalk <= 0) {
                this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
                this.canTalk = 1;
            }
            return true;
        }
        this.func_70932_a_(player);
        player.func_180472_a((IMerchant)this);
        if (this.canTalk <= 0) {
            this.func_184185_a(SoundEvents.field_187914_gn, this.func_70599_aP(), this.func_70647_i());
            this.canTalk = 1;
        }
        return true;
    }

    protected void playTameEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void callForHelp(EntityLivingBase attacker, boolean attackThem) {
        this.setUnderAttack(attacker);
        List villagers = this.field_70170_p.func_175647_a(EntityToroVillager.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 8.0, 16.0), (Predicate)new Predicate<EntityToroVillager>(){

            public boolean apply(@Nullable EntityToroVillager entity) {
                return true;
            }
        });
        for (EntityToroVillager villager : villagers) {
            if (!villager.func_70685_l((Entity)attacker)) continue;
            villager.setUnderAttack(attacker);
        }
        List guards = this.field_70170_p.func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 12.0, 20.0), (Predicate)new Predicate<EntityGuard>(){

            public boolean apply(@Nullable EntityGuard entity) {
                return true;
            }
        });
        boolean flag = false;
        for (EntityGuard guard : guards) {
            if (guard.func_70638_az() != null) continue;
            this.func_70661_as().func_75497_a((Entity)guard, (double)0.7f);
            if (attacker instanceof EntityPlayer) {
                guard.setAnnoyed((EntityPlayer)attacker);
                if (!flag && guard.actionReady() && (double)guard.func_70032_d((Entity)attacker) <= 8.0) {
                    guard.chat((EntityPlayer)attacker, "attackvillager", null);
                    flag = true;
                }
            }
            if (!guard.isAnnoyed() && !attackThem) continue;
            guard.func_70624_b(attacker);
        }
    }

    public void reportToGuards(EntityPlayer player) {
        List guards = this.field_70170_p.func_175647_a(EntityToroNpc.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityToroNpc>(){

            public boolean apply(@Nullable EntityToroNpc entity) {
                return true;
            }
        });
        Collections.shuffle(guards);
        for (EntityToroNpc guard : guards) {
            if (guard.inCombat) continue;
            this.func_70661_as().func_75497_a((Entity)guard, 0.5);
            guard.func_70661_as().func_75497_a((Entity)player, 0.5);
        }
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        RepData repData = this.getReputation(player);
        if (repData == null || repData.civ == null || repData.rep == null || repData.rep < -50) {
            return new MerchantRecipeList();
        }
        return this.getRecipes(player, repData);
    }

    @Nullable
    public MerchantRecipeList getRecipes(EntityPlayer player, RepData repData) {
        if (this.buyingList == null || this.buyingList.isEmpty() || this.needsInitilization) {
            this.populateBuyingList(player, repData);
            this.needsInitilization = false;
        }
        return ForgeEventFactory.listTradeOffers((IMerchant)this, (EntityPlayer)player, (MerchantRecipeList)this.buyingList);
    }

    private void populateBuyingList(EntityPlayer player, RepData repData) {
        if (this.careerId != 0 && this.careerLevel != 0) {
            this.careerLevel = MathHelper.func_76125_a((int)(1 + repData.rep / 500), (int)1, (int)8);
        } else {
            this.careerId = this.getProfessionForge().getRandomCareer(this.field_70146_Z) + 1;
            this.careerLevel = 1;
        }
        this.buyingList = this.createTradesBaseOnRep(player, repData);
    }

    protected MerchantRecipeList createTradesBaseOnRep(EntityPlayer player, RepData repData) {
        return ToroVillagerTrades.trades(this, player, repData.rep, repData.civ, this.getProfessionForge().getCareer(this.careerId - 1).getName(), String.valueOf(this.varient));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.uiClick = true;
        if (this.field_70173_aa % 100 == 0) {
            if (this.func_110143_aJ() >= this.func_110138_aP()) {
                if (this.blockedTrade <= 0) {
                    this.hitSafety = true;
                }
            } else {
                this.func_70691_i(1.0f);
            }
            super.func_85033_bc();
            if (this.canTalk > 0) {
                this.canTalk = (short)(this.canTalk - 1);
            }
            if (this.blockedTrade > 0) {
                this.blockedTrade = (short)(this.blockedTrade - 1);
            } else {
                this.underAttack = null;
            }
            if (this.chattingWithGuard > 0) {
                this.chattingWithGuard = (short)(this.chattingWithGuard - 1);
            }
            if (this.field_70954_d == null) {
                this.field_70170_p.func_175714_ae().func_176060_a(this.func_190671_u_());
                this.field_70954_d = this.field_70170_p.func_175714_ae().func_176056_a(this.func_190671_u_(), 32);
            }
            if (this.field_70954_d == null) {
                this.func_110177_bN();
            } else if (this.isLookingForHome) {
                this.isLookingForHome = false;
                this.func_175449_a(this.field_70954_d.func_180608_a(), this.field_70954_d.func_75568_b());
            }
            if (!this.func_70940_q() && this.timeUntilReset > 0) {
                --this.timeUntilReset;
                if (this.timeUntilReset <= 0) {
                    this.timeUntilReset = 60;
                    this.needsInitilization = true;
                }
            }
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        RepData repData;
        this.callForHelp((EntityLivingBase)player, false);
        if (!this.func_110167_bD() && (repData = this.getReputation(player)) != null) {
            EventHandlers.adjustPlayerRep(player, repData.civ, -ToroQuestConfiguration.leashVillagerRepLoss);
        }
        return true;
    }

    public EntityToroVillager(World worldIn) {
        this(worldIn, 0);
        this.func_110163_bv();
    }

    public EntityToroVillager(World worldIn, int professionId) {
        super(worldIn, professionId);
        this.func_110163_bv();
        this.villagerInventory = new InventoryBasic("Items", false, 8);
        this.func_70938_b(professionId);
        this.setAdditionalAItasks();
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
        this.field_70138_W = 1.05f;
        this.varient = this.field_70146_Z.nextInt(ToroQuestConfiguration.villagerUniqueShopInventoryVarients + 1);
        this.func_70014_b(new NBTTagCompound());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.varient = compound.func_74764_b("Varient") ? Integer.valueOf(compound.func_74762_e("Varient")) : Integer.valueOf(this.field_70146_Z.nextInt(ToroQuestConfiguration.villagerUniqueShopInventoryVarients + 1));
        this.func_70938_b(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"));
            }
            this.setProfession(p);
        }
        this.unlockedGatedTrades = compound.func_74767_n("GatedTrades");
        this.wealth = compound.func_74762_e("Riches");
        this.careerId = compound.func_74762_e("Career");
        this.careerLevel = compound.func_74762_e("CareerLevel");
        this.isWillingToMate = compound.func_74767_n("Willing");
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemstack);
        }
        this.func_98053_h(true);
        this.setAdditionalAItasks();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Profession", this.func_70946_n());
        compound.func_74778_a("ProfessionName", this.getProfessionForge().getRegistryName().toString());
        compound.func_74757_a("GatedTrades", this.unlockedGatedTrades);
        compound.func_74768_a("Riches", this.wealth);
        compound.func_74768_a("Career", this.careerId);
        compound.func_74768_a("CareerLevel", this.careerLevel);
        compound.func_74757_a("Willing", this.isWillingToMate);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)nbttaglist);
        if (this.varient == null) {
            this.varient = this.field_70146_Z.nextInt(ToroQuestConfiguration.villagerUniqueShopInventoryVarients + 1);
        }
        compound.func_74768_a("Varient", this.varient.intValue());
    }

    protected RepData getReputation(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        RepData repData = new RepData();
        Province province = CivilizationUtil.getProvinceAt(player.field_70170_p, player.field_70176_ah, player.field_70164_aj);
        if (province == null || province.getCiv() == null) {
            return null;
        }
        repData.civ = province.getCiv();
        repData.prov = province;
        repData.rep = PlayerCivilizationCapabilityImpl.get(player).getReputation(repData.civ);
        return repData;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source.func_76346_g() == null) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4);
            if (vec3d != null) {
                this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5);
            }
        } else if (source.func_76346_g() instanceof EntityLivingBase) {
            if (source.func_76346_g() instanceof EntityToroNpc) {
                amount = 0.0f;
                return false;
            }
            EntityLivingBase e = (EntityLivingBase)source.func_76346_g();
            if (e instanceof EntityPlayer) {
                if (this.hitSafety) {
                    this.hitSafety = false;
                    this.func_184185_a(SoundEvents.field_187546_ae, this.func_70599_aP(), this.func_70647_i());
                    amount = 0.0f;
                    return false;
                }
                List enemies = e.func_130014_f_().func_175647_a(EntityGuard.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 12.0, 16.0), (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(@Nullable EntityLivingBase entity) {
                        return entity instanceof IMob || entity instanceof EntityMob;
                    }
                });
                if (!enemies.isEmpty()) {
                    amount = 0.0f;
                    return false;
                }
            }
            this.callForHelp(e, true);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        if (this.timeUntilReset < 30) {
            this.timeUntilReset = 30;
        }
        this.field_70757_a = -this.func_70627_aG();
        if (this.uiClick) {
            this.func_184185_a(SoundEvents.field_187638_cR, this.func_70599_aP(), this.func_70647_i());
            if (ToroQuestConfiguration.coinTradeSounds) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_184185_a(SoundHandler.TRADEC_0, this.func_70599_aP() * 0.9f, this.func_70647_i());
                        break;
                    }
                    case 1: {
                        this.func_184185_a(SoundHandler.TRADEC_1, this.func_70599_aP() * 0.9f, this.func_70647_i());
                        break;
                    }
                    case 2: {
                        this.func_184185_a(SoundHandler.TRADEC_2, this.func_70599_aP() * 0.9f, this.func_70647_i());
                    }
                }
            }
            this.uiClick = false;
        }
        try {
            QuestTradeWithVillagers.INSTANCE.onTrade(this.func_70931_l_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recipe.func_180321_e() >= 50000) {
            RepData repData;
            this.func_184185_a(SoundEvents.field_187604_bf, this.func_70599_aP() * 0.9f, this.func_70647_i());
            this.unlockedGatedTrades = true;
            this.needsInitilization = true;
            this.func_189511_e(new NBTTagCompound());
            if (this.func_70931_l_() != null && (repData = this.getReputation(this.func_70931_l_())) != null && repData.civ != null && repData.rep != null) {
                this.getRecipes(this.func_70931_l_(), repData);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)14);
        }
        if (this.func_70931_l_() instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192138_r.func_192234_a((EntityPlayerMP)this.func_70931_l_(), (EntityVillager)this, recipe.func_77397_d());
        }
    }

    public boolean isUnderAttack() {
        return this.underAttack != null && this.underAttack.func_70089_S();
    }

    public boolean canTrade() {
        return this.blockedTrade < 1;
    }

    public void blockTrade() {
        if (this.blockedTrade < 8) {
            this.blockedTrade = (short)(this.blockedTrade + 4);
        }
    }

    public void setUnderAttack(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.underAttack = (EntityPlayer)entity;
            if (this.blockedTrade < 16) {
                this.blockedTrade = (short)(this.blockedTrade + 4);
            }
        } else {
            this.underAttack = null;
            if (this.blockedTrade < 8) {
                this.blockedTrade = (short)(this.blockedTrade + 2);
            }
        }
    }

    public void setMurder(EntityPlayer player) {
        this.underAttack = player;
        this.blockedTrade = (short)64;
    }

    public boolean func_175550_n(boolean updateFirst) {
        if (updateFirst) {
            int s = 8;
            int x = (int)(this.field_70165_t + 0.5);
            int y = (int)(this.field_70163_u + 0.5);
            int z = (int)(this.field_70161_v + 0.5);
            for (int xx = x - s; x + s >= xx; ++xx) {
                for (int yy = y - s; y + s >= yy; ++yy) {
                    for (int zz = z - s; z + s >= zz; ++zz) {
                        Block bed = this.field_70170_p.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c();
                        if (!(bed instanceof BlockBed)) continue;
                        this.bedLocation = new BlockPos(xx, yy, zz);
                        return this.bedLocation != null;
                    }
                }
            }
        }
        return this.bedLocation != null;
    }

    public void func_175549_o(boolean isWillingToMate) {
        if (isWillingToMate) {
            this.isWillingToMate = this.func_175550_n(true);
        } else {
            this.isWillingToMate = false;
            this.bedLocation = null;
        }
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntityToroVillager entityvillager = new EntityToroVillager(this.field_70170_p, this.func_70946_n());
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public int func_184649_cE() {
        return 10;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityToroVillager.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0, (int)14735033);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70940_q()) {
            return SoundEvents.field_187914_gn;
        }
        if (this.field_70146_Z.nextBoolean()) {
            return SoundEvents.field_187910_gj;
        }
        return null;
    }

    protected void func_85033_bc() {
    }

    public boolean func_70652_k(Entity victim) {
        this.func_70624_b(null);
        return false;
    }

    private void setAdditionalAItasks() {
        if (!this.areAdditionalTasksSet) {
            this.areAdditionalTasksSet = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPlay((EntityVillager)this, 0.32));
            } else if (this.func_70946_n() == 0) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIToroHarvestFarmland(this, 0.6));
            }
        }
    }

    protected void func_175500_n() {
        if (this.func_70946_n() == 0) {
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIToroHarvestFarmland(this, 0.6));
        }
        super.func_175500_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
    }

    public static void registerFixesVillager(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVillager.class);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(EntityVillager.class, new String[]{"Inventory"}));
        fixer.func_188258_a(FixTypes.ENTITY, new IDataWalker(){

            public NBTTagCompound func_188266_a(IDataFixer fixer, NBTTagCompound compound, int versionIn) {
                NBTTagCompound nbttagcompound;
                if (EntityList.func_191306_a(EntityVillager.class).equals((Object)new ResourceLocation(compound.func_74779_i("id"))) && compound.func_150297_b("Offers", 10) && (nbttagcompound = compound.func_74775_l("Offers")).func_150297_b("Recipes", 9)) {
                    NBTTagList nbttaglist = nbttagcompound.func_150295_c("Recipes", 10);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"buy");
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"buyB");
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"sell");
                        nbttaglist.func_150304_a(i, (NBTBase)nbttagcompound1);
                    }
                }
                return compound;
            }
        });
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191184_at;
    }

    public void func_70938_b(int professionId) {
        this.field_70180_af.func_187227_b(PROFESSION, (Object)professionId);
        VillagerRegistry.onSetProfession((EntityVillager)this, (int)professionId);
    }

    public int func_70946_n() {
        return Math.max((Integer)this.field_70180_af.func_187225_a(PROFESSION), 0);
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        this.prof = prof;
        this.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof));
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            this.prof = VillagerRegistry.getById((int)this.func_70946_n());
            if (this.prof == null) {
                return VillagerRegistry.getById((int)0);
            }
        }
        return this.prof;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(PROFESSION)) {
            VillagerRegistry.onSetProfession((EntityVillager)this, (int)((Integer)this.field_70180_af.func_187225_a(PROFESSION)));
        }
    }

    public boolean func_70941_o() {
        return this.isMating;
    }

    public void func_70947_e(boolean mating) {
        this.isMating = mating;
    }

    public void func_70939_f(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean func_70945_p() {
        return this.isPlaying;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.field_70954_d != null && livingBase != null) {
            this.field_70954_d.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.field_70954_d.modifyPlayerReputation(livingBase.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.field_70954_d != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.field_70954_d.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.field_70954_d.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.field_70954_d.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public boolean func_70940_q() {
        return this.func_70931_l_() != null;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
            this.canTalk = 1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (s != null && !s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        String s1 = null;
        switch (this.func_70946_n()) {
            case 0: {
                if (this.careerId == 1) {
                    s1 = "farmer";
                    break;
                }
                if (this.careerId == 2) {
                    s1 = "fisherman";
                    break;
                }
                if (this.careerId == 3) {
                    s1 = "shepherd";
                    break;
                }
                if (this.careerId != 4) break;
                s1 = "fletcher";
                break;
            }
            case 1: {
                if (this.careerId == 1) {
                    s1 = "librarian";
                    break;
                }
                if (this.careerId != 2) break;
                s1 = "cartographer";
                break;
            }
            case 2: {
                s1 = "cleric";
                break;
            }
            case 3: {
                if (this.careerId == 1) {
                    s1 = "armor";
                    break;
                }
                if (this.careerId == 2) {
                    s1 = "weapon";
                    break;
                }
                if (this.careerId != 3) break;
                s1 = "tool";
                break;
            }
            case 4: {
                if (this.careerId == 1) {
                    s1 = "butcher";
                    break;
                }
                if (this.careerId != 2) break;
                s1 = "leather";
                break;
            }
            case 5: {
                s1 = "nitwit";
            }
        }
        s1 = this.getProfessionForge().getCareer(this.careerId - 1).getName();
        TextComponentTranslation itextcomponent = new TextComponentTranslation("entity.Villager." + s1, new Object[0]);
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return this.func_190672_a(difficulty, livingdata, true);
    }

    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        p_190672_2_ = super.func_180482_a(p_190672_1_, p_190672_2_);
        if (p_190672_3_) {
            VillagerRegistry.setRandomProfession((EntityVillager)this, (Random)this.field_70170_p.field_73012_v);
        }
        this.setAdditionalAItasks();
        return p_190672_2_;
    }

    public void func_82187_q() {
        this.isLookingForHome = true;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityWitch entitywitch = new EntityWitch(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), (IEntityLivingData)null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_96094_a(this.func_95999_t());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    public InventoryBasic func_175551_co() {
        return this.villagerInventory;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemstack1 = this.villagerInventory.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    private boolean canVillagerPickupItem(Item itemIn) {
        return itemIn instanceof IPlantable;
    }

    public boolean func_175553_cp() {
        return true;
    }

    public boolean func_175555_cq() {
        return true;
    }

    public boolean func_175557_cr() {
        return true;
    }

    public boolean func_175559_s(int multiplier) {
        return true;
    }

    public boolean func_175556_cs() {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.villagerInventory.func_70301_a(i);
            if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof IPlantable)) continue;
            return true;
        }
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }

    static class RepData {
        public CivilizationType civ;
        public Province prov;
        public Integer rep;

        RepData() {
        }
    }
}

