/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;

public class EntityToroNpc
extends EntityCreature {
    public EntityPlayer annoyedAt = null;
    public int isAnnoyedTimer = 0;
    public EntityPlayer underAttack = null;
    public int underAttackTimer = 0;
    public EntityPlayer murderWitness = null;
    public int murderTimer = 0;
    public int actionTimer = 5;
    public boolean inCombat = false;
    public float capeAni = 0.0f;
    public boolean capeAniUp = true;
    public boolean interactTalkReady = true;
    public boolean returningToPost = false;
    EntityPlayer talkingWith = null;
    protected boolean hitSafety = true;
    public Random field_70146_Z = new Random();
    public static DataParameter<Integer> RAID_X = EntityDataManager.func_187226_a(EntityToroNpc.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_Y = EntityDataManager.func_187226_a(EntityToroNpc.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_Z = EntityDataManager.func_187226_a(EntityToroNpc.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<String> CIV = EntityDataManager.func_187226_a(EntityToroNpc.class, (DataSerializer)DataSerializers.field_187194_d);
    private CivilizationType civ = null;
    public static DataParameter<String> PROV_ID = EntityDataManager.func_187226_a(EntityToroNpc.class, (DataSerializer)DataSerializers.field_187194_d);
    private UUID prov_uuid = null;

    public void playChatSound() {
        this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CIV, (Object)String.valueOf(""));
        this.func_184212_Q().func_187214_a(PROV_ID, (Object)String.valueOf(""));
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_X);
    }

    public Integer getRaidLocationY() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_Y);
    }

    public Integer getRaidLocationZ() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_Z);
    }

    public EntityToroNpc(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_70105_a(0.6f, 1.9f);
        this.field_70728_aV = 30;
        Arrays.fill(this.field_82174_bp, ToroQuestConfiguration.guardHandsDropChance);
        Arrays.fill(this.field_184655_bs, ToroQuestConfiguration.guardArmorDropChance);
        this.func_110177_bN();
        this.func_98053_h(false);
        this.func_184641_n(false);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.pledgeAllegianceIfUnaffiliated(false);
    }

    public Province getHomeProvince() {
        return CivilizationUtil.getProvinceFromUUID(this.field_70170_p, this.getUUID());
    }

    public Province getStandingInProvince() {
        if (this.func_180425_c() == BlockPos.field_177992_a) {
            return null;
        }
        return CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj);
    }

    protected boolean pledgeAllegianceIfUnaffiliated(boolean force) {
        if ((force || this.getCivilization() == null || this.getUUID() == null) && this.pledgeAllegiance(this.getStandingInProvince())) {
            if (force) {
                this.playTameEffect((byte)6);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return true;
        }
        return false;
    }

    public boolean pledgeAllegianceTo(Province p) {
        if (this.pledgeAllegiance(p)) {
            this.playTameEffect((byte)6);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return true;
        }
        return false;
    }

    protected boolean pledgeAllegiance(Province prov) {
        if (prov != null) {
            this.setCivilization(prov.getCiv());
            this.setUUID(prov.getUUID());
            this.onPledge(prov);
            return true;
        }
        return false;
    }

    protected boolean pledgeAllegiance() {
        return this.pledgeAllegiance(this.getStandingInProvince());
    }

    protected void onPledge(Province prov) {
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
        compound.func_74778_a("provID", (String)this.func_184212_Q().func_187225_a(PROV_ID));
        compound.func_74778_a("civ", (String)this.func_184212_Q().func_187225_a(CIV));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
        this.setCivilization(this.enumCiv(compound.func_74779_i("civ")));
        this.setUUID(this.enumUUID(compound.func_74779_i("provID")));
    }

    public void setCivilization(@Nullable CivilizationType civ) {
        if (civ == null) {
            this.func_184212_Q().func_187227_b(CIV, (Object)"");
        } else {
            this.func_184212_Q().func_187227_b(CIV, (Object)civ.toString());
        }
    }

    public CivilizationType getCivilization() {
        if (this.civ != null) {
            return this.civ;
        }
        this.civ = this.enumCiv((String)this.func_184212_Q().func_187225_a(CIV));
        return this.civ;
    }

    protected CivilizationType enumCiv(String s) {
        try {
            CivilizationType civ = CivilizationType.valueOf(s);
            return civ;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setUUID(@Nullable UUID uuid) {
        if (uuid == null) {
            this.func_184212_Q().func_187227_b(PROV_ID, (Object)"");
        } else {
            this.func_184212_Q().func_187227_b(PROV_ID, (Object)uuid.toString());
        }
    }

    public UUID getUUID() {
        if (this.prov_uuid != null) {
            return this.prov_uuid;
        }
        this.prov_uuid = this.enumUUID((String)this.func_184212_Q().func_187225_a(PROV_ID));
        return this.prov_uuid;
    }

    protected UUID enumUUID(String s) {
        try {
            UUID uuid = UUID.fromString(s);
            return uuid;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean returnToPost() {
        if (this.func_70781_l() || this.func_70638_az() != null) {
            return false;
        }
        int raid_y = this.getRaidLocationY();
        if (raid_y == 0) {
            return false;
        }
        int raid_x = this.getRaidLocationX();
        int raid_z = this.getRaidLocationZ();
        if (raid_y > 0 && this.func_70661_as().func_75492_a((double)raid_x, (double)raid_y, (double)raid_z, 0.6)) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, raid_x, raid_z);
            return true;
        }
        double x = (double)raid_x - this.field_70165_t;
        double z = (double)raid_z - this.field_70161_v;
        double xz = Math.abs(x) + Math.abs(z);
        if (xz <= 3.0) {
            BlockPos moveTo;
            if (raid_y > 0 && Math.abs(this.field_70163_u - (double)raid_y) >= 3.0 && (moveTo = EntityAIRaid.findValidSurface(this.field_70170_p, new BlockPos((double)raid_x, this.field_70163_u, (double)raid_z), 8)) != null && this.func_70661_as().func_75492_a((double)moveTo.func_177958_n(), (double)moveTo.func_177956_o(), (double)moveTo.func_177952_p(), 0.6)) {
                AIHelper.faceEntitySmart((EntityLivingBase)this, moveTo.func_177958_n(), moveTo.func_177952_p());
                return true;
            }
            this.returningToPost = false;
            return false;
        }
        BlockPos moveTo = EntityAIRaid.findValidSurface(this.field_70170_p, new BlockPos(x = x / xz * 16.0 + this.field_70165_t, this.field_70163_u, z = z / xz * 16.0 + this.field_70161_v), 8);
        if (moveTo != null && this.func_70661_as().func_75492_a((double)moveTo.func_177958_n(), (double)moveTo.func_177956_o(), (double)moveTo.func_177952_p(), 0.6)) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, moveTo.func_177958_n(), moveTo.func_177952_p());
            return true;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z));
        if (!(vec3d != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)8, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z))) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)20, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z))) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6))) {
            return false;
        }
        AIHelper.faceEntitySmart((EntityLivingBase)this, (int)vec3d.field_72450_a, (int)vec3d.field_72449_c);
        return true;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean successfulAttack;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (successfulAttack = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            this.handleSuccessfulAttack(entityIn, knockback);
        }
        return successfulAttack;
    }

    protected void handleSuccessfulAttack(Entity entityIn, int knockback) {
        int j;
        if (knockback > 0 && entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
        }
        if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
            entityIn.func_70015_d(j * 4);
        }
        if (entityIn instanceof EntityPlayer) {
            ItemStack itemstack1;
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            ItemStack itemstack = this.func_184614_ca();
            ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
            if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() instanceof ItemShield) {
                float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                if (this.field_70146_Z.nextFloat() < f1) {
                    entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                    this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                }
            }
        }
        this.func_174815_a((EntityLivingBase)this, entityIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean isFriendly(EntityPlayer player) {
        return !(this.murderWitness != null && this.murderWitness == player || this.underAttack != null && this.underAttack == player || this.annoyedAt != null && this.annoyedAt == player);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean actionReady() {
        return this.actionTimer < 1;
    }

    public boolean isAnnoyed() {
        return this.isAnnoyedTimer > 0;
    }

    public int actionTimer() {
        return this.actionTimer;
    }

    public void setActionTimer(int n) {
        this.actionTimer = n;
    }

    public void setAnnoyed(EntityPlayer player) {
        this.isAnnoyedTimer = this.isAnnoyed() ? 8 : 4;
        this.annoyedAt = player;
    }

    public boolean isAnnoyedAt(EntityPlayer player) {
        return this.isAnnoyed() && this.annoyedAt != null && this.annoyedAt == player;
    }

    public void setUnderAttack(EntityPlayer player) {
        this.setAnnoyed(player);
        this.underAttack = player;
        this.underAttackTimer = 16;
    }

    public void setMurder(EntityPlayer player) {
        this.setUnderAttack(player);
        this.murderWitness = player;
        this.murderTimer = 64;
    }

    public EntityPlayer murderWitness() {
        return this.murderWitness;
    }

    public EntityPlayer underAttack() {
        return this.underAttack;
    }

    public boolean inCombat() {
        return this.func_70638_az() != null || this.func_70643_av() != null || this.inCombat;
    }

    public boolean func_110175_bO() {
        return false;
    }

    public BlockPos func_180486_cf() {
        return null;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    public void chat(EntityToroNpc guard, EntityPlayer player, String message, @Nullable String extra) {
    }

    public void callForHelp(EntityLivingBase attacker) {
    }

    public int func_184649_cE() {
        return 10;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, false);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.playTameEffect(id);
        }
        if (id == 7) {
            this.playTameEffect(id);
        } else if (id == 6) {
            this.playTameEffect(id);
        }
        super.func_70103_a(id);
    }

    public void playTameEffect(byte id) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (id == 6) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        } else if (id == 7) {
            enumparticletypes = EnumParticleTypes.VILLAGER_ANGRY;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected static void lookAtSpeaking(EntityToroNpc entity, EntityPlayer player) {
        entity.func_70625_a((Entity)player, 30.0f, 30.0f);
        entity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        entity.talkingWith = player;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }
}

