/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAIThrow;
import net.torocraft.toroquest.entities.render.RenderSpiderLord;
import net.torocraft.toroquest.generation.WorldGenPlacer;

public class EntitySpiderLord
extends EntityCaveSpider
implements IMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntitySpiderLord.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_X = EntityDataManager.func_187226_a(EntitySpiderLord.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_Y = EntityDataManager.func_187226_a(EntitySpiderLord.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> RAID_Z = EntityDataManager.func_187226_a(EntitySpiderLord.class, (DataSerializer)DataSerializers.field_187192_b);
    public static String NAME = "spider_lord";
    private int combatTimer = 2;
    public boolean isClearWebsReady = false;
    public int bossTimer = 160;
    Integer targetLastPosX = null;
    Integer targetLastPosZ = null;
    protected boolean explode = false;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private int lastActiveTime = 0;
    private int timeSinceIgnited = 0;
    private int fuseTime = 30;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationY() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Y));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiderLord.class, (IRenderFactory)new IRenderFactory<EntitySpiderLord>(){

            public RenderSpiderLord createRenderFor(RenderManager manager) {
                return new RenderSpiderLord(manager);
            }
        });
    }

    public boolean func_174833_aM() {
        return false;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_110159_bB() {
        this.func_110160_i(true, true);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public int func_184649_cE() {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(64.0);
    }

    public static void registerFixesSpider(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySpiderLord.class);
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntitySpiderLord.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0xFFFFFF, (int)0x909090);
    }

    public EntitySpiderLord(World world) {
        super(world);
        this.setUpEntity();
        int x = this.getRaidLocationX();
        int y = this.getRaidLocationY();
        int z = this.getRaidLocationZ();
        if (y != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
        }
    }

    private void setUpEntity() {
        this.func_110163_bv();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.lastActiveTime = 0;
        this.timeSinceIgnited = 0;
        this.fuseTime = 30;
        this.field_70178_ae = true;
        this.setCreeperState(-1);
        this.func_70105_a(3.9f, 1.9f);
        this.setRealSize(3.9f, 1.9f);
        this.field_70728_aV = 400;
        this.field_70138_W = 4.05f;
    }

    public EntitySpiderLord(World world, int x, int y, int z) {
        super(world);
        this.setUpEntity();
        this.setRaidLocation(x, y, z);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid((EntityCreature)this, x, z, 0.8));
    }

    public float func_70047_e() {
        return 1.85f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0 * (double)ToroQuestConfiguration.bossHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * (double)ToroQuestConfiguration.bossAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        WorldGenPlacer.clearTrees(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 32);
        livingdata = super.func_180482_a(difficulty, livingdata);
        if ((int)this.field_70163_u != 0 && this.getRaidLocationY() == 0) {
            this.setRaidLocation((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        return livingdata;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_184651_r() {
        this.ai();
    }

    protected void ai() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIThrow((EntityCreature)this, 0.5, false, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void bossAbility(EntityLivingBase leapTarget) {
        double dist = this.func_70068_e((Entity)leapTarget);
        if (dist < 40.0) {
            this.func_70661_as().func_75499_g();
        }
        if (this.bossTimer > 0) {
            --this.bossTimer;
        }
        if (this.bossTimer == 40) {
            if (dist < 516.0) {
                this.targetLastPosX = (int)leapTarget.field_70165_t;
                this.targetLastPosZ = (int)leapTarget.field_70161_v;
                this.func_184185_a(SoundEvents.field_187817_fK, 2.0f, 1.2f);
                this.func_184185_a(SoundEvents.field_187572_ar, 2.0f, 0.8f);
                this.setCreeperState(1);
            } else {
                ++this.bossTimer;
            }
        }
        if (this.bossTimer <= 40 && this.bossTimer > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        }
        if (this.bossTimer < 1) {
            this.isClearWebsReady = true;
            this.bossTimer = 150 + this.func_70681_au().nextInt(50);
            this.combatTimer = 2;
            this.leap(leapTarget);
        }
    }

    protected void leap(EntityLivingBase leapTarget) {
        double d0 = 0.0;
        double d1 = 0.0;
        if (this.targetLastPosX != null && this.targetLastPosZ != null) {
            d0 = (double)this.targetLastPosX.intValue() - this.field_70165_t;
            d1 = (double)this.targetLastPosZ.intValue() - this.field_70161_v;
        }
        this.func_184185_a(SoundEvents.field_187552_ah, 3.0f, 0.3f);
        this.func_184185_a(SoundEvents.field_187749_eC, 3.0f, 0.8f);
        this.func_70634_a(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70024_g(d0 / 6.0, 2.0, d1 / 6.0);
        }
    }

    private void clearWebs() {
        if (!this.isClearWebsReady) {
            return;
        }
        this.isClearWebsReady = false;
        this.lastActiveTime = 0;
        this.timeSinceIgnited = 0;
        this.fuseTime = 30;
        this.setCreeperState(-1);
        this.func_70656_aK();
        this.func_70656_aK();
        this.func_70656_aK();
        this.func_184185_a(SoundEvents.field_187539_bB, 2.0f, 0.8f);
        this.func_184185_a(SoundEvents.field_187754_de, 2.0f, 0.6f);
        this.func_184185_a(SoundEvents.field_187752_dd, 2.0f, 0.4f);
        this.playStompEffect();
        this.field_70170_p.func_72960_a((Entity)this, (byte)36);
        int x = this.func_180425_c().func_177958_n();
        int y = this.func_180425_c().func_177956_o();
        int z = this.func_180425_c().func_177952_p();
        int range = 28;
        for (int xx = -range / 2; xx < range / 2; ++xx) {
            for (int yy = -range / 4; yy < range / 4; ++yy) {
                for (int zz = -range / 2; zz < range / 2; ++zz) {
                    if (!(Math.pow(Math.abs(xx) + 7, 2.0) + Math.pow(Math.abs(zz) + 7, 2.0) <= 554.0)) continue;
                    BlockPos pos = new BlockPos((Vec3i)new BlockPos(x + xx, y + yy, z + zz));
                    IBlockState block = this.field_70170_p.func_180495_p(pos);
                    if (block == Blocks.field_150321_G.func_176223_P()) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (!(block.func_177230_c() instanceof BlockDynamicLiquid) && !(block.func_177230_c() instanceof BlockStaticLiquid)) continue;
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                }
            }
        }
        this.explode = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 36) {
            this.playStompEffect();
        }
        super.func_70103_a(id);
    }

    private void explode() {
        if (!this.explode) {
            return;
        }
        this.explode = false;
        this.targetLastPosX = null;
        this.targetLastPosZ = null;
        List e = this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(22.0, 22.0, 22.0), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase entity) {
                return true;
            }
        });
        for (EntityLivingBase entity : e) {
            double dist = this.func_70068_e((Entity)entity) + 1.0;
            if (entity == this || !(dist < 512.0)) continue;
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + (512.0 - dist) / 256.0, entity.field_70161_v);
            entity.func_70024_g(0.8 / (entity.field_70165_t - this.field_70165_t), MathHelper.func_151237_a((double)(37.5 / Math.sqrt(dist)), (double)1.0, (double)15.0), 0.8 / (entity.field_70161_v - this.field_70161_v));
            entity.field_70133_I = true;
            entity.func_70097_a(new DamageSource("explosion"), (float)((22.0 - Math.sqrt(dist)) * (double)ToroQuestConfiguration.bossAttackDamageMultiplier));
            entity.func_130011_c((Entity)this);
            entity.func_70604_c((EntityLivingBase)this);
        }
    }

    protected void playStompEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.CLOUD;
        for (int i = 0; i <= 16; ++i) {
            double x = (double)MathHelper.func_76133_a((double)((double)i / 16.0)) * 1.0;
            double y = (double)MathHelper.func_76133_a((double)((16.0 - (double)i) / 16.0)) * 1.0;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, y, new int[0]);
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), -x, 0.0, y, new int[0]);
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), x, 0.0, -y, new int[0]);
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + (double)0.2f, this.field_70161_v + (double)(this.field_70130_N / 2.0f), -x, 0.0, -y, new int[0]);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.bossTimer <= 40) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 2.0f, 0.7f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70122_E && this.isClearWebsReady) {
            if (this.combatTimer < 1) {
                this.clearWebs();
                this.combatTimer = 2;
            } else {
                --this.combatTimer;
            }
        } else if (this.explode) {
            if (this.combatTimer < 1) {
                this.explode();
                this.combatTimer = 2;
            } else {
                --this.combatTimer;
            }
        }
        if (this.func_70638_az() != null) {
            this.bossAbility(this.func_70638_az());
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
        } else {
            this.bossTimer = 100;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        }
        if (this.field_70173_aa % 25 == 0) {
            this.func_70691_i(ToroQuestConfiguration.bossHealthMultiplier);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (source == null || this.func_180431_b(source) || source == DamageSource.field_76379_h || source.func_76346_g() == null || !this.func_70089_S()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            double dist = source.func_76346_g().func_174818_b(this.func_180425_c());
            if (dist > 256.0) {
                amount = (float)((double)amount * (256.0 / dist));
            }
            if (!(source.func_76346_g() instanceof EntityPlayer)) {
                amount /= 16.0f;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropLoot();
            int x = this.getRaidLocationX();
            int y = this.getRaidLocationY();
            int z = this.getRaidLocationZ();
            if (y == 0) {
                x = this.func_180425_c().func_177958_n();
                y = this.func_180425_c().func_177956_o();
                z = this.func_180425_c().func_177952_p();
            }
            int range = 64;
            for (int xx = -range; xx < range; ++xx) {
                for (int yy = -32; yy < 32; ++yy) {
                    for (int zz = -range; zz < range; ++zz) {
                        BlockPos pos = new BlockPos(x + xx, y + yy, z + zz);
                        IBlockState block = this.field_70170_p.func_180495_p(pos);
                        if (block != Blocks.field_150321_G.func_176223_P()) continue;
                        this.field_70170_p.func_175698_g(pos);
                    }
                }
            }
            this.createWebPatch(this.field_70170_p, new BlockPos(x, y, z));
        }
    }

    protected void createWebPatch(World world, BlockPos start) {
        int radius = 17;
        int x = start.func_177958_n();
        int z = start.func_177952_p();
        block0: for (int xx = -radius / 2; xx < radius / 2; ++xx) {
            for (int zz = -radius / 2; zz < radius / 2; ++zz) {
                int distFromCenter = (int)(Math.pow(Math.abs(xx) + 4, 2.0) + Math.pow(Math.abs(zz) + 4, 2.0));
                if (world.field_73012_v.nextInt(distFromCenter) >= 64 || distFromCenter > 181) continue;
                BlockPos pos = new BlockPos(x + xx, 0, z + zz);
                if ((pos = this.getSurfacePosition(world, pos)) == null) continue block0;
                pos = pos.func_177984_a();
                world.func_175656_a(pos, Blocks.field_150321_G.func_176223_P());
            }
        }
    }

    private BlockPos getSurfacePosition(World world, BlockPos start) {
        IBlockState blockState;
        BlockPos search = new BlockPos(start.func_177958_n(), world.func_72940_L() / 2, start.func_177952_p());
        while (search.func_177956_o() > 0 && !((blockState = world.func_180495_p(search = search.func_177977_b())).func_177230_c() instanceof BlockLiquid) && !blockState.func_185914_p()) {
        }
        return search;
    }

    private void dropLoot() {
        this.dropTrophy();
        this.dropLootItem(Items.field_151007_F, this.field_70146_Z.nextInt(50) + 50);
        this.dropLootItem(Items.field_151016_H, this.field_70146_Z.nextInt(50) + 50);
        this.dropLootItem(new ItemStack(Blocks.field_150321_G, this.field_70146_Z.nextInt(15) + 15));
        this.dropLootItem(Items.field_151070_bp, 8);
    }

    private void dropTrophy() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:trophy_spider"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = 0.5;
        dropItem.field_70179_y = 0.0;
        dropItem.field_70159_w = 0.0;
        this.field_70170_p.func_72838_d((Entity)dropItem);
        dropItem.func_184195_f(true);
    }

    private void dropLootItem(Item item, int amount) {
        if (amount == 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = new ItemStack(item);
            EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
            dropItem.func_174868_q();
            dropItem.field_70181_x = this.field_70146_Z.nextDouble();
            dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
            dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
            this.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    private void dropLootItem(ItemStack item) {
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item.func_77946_l());
        dropItem.func_174868_q();
        dropItem.field_70181_x = this.field_70146_Z.nextDouble();
        dropItem.field_70179_y = this.field_70146_Z.nextDouble() - 0.5;
        dropItem.field_70159_w = this.field_70146_Z.nextDouble() - 0.5;
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    protected SoundEvent func_184639_G() {
        this.func_184185_a(SoundEvents.field_187817_fK, this.func_70599_aP() * 3.0f, (float)(this.field_70146_Z.nextInt(10) / 10) + 0.6f);
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(SoundEvents.field_187821_fM, this.func_70599_aP() * 3.0f, (float)(this.field_70146_Z.nextInt(10) / 10) + 0.6f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_187819_fL, this.func_70599_aP() * 3.5f, (float)(this.field_70146_Z.nextInt(10) / 10) + 0.6f);
        return null;
    }

    protected SoundEvent getStepSound() {
        this.func_184185_a(SoundEvents.field_187823_fN, this.func_70599_aP() * 3.0f, 0.5f);
        return null;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected void setRealSize(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            if (this.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)this.field_70130_N, axisalignedbb.field_72338_b + (double)this.field_70131_O, axisalignedbb.field_72339_c + (double)this.field_70130_N));
            if (this.field_70130_N > f && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - this.field_70130_N, 0.0, f - this.field_70130_N);
            }
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }

    public static class GroupData
    implements IEntityLivingData {
    }
}

