/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.EntityToroVillager;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIAvoidEnemies;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAISmartTempt;
import net.torocraft.toroquest.entities.trades.ToroVillagerTrades;
import net.torocraft.toroquest.generation.village.util.VillagePieceBlockMap;
import net.torocraft.toroquest.item.ItemScrollEarth;
import net.torocraft.toroquest.item.ItemScrollFire;
import net.torocraft.toroquest.item.ItemScrollMoon;
import net.torocraft.toroquest.item.ItemScrollSun;
import net.torocraft.toroquest.item.ItemScrollWater;
import net.torocraft.toroquest.item.ItemScrollWind;
import net.torocraft.toroquest.item.ItemTownScroll;

public class EntityShopkeeper
extends EntityToroVillager
implements IMerchant {
    private boolean hasEmeraldBlock = false;
    public static String NAME = "shopkeeper";
    public static DataParameter<Integer> RAID_X;
    public static DataParameter<Integer> RAID_Y;
    public static DataParameter<Integer> RAID_Z;

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Y, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    protected void setRaidLocation(int x, int y, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Y, (Object)y);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_X);
    }

    public Integer getRaidLocationY() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_Y);
    }

    public Integer getRaidLocationZ() {
        return (Integer)this.func_184212_Q().func_187225_a(RAID_Z);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidY", this.getRaidLocationY().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
    }

    public boolean returnToPost() {
        int raid_y = this.getRaidLocationY();
        if (raid_y == 0) {
            return false;
        }
        int raid_x = this.getRaidLocationX();
        int raid_z = this.getRaidLocationZ();
        if (this.func_70661_as().func_75492_a((double)raid_x, (double)(1 + raid_y), (double)raid_z, 0.6)) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, raid_x, raid_z);
            return true;
        }
        double x = (double)raid_x - this.field_70165_t;
        double z = (double)raid_z - this.field_70161_v;
        double xz = Math.abs(x) + Math.abs(z);
        BlockPos moveTo = EntityAIRaid.findValidSurface(this.field_70170_p, new BlockPos(x = x / xz * 16.0 + this.field_70165_t, this.field_70163_u, z = z / xz * 16.0 + this.field_70161_v), 8);
        if (moveTo != null && this.func_70661_as().func_75492_a((double)moveTo.func_177958_n(), (double)moveTo.func_177956_o(), (double)moveTo.func_177952_p(), 0.6)) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, moveTo.func_177958_n(), moveTo.func_177952_p());
            return true;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z));
        if (!(vec3d != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)8, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z))) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6) || (vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)20, (int)8, (Vec3d)new Vec3d(x, this.field_70163_u, z))) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.6))) {
            return false;
        }
        AIHelper.faceEntitySmart((EntityLivingBase)this, (int)vec3d.field_72450_a, (int)vec3d.field_72449_c);
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidY"), compound.func_74762_e("raidZ"));
    }

    @Override
    public IEntityLivingData func_190672_a(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        return p_190672_2_;
    }

    private boolean postHasEmeraldBlock() {
        IBlockState b;
        int raid_y = this.getRaidLocationY();
        if (raid_y == 0) {
            return false;
        }
        int raid_x = this.getRaidLocationX();
        int raid_z = this.getRaidLocationZ();
        BlockPos pos = new BlockPos(raid_x, raid_y, raid_z);
        try {
            b = this.func_190670_t_().func_180495_p(pos).func_177230_c().func_176223_P();
        }
        catch (Exception e) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return b == Blocks.field_150475_bE.func_176223_P();
    }

    private boolean shouldReturnToEmeraldBlock() {
        return this.field_70170_p.func_72935_r() && !this.isUnderAttack();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 100 == 10) {
            BlockPos pos = this.func_180425_c().func_177977_b();
            if (pos == null) {
                return;
            }
            if (this.shouldReturnToEmeraldBlock()) {
                IBlockState b;
                try {
                    b = this.func_190670_t_().func_180495_p(pos).func_177230_c().func_176223_P();
                }
                catch (Exception e) {
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                    this.setEmeraldBlock(false);
                    return;
                }
                if (b == null) {
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                    this.setEmeraldBlock(false);
                    return;
                }
                if (b == Blocks.field_150475_bE.func_176223_P()) {
                    if (this.noShopKeepersNear(pos)) {
                        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
                        this.setEmeraldBlock(true, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        return;
                    }
                } else if (this.postHasEmeraldBlock()) {
                    this.returnToPost();
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                    this.returnToPost();
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    for (int xx = -8; xx <= 8; ++xx) {
                        for (int zz = -8; zz <= 8; ++zz) {
                            for (int yy = -3; yy <= 3; ++yy) {
                                pos = new BlockPos((Vec3i)new BlockPos(x + xx, y + yy, z + zz));
                                try {
                                    b = this.func_190670_t_().func_180495_p(pos).func_177230_c().func_176223_P();
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                if (b != Blocks.field_150475_bE.func_176223_P() || !this.noShopKeepersNear(pos) || !this.func_70661_as().func_75492_a((double)(x + xx), (double)(1 + y + yy), (double)(z + zz), 0.6)) continue;
                                this.setEmeraldBlock(true, x + xx, y + yy, z + zz);
                                return;
                            }
                        }
                    }
                }
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.setEmeraldBlock(false);
            return;
        }
    }

    public boolean hasEmeraldBlock() {
        return this.hasEmeraldBlock;
    }

    public void setEmeraldBlock(boolean b) {
        this.hasEmeraldBlock = b;
    }

    public void setEmeraldBlock(boolean b, int x, int y, int z) {
        this.setRaidLocation(x, y, z);
        this.hasEmeraldBlock = b;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers"))) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public String func_70005_c_() {
        return "Shopkeeper";
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString("Shopkeeper");
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntityShopkeeper.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)3, (boolean)true, (int)0, (int)14735033);
    }

    public EntityShopkeeper(World worldIn) {
        super(worldIn, 1);
    }

    public boolean func_70104_M() {
        return !this.hasEmeraldBlock();
    }

    private boolean noShopKeepersNear(BlockPos pos) {
        return this.func_130014_f_().func_175647_a(EntityShopkeeper.class, new AxisAlignedBB(pos).func_72314_b(2.0, 2.0, 2.0), (Predicate)new Predicate<EntityShopkeeper>(){

            public boolean apply(@Nullable EntityShopkeeper entity) {
                return entity != EntityShopkeeper.this;
            }
        }).isEmpty();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEnemies(this, 0.5, 0.65));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.65){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.isUnderAttack() && this.field_75267_a.func_70685_l((Entity)EntityShopkeeper.this.underAttack) || EntityShopkeeper.this.func_70027_ad()) {
                    return this.func_190863_f();
                }
                return false;
            }

            protected boolean func_190863_f() {
                Vec3d vec3d = null;
                vec3d = EntityShopkeeper.this.isUnderAttack() && EntityShopkeeper.this.underAttack.func_174791_d() != null ? RandomPositionGenerator.func_75461_b((EntityCreature)this.field_75267_a, (int)16, (int)8, (Vec3d)EntityShopkeeper.this.underAttack.func_174791_d()) : RandomPositionGenerator.func_75461_b((EntityCreature)this.field_75267_a, (int)16, (int)8, (Vec3d)this.field_75267_a.func_174791_d());
                if (vec3d == null) {
                    return false;
                }
                this.field_75266_c = vec3d.field_72450_a;
                this.field_75263_d = vec3d.field_72448_b;
                this.field_75264_e = vec3d.field_72449_c;
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookAtTradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISmartTempt((EntityCreature)this, 0.4, Items.field_151166_bC){

            @Override
            public boolean func_75250_a() {
                super.func_75250_a();
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.isUnderAttack() || !EntityShopkeeper.this.canTrade() || EntityShopkeeper.this.func_70027_ad() || EntityShopkeeper.this.func_70941_o()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70940_q() || EntityShopkeeper.this.isUnderAttack()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70940_q() || EntityShopkeeper.this.isUnderAttack()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70940_q() || EntityShopkeeper.this.isUnderAttack()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70940_q() || EntityShopkeeper.this.isUnderAttack()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5){

            public boolean func_75250_a() {
                Vec3d vec3d;
                if (EntityShopkeeper.this.hasEmeraldBlock() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70940_q() || EntityShopkeeper.this.isUnderAttack()) {
                    return false;
                }
                if (!this.field_179482_g) {
                    if (this.field_75457_a.func_70654_ax() >= 100) {
                        return false;
                    }
                    if (!this.field_75457_a.func_70090_H() && !this.field_75457_a.func_180799_ab() && this.field_75457_a.func_70681_au().nextInt(this.field_179481_f) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.func_190864_f()) == null) {
                    return false;
                }
                this.field_75455_b = vec3d.field_72450_a;
                this.field_75456_c = vec3d.field_72448_b;
                this.field_75453_d = vec3d.field_72449_c;
                this.field_179482_g = false;
                return true;
            }

            protected Vec3d func_190864_f() {
                if (!this.field_75457_a.func_70781_l() && (this.field_75457_a.func_70090_H() || this.field_75457_a.func_180799_ab())) {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)16, (int)8);
                    return vec3d == null ? super.func_190864_f() : vec3d;
                }
                return this.field_75457_a.func_70681_au().nextFloat() >= this.field_190865_h ? RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)12, (int)6) : super.func_190864_f();
            }
        });
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f){

            public boolean func_75250_a() {
                if (EntityShopkeeper.this.isUnderAttack() || !EntityShopkeeper.this.canTrade() || EntityShopkeeper.this.func_70027_ad() || EntityShopkeeper.this.func_70941_o() || EntityShopkeeper.this.func_70781_l()) {
                    this.field_75334_a = null;
                    return false;
                }
                if (EntityShopkeeper.this.func_70931_l_() != null) {
                    this.field_75334_a = EntityShopkeeper.this.func_70931_l_();
                    return true;
                }
                this.field_75334_a = null;
                return false;
            }
        });
    }

    @Override
    protected MerchantRecipeList createTradesBaseOnRep(EntityPlayer player, EntityToroVillager.RepData repData) {
        MerchantRecipeList recipeList = new MerchantRecipeList();
        try {
            Item item = Item.func_111206_d((String)ToroQuestConfiguration.scrollTradeItem);
            int amount = ToroQuestConfiguration.scrollTradeAmount;
            if (item != null && amount > 0) {
                switch (repData.civ) {
                    case EARTH: {
                        ItemTownScroll scroll = (ItemScrollEarth)Item.func_111206_d((String)"toroquest:scroll_earth");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getGreenBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                    case FIRE: {
                        ItemTownScroll scroll = (ItemScrollFire)Item.func_111206_d((String)"toroquest:scroll_fire");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getRedBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                    case SUN: {
                        ItemTownScroll scroll = (ItemScrollSun)Item.func_111206_d((String)"toroquest:scroll_sun");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getYellowBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                    case WATER: {
                        ItemTownScroll scroll = (ItemScrollWater)Item.func_111206_d((String)"toroquest:scroll_water");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getBlueBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                    case MOON: {
                        ItemTownScroll scroll = (ItemScrollMoon)Item.func_111206_d((String)"toroquest:scroll_moon");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getBlackBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                    case WIND: {
                        ItemTownScroll scroll = (ItemScrollWind)Item.func_111206_d((String)"toroquest:scroll_wind");
                        ItemStack itemstack = new ItemStack((Item)scroll, 1);
                        itemstack.func_77983_a("province", (NBTBase)new NBTTagString(repData.prov.id.toString()));
                        itemstack.func_77983_a("province_name", (NBTBase)new NBTTagString(repData.prov.getName().toString()));
                        itemstack.func_151001_c("Teleport scroll:  " + repData.prov.getName());
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(item, ToroVillagerTrades.getSellPrice(amount, repData.rep)), ItemStack.field_190927_a, itemstack, 0, 99999));
                        if (ToroQuestConfiguration.bannerTradeAmount <= 0) break;
                        ItemStack banner = VillagePieceBlockMap.getBrownBanner();
                        banner.func_151001_c(repData.civ.getDisplayName(player) + " Banner");
                        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, ToroVillagerTrades.getSellPrice(ToroQuestConfiguration.bannerTradeAmount, repData.rep)), ItemStack.field_190927_a, banner, 0, 99999));
                        break;
                    }
                }
            }
            MerchantRecipeList trades = ToroVillagerTrades.trades(this, player, repData.rep, repData.civ, "shopkeeper", "x");
            for (MerchantRecipe trade : trades) {
                recipeList.add((Object)trade);
            }
            return recipeList;
        }
        catch (Exception e) {
            return recipeList;
        }
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
        RAID_X = EntityDataManager.func_187226_a(EntityShopkeeper.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Y = EntityDataManager.func_187226_a(EntityShopkeeper.class, (DataSerializer)DataSerializers.field_187192_b);
        RAID_Z = EntityDataManager.func_187226_a(EntityShopkeeper.class, (DataSerializer)DataSerializers.field_187192_b);
    }
}

