/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest.entities;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.command.TextComponentHelper;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.config.ToroQuestConfiguration;
import net.torocraft.toroquest.entities.AIArcher;
import net.torocraft.toroquest.entities.AIAttackWithSword;
import net.torocraft.toroquest.entities.EntityAIFlee;
import net.torocraft.toroquest.entities.EntityAIRangedFlee;
import net.torocraft.toroquest.entities.EntityGuard;
import net.torocraft.toroquest.entities.EntityOrc;
import net.torocraft.toroquest.entities.EntitySmartArrow;
import net.torocraft.toroquest.entities.EntityToroMob;
import net.torocraft.toroquest.entities.ai.AIHelper;
import net.torocraft.toroquest.entities.ai.EntityAIBanditAttack;
import net.torocraft.toroquest.entities.ai.EntityAIRaid;
import net.torocraft.toroquest.entities.ai.EntityAISmartTempt;
import net.torocraft.toroquest.entities.ai.EntityAIZombieLeap;
import net.torocraft.toroquest.entities.render.RenderSentry;

public class EntitySentry
extends EntityToroMob
implements IRangedAttackMob,
IMob {
    protected ItemStack weaponMain = new ItemStack(Items.field_190931_a, 1);
    protected ItemStack weaponOff = new ItemStack(Items.field_190931_a, 1);
    protected final AIArcher<EntitySentry> aiArrowAttack = new AIArcher<EntitySentry>(this, 0.6, 40, 34.0f);
    protected boolean inCombat = false;
    public boolean forceFleeing = false;
    public int stance = 0;
    protected float strafeVer = 0.0f;
    protected float strafeHor = 0.0f;
    public int passiveTimer = -1;
    public boolean helloGreeting = true;
    public boolean emeraldGreeting = true;
    protected boolean blocking = false;
    protected int blockingTimer = 0;
    public int climbingTimer = 0;
    private boolean canTalk = true;
    public short potionImmunity = 0;
    private int potionUseTimer = 0;
    private int climbingCooldown = 0;
    public boolean useHealingPotion = false;
    public boolean flanking = false;
    public boolean fleeing = false;
    public boolean canShieldPush = true;
    protected int splashPotionTimer = 6;
    protected int hasSplashPotion = 1;
    public int limitPotions = this.field_70146_Z.nextInt(3);
    public double renderSizeXZ = 0.875 + this.field_70146_Z.nextDouble() / 10.0;
    public double renderSizeY = this.renderSizeXZ * (1.025 + (double)this.field_70146_Z.nextFloat() / 16.0);
    private ResourceLocation banditSkin = new ResourceLocation("toroquest:textures/entity/bandit/bandit_" + this.getSkinID() + ".png");
    protected static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    protected static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.34, 0).func_111168_a(false);
    protected static final DataParameter<Boolean> IS_DRINKING = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> SKIN_ID = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> BRIBED = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> DESPAWN_TIMER = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> RAID_X = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> RAID_Z = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    public static String NAME = "sentry";
    public int actionTimer = 5;
    protected EntityBoat boat;
    protected int boatTimer = 0;
    public int aggroTimer = 0;
    public int flankingTimer = 0;
    private boolean interacted = false;
    public int cannotReachTimer = 0;
    protected boolean climbUntilPlatform = false;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CLIMBING, (Object)0);
        this.func_184212_Q().func_187214_a(IS_DRINKING, (Object)false);
        this.func_184212_Q().func_187214_a(SKIN_ID, (Object)0);
        this.func_184212_Q().func_187214_a(BRIBED, (Object)false);
        this.func_184212_Q().func_187214_a(DESPAWN_TIMER, (Object)100);
        this.func_184212_Q().func_187214_a(RAID_X, (Object)0);
        this.func_184212_Q().func_187214_a(RAID_Z, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("customDespawnTimer", this.despawnTimer().intValue());
        compound.func_74768_a("raidX", this.getRaidLocationX().intValue());
        compound.func_74768_a("raidZ", this.getRaidLocationZ().intValue());
        compound.func_74768_a("skinID", this.getSkinID());
        compound.func_74757_a("bribed", this.getBribed());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRaidLocation(compound.func_74762_e("raidX"), compound.func_74762_e("raidZ"));
        this.setDespawnTimer(compound.func_74762_e("customDespawnTimer"));
        this.setBribed(compound.func_74767_n("bribed"));
        this.setSkinID(compound.func_74762_e("skinID"));
    }

    public Integer despawnTimer() {
        return (Integer)this.func_184212_Q().func_187225_a(DESPAWN_TIMER);
    }

    public Integer despawnTick() {
        int d = this.despawnTimer() - 1;
        this.func_184212_Q().func_187227_b(DESPAWN_TIMER, (Object)d);
        return d;
    }

    public void setDespawnTimer(int i) {
        this.func_184212_Q().func_187227_b(DESPAWN_TIMER, (Object)i);
    }

    protected void setRaidLocation(int x, int z) {
        this.func_184212_Q().func_187227_b(RAID_X, (Object)x);
        this.func_184212_Q().func_187227_b(RAID_Z, (Object)z);
    }

    public Integer getRaidLocationX() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_X));
    }

    public Integer getRaidLocationZ() {
        return (int)((Integer)this.func_184212_Q().func_187225_a(RAID_Z));
    }

    public EntitySentry(World worldIn, int x, int z) {
        super(worldIn);
        this.setRaidLocation(x, z);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid(this, x, z, 0.675));
        this.setCombatTask();
    }

    public EntitySentry(World worldIn) {
        super(worldIn);
        int x = this.getRaidLocationX();
        int z = this.getRaidLocationZ();
        if (x != 0 || z != 0) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRaid(this, x, z, 0.675));
        }
        this.setCombatTask();
    }

    public void setBribed(boolean b) {
        if (b) {
            this.playTameEffect(true);
        }
        this.func_184212_Q().func_187227_b(BRIBED, (Object)b);
    }

    public boolean getBribed() {
        return (Boolean)this.func_184212_Q().func_187225_a(BRIBED);
    }

    public int getSkinID() {
        int i = (Integer)this.func_184212_Q().func_187225_a(SKIN_ID);
        if (i < 1) {
            i = 1 + this.field_70146_Z.nextInt(ToroQuestConfiguration.banditSkins);
            this.setSkinID(i);
        }
        return i;
    }

    public void setSkinID(int i) {
        this.func_184212_Q().func_187227_b(SKIN_ID, (Object)i);
    }

    public boolean inCombat() {
        return this.func_70638_az() != null || this.func_70643_av() != null || this.inCombat;
    }

    public static void init(int entityId) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toroquest", NAME), EntitySentry.class, (String)NAME, (int)entityId, (Object)ToroQuest.INSTANCE, (int)80, (int)1, (boolean)true, (int)9383974, (int)14734169);
    }

    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, (IRenderFactory)new IRenderFactory<EntitySentry>(){

            public Render<EntitySentry> createRenderFor(RenderManager manager) {
                return new RenderSentry(manager);
            }
        });
    }

    public void func_70031_b(boolean b) {
        if (this.func_70638_az() != null && !this.isFleeing() && !(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
        }
        super.func_70031_b(b);
    }

    public String getChatName() {
        return "Bandit";
    }

    public boolean func_145818_k_() {
        if (this.actionTimer <= 3 || this.func_95999_t() == null || this.func_95999_t().equals("...") || this.func_95999_t().equals(this.getChatName())) {
            this.func_174805_g(false);
            return false;
        }
        this.func_174805_g(true);
        return true;
    }

    public ResourceLocation getSkin() {
        return this.banditSkin;
    }

    @Override
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public double func_70033_W() {
        return -0.5;
    }

    public boolean func_110175_bO() {
        return false;
    }

    public BlockPos func_180486_cf() {
        return null;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public double getRenderSizeXZ() {
        return this.renderSizeXZ;
    }

    public double getRenderSizeY() {
        return this.renderSizeY;
    }

    public boolean func_184603_cC() {
        return this.potionImmunity <= 0;
    }

    public float func_70047_e() {
        return 1.89f;
    }

    public int func_184649_cE() {
        return 5;
    }

    public void chat(EntityPlayer player, String message, @Nullable String extra) {
        if (ToroQuestConfiguration.guardsHaveDialogue && !(this instanceof EntityOrc)) {
            if (this.func_70032_d((Entity)player) > 12.0f) {
                return;
            }
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            this.func_70625_a((Entity)player, 30.0f, 30.0f);
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            try {
                int i = player.field_70170_p.field_73012_v.nextInt(Integer.parseInt(TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.bandit." + message), (Object[])new Object[0]).func_150260_c()));
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.bandit." + message + i), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
                this.func_96094_a(s);
                this.func_174805_g(true);
                this.actionTimer = 5;
            }
            catch (Exception e) {
                String s = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)("entity.toroquest.bandit." + message), (Object[])new Object[0]).func_150260_c().replace("@p", player.getDisplayNameString());
                if (extra != null) {
                    s.replace("@e", extra);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7l" + this.getChatName() + "\u00a7r: " + s));
                this.func_96094_a(s);
                this.func_174805_g(true);
                this.actionTimer = 5;
            }
            this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == null || player.field_70170_p.field_72995_K || !this.func_70089_S() || player.func_82150_aj()) {
            return true;
        }
        if (this.interacted) {
            this.interacted = true;
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        Province province = CivilizationUtil.getProvinceAt(this.field_70170_p, this.field_70176_ah, this.field_70164_aj);
        if (this.func_110143_aJ() >= this.func_110138_aP() && !this.inCombat()) {
            if (!this.getBribed()) {
                if (itemstack.func_77973_b() == Items.field_151166_bC) {
                    itemstack.func_190918_g(1);
                    this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                    this.func_70625_a((Entity)player, 30.0f, 30.0f);
                    List bandits = this.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 12.0, 25.0));
                    for (EntitySentry bandit : bandits) {
                        if (bandit.getBribed() || bandit.passiveTimer >= 4) continue;
                        bandit.passiveTimer = 4;
                        bandit.func_70661_as().func_75497_a((Entity)player, 0.45 + this.field_70146_Z.nextDouble() / 10.0);
                    }
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187716_o, SoundCategory.AMBIENT, 1.0f, 1.1f);
                    this.func_70661_as().func_75499_g();
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191268_hm, SoundCategory.AMBIENT, 1.0f, 1.1f);
                        this.setBribed(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.playTameEffect(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        if (this.field_70146_Z.nextInt(32) == 0) {
                            this.func_70624_b((EntityLivingBase)player);
                            this.callForHelp((EntityLivingBase)player);
                            this.chat(player, "betray", null);
                            this.canTalk = false;
                        }
                    }
                } else if (ToroQuestConfiguration.recruitBandits && item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers"))) {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    if (this.canTalk) {
                        this.chat(player, "moreemeralds", null);
                        this.canTalk = false;
                    }
                } else if (this.canTalk) {
                    if (this.field_70146_Z.nextBoolean() || this.passiveTimer < 1) {
                        this.chat(player, "hello", null);
                    } else {
                        this.chat(player, "moreemeralds", null);
                    }
                    this.canTalk = false;
                }
            } else if (ToroQuestConfiguration.recruitBandits && item.equals(Item.func_111206_d((String)"toroquest:recruitment_papers"))) {
                this.func_184185_a(SoundEvents.field_193784_dd, 1.2f, 1.2f);
                this.func_184185_a(SoundEvents.field_187713_n, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187698_i, 0.5f, 0.8f);
                itemstack.func_190918_g(1);
                EntityGuard newEntity = new EntityGuard(this.field_70170_p);
                newEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                newEntity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Vec3i)this.func_180425_c())), null);
                newEntity.func_82149_j((Entity)this);
                newEntity.actionTimer = 1;
                this.func_70106_y();
                this.field_70170_p.func_72838_d((Entity)newEntity);
                newEntity.setPlayerGuard(player.func_70005_c_());
                newEntity.actionTimer = 1;
                newEntity.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
                newEntity.func_70625_a((Entity)player, 30.0f, 30.0f);
                newEntity.spawnedNearBandits = true;
                newEntity.setMeleeWeapon();
                if (province != null && province.getCiv() != null) {
                    newEntity.chat(newEntity, player, "civbanditrecruit", province.getCiv().getDisplayName(player));
                } else {
                    newEntity.chat(newEntity, player, "nocivbanditrecruit", null);
                }
                this.playTameEffect(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            } else if (this.canTalk) {
                this.chat(player, "bribed", null);
                this.canTalk = false;
            }
        }
        return true;
    }

    public void throwSplashPotion(EntityLivingBase target) {
        double d0 = target.field_70163_u;
        double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
        double d2 = d0 - this.field_70163_u;
        double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        PotionType potiontype = PotionTypes.field_185253_y;
        if (this.field_70146_Z.nextInt(3) == 0 && !target.func_70644_a(MobEffects.field_76421_d)) {
            potiontype = PotionTypes.field_185246_r;
        } else if (this.field_70146_Z.nextInt(4) == 0 && target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
            potiontype = PotionTypes.field_185254_z;
            if (this.field_70146_Z.nextInt(3) == 0) {
                potiontype = PotionTypes.field_185219_B;
            }
        } else if (this.field_70146_Z.nextInt(4) == 0 && !target.func_70644_a(MobEffects.field_76437_t)) {
            potiontype = PotionTypes.field_185226_I;
        }
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187827_fP, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this || source.func_76346_g() instanceof EntitySentry) {
            damage = 0.0f;
        }
        return damage;
    }

    public void setDrinkingPotion(boolean drinkingPotion) {
        this.func_184212_Q().func_187227_b(IS_DRINKING, (Object)drinkingPotion);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DRINKING);
    }

    public void func_70645_a(DamageSource cause) {
        if (this.boat != null && !this.boat.func_184207_aI()) {
            this.boat.func_70106_y();
            this.boatTimer = 5;
        }
        this.func_174820_d(100 + EntityEquipmentSlot.HEAD.func_188454_b(), ItemStack.field_190927_a);
        super.func_70645_a(cause);
        if (this.func_70643_av() instanceof EntityPlayer) {
            this.dropLoot();
        }
    }

    protected void dropMask() {
        ItemStack stack = new ItemStack(Item.func_111206_d((String)"toroquest:bandit_helmet"));
        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
        this.field_70170_p.func_72838_d((Entity)dropItem);
    }

    public void dropLoot() {
        if (!this.field_70170_p.field_72995_K) {
            EntityItem dropItem;
            ItemStack stack;
            if (ToroQuestConfiguration.banditsDropMasks) {
                this.dropMask();
            }
            if (ToroQuestConfiguration.banditsDropEmeralds && this.field_70146_Z.nextInt(3) == 0) {
                stack = new ItemStack(Items.field_151166_bC, this.field_70146_Z.nextInt(3) + 1);
                dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                this.field_70170_p.func_72838_d((Entity)dropItem);
            }
            if (ToroQuestConfiguration.banditsDropPotions > 0 && (this.field_70146_Z.nextInt(ToroQuestConfiguration.banditsDropPotions) == 0 || this.func_184592_cb().func_77973_b() instanceof ItemPotion)) {
                if (this.field_70146_Z.nextInt(5) == 0) {
                    stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185254_z);
                    dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)dropItem);
                } else if (this.field_70146_Z.nextInt(4) == 0) {
                    stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185252_x);
                    dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)dropItem);
                } else if (this.field_70146_Z.nextInt(3) == 0) {
                    stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185246_r);
                    dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)dropItem);
                } else if (this.field_70146_Z.nextBoolean()) {
                    stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185226_I);
                    dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)dropItem);
                } else {
                    stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185250_v);
                    dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                    this.field_70170_p.func_72838_d((Entity)dropItem);
                }
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_184641_n(false);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ToroQuestConfiguration.banditBaseHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.banditAttackDamage);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)ToroQuestConfiguration.banditArmor);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)ToroQuestConfiguration.banditArmorToughness);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.393 + this.field_70146_Z.nextDouble() / 50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
    }

    public boolean isFleeing() {
        if (this.fleeing || this.forceFleeing) {
            super.func_70031_b(true);
            return true;
        }
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedFlee(this, 0.725));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlee(this, 0.725));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIZombieLeap((EntityLiving)this, 0.325, true){

            @Override
            public boolean func_75250_a() {
                if (EntitySentry.this.isDrinkingPotion() || EntitySentry.this.isFleeing() || EntitySentry.this.flanking || EntitySentry.this.blocking || EntitySentry.this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, false));
        if (!(this instanceof EntityOrc)) {
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISmartTempt(this, 0.55, Items.field_151166_bC){

                @Override
                public boolean func_75250_a() {
                    if (EntitySentry.this.flanking || EntitySentry.this.func_184218_aH() || EntitySentry.this.func_70638_az() != null || EntitySentry.this.isFleeing()) {
                        return false;
                    }
                    return super.func_75250_a();
                }
            });
        }
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater(this, 0.6){

            public boolean func_75250_a() {
                if (EntitySentry.this.flanking || EntitySentry.this.func_184218_aH() || EntitySentry.this.func_70638_az() != null || EntitySentry.this.isFleeing()) {
                    return false;
                }
                return super.func_75250_a();
            }

            @Nullable
            protected Vec3d func_190864_f() {
                if (this.field_75457_a.func_70090_H()) {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)15, (int)7);
                    return vec3d == null ? super.func_190864_f() : vec3d;
                }
                if (this.field_75457_a.func_70661_as().func_75500_f() && this.field_75457_a.func_70681_au().nextFloat() >= 0.002f) {
                    return RandomPositionGenerator.func_191377_b((EntityCreature)this.field_75457_a, (int)15, (int)7);
                }
                return super.func_190864_f();
            }
        });
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f){

            public boolean func_75250_a() {
                if (EntitySentry.this.flanking || EntitySentry.this.func_184218_aH() || EntitySentry.this.func_70638_az() != null || EntitySentry.this.isFleeing()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this){

            public boolean func_75250_a() {
                if (EntitySentry.this.flanking || EntitySentry.this.func_184218_aH() || EntitySentry.this.func_70638_az() != null || EntitySentry.this.isFleeing()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        if (!ToroQuestConfiguration.orcsAreNeutral || !(this instanceof EntityOrc)) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIBanditAttack(this));
        }
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this, true, new Class[0]){

            public boolean func_75250_a() {
                EntityLivingBase attacker = this.field_75299_d.func_70643_av();
                return attacker != null && this.func_75296_a(attacker, false) && attacker.getClass() != this.field_75299_d.getClass();
            }
        });
    }

    public void setCombatTask() {
        this.aiArrowAttack.setAttackCooldown(40);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackWithSword(this, 0.65));
        this.field_70714_bg.func_75776_a(3, this.aiArrowAttack);
        this.inCombat = false;
        this.blocking = false;
        this.func_70031_b(false);
        this.blockingTimer = 0;
        this.aggroTimer = 0;
        this.func_70624_b(null);
        this.canShieldPush = true;
        this.func_184602_cy();
        this.func_184598_c(EnumHand.MAIN_HAND);
        this.field_184628_bn = 0;
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
        this.strafeVer = 0.0f;
        this.strafeHor = 0.0f;
        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
        this.func_70661_as().func_75499_g();
    }

    protected float func_189749_co() {
        return this.func_184587_cr() ? 0.81f : 0.92f;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184187_bx() instanceof EntityBoat) {
                if (this.func_184187_bx() == this.boat) {
                    if (this.func_70638_az() != null) {
                        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                        double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                        double f = 1.0f + MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                        if (!(f < 7.0) || !(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
                            this.boat.func_70024_g(d0 / f * 0.05, 0.0, d1 / f * 0.05);
                        }
                    } else {
                        this.boat.func_70024_g((double)this.boat.func_174811_aO().func_82601_c() / 32.0 + this.field_70146_Z.nextGaussian() / 32.0, 0.0, (double)this.boat.func_174811_aO().func_82599_e() / 32.0 + this.field_70146_Z.nextGaussian() / 32.0);
                    }
                    this.boat.field_70133_I = true;
                    try {
                        PathPoint p = this.func_70661_as().func_75505_d().func_75870_c();
                        double d0 = ((double)p.field_75839_a - this.boat.field_70165_t) * 2.0;
                        double d2 = ((double)p.field_75838_c - this.boat.field_70161_v) * 2.0;
                        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                        this.boat.field_70177_z = f * 0.5f + this.field_70146_Z.nextFloat() * 0.05f;
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                    this.field_70125_A = 0.0f;
                    this.field_70165_t = this.boat.field_70165_t;
                    this.field_70163_u = this.boat.field_70163_u;
                    this.field_70161_v = this.boat.field_70161_v;
                    this.field_70133_I = true;
                    this.field_70177_z = this.boat.field_70177_z;
                    this.field_70759_as = this.boat.field_70177_z;
                    if (this.isEntityInsideOpaqueBlock(this.boat) || !this.boat.func_70090_H()) {
                        this.boat.func_70106_y();
                        this.boatTimer = 5;
                    }
                } else if (this.func_184187_bx().func_184188_bt().size() <= 1) {
                    this.boat = (EntityBoat)this.func_184187_bx();
                }
            } else if (this.func_70638_az() != null) {
                if (this.isFleeing()) {
                    super.func_70031_b(true);
                } else {
                    if (!(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
                        this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                    }
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
            }
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.interacted = false;
        if (this.func_184187_bx() instanceof EntityBoat) {
            this.field_70125_A = 0.0f;
            this.field_70165_t = this.func_184187_bx().field_70165_t;
            this.field_70163_u = this.func_184187_bx().field_70163_u;
            this.field_70161_v = this.func_184187_bx().field_70161_v;
            this.field_70133_I = true;
            this.field_70177_z = this.func_184187_bx().field_70177_z;
            this.field_70759_as = this.func_184187_bx().field_70177_z;
        } else if (this.func_70638_az() != null && !this.isFleeing()) {
            if (!(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (this.potionImmunity > 0) {
            this.potionImmunity = (short)(this.potionImmunity - 1);
        }
        if (this.flanking) {
            if (this.func_70661_as().func_75500_f() || this.func_70661_as().func_75505_d().func_75870_c() == null || this.func_70638_az() == null || (double)this.func_70032_d((Entity)this.func_70638_az()) >= 7.5 || this.blocking || this.isFleeing()) {
                this.flanking = false;
                this.flankingTimer = 0;
                this.func_70661_as().func_75499_g();
            } else {
                ++this.flankingTimer;
                if (this.flankingTimer < 8) {
                    this.func_70031_b(true);
                } else {
                    this.func_70031_b(false);
                    double speed = Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y);
                    if (this.flankingTimer > 64 || speed < 0.02 || this.func_70092_e(this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, this.func_70661_as().func_75505_d().func_75870_c().field_75838_c) < 3.0 - speed * 6.0) {
                        this.flanking = false;
                        this.flankingTimer = 0;
                        this.func_70661_as().func_75499_g();
                    }
                }
            }
        } else {
            this.flankingTimer = 0;
        }
        if (this.field_70173_aa % 100 == 0) {
            block86: {
                this.func_70691_i(1.0f);
                this.func_70031_b(false);
                super.func_85033_bc();
                if (this.despawnTimer() < 100 && this.despawnTick() < 0 && (this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(25.0, 15.0, 25.0)).isEmpty() || this.field_70170_p.func_72820_D() == 22000L && this.despawnTimer() < -50 || this.despawnTimer() < -100)) {
                    this.func_70606_j(0.0f);
                    this.func_70106_y();
                    return;
                }
                if (this.func_70638_az() != null) {
                    if (!(this.isDrinkingPotion() || this.blocking || this.isFleeing() || this.func_184614_ca().func_77973_b() instanceof ItemBow || !((double)this.func_70032_d((Entity)this.func_70638_az()) <= 6.5) || this.func_70090_H())) {
                        try {
                            double x = this.func_70638_az().field_70165_t;
                            double z = this.func_70638_az().field_70161_v;
                            double xdif = x - this.field_70165_t;
                            double xabs = Math.abs(xdif);
                            double zdif = z - this.field_70161_v;
                            double zabs = Math.abs(zdif);
                            double xz = xabs + zabs;
                            double xratio = xdif / xz;
                            double zratio = zdif / xz;
                            x += xratio * 2.0;
                            z += zratio * 2.0;
                            double dcap = MathHelper.func_151237_a((double)((double)this.func_70032_d((Entity)this.func_70638_az()) * (1.0 + this.field_70146_Z.nextDouble() / 3.0)), (double)(2.5 + this.field_70146_Z.nextDouble()), (double)6.0);
                            xratio *= dcap;
                            zratio *= dcap;
                            if (xabs > zabs) {
                                z += this.field_70146_Z.nextBoolean() ? xratio : -xratio;
                            } else {
                                x += this.field_70146_Z.nextBoolean() ? zratio : -zratio;
                            }
                            BlockPos pos = EntityAIRaid.findValidSurface(this.func_130014_f_(), new BlockPos(x, (double)this.func_70638_az().func_180425_c().func_177956_o(), z), 4);
                            if (pos == null || !this.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.65)) break block86;
                            this.allStance(true);
                            this.func_70605_aq().func_188488_a(0.2f, this.strafeHor);
                            this.func_70031_b(false);
                            this.flanking = true;
                            double dist = this.func_70068_e((Entity)this.func_70638_az());
                            Vec3d velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v);
                            if (velocityVector != null) {
                                double push = 8.0 + dist;
                                this.func_70024_g(velocityVector.field_72450_a / push, -0.01, velocityVector.field_72449_c / push);
                                this.field_70133_I = true;
                            }
                        }
                        catch (Exception x) {}
                    } else if (this.aggroTimer++ >= 5 && this.climbingTimer <= 0 && !this.func_70685_l((Entity)this.func_70638_az()) && this.func_70638_az().func_174791_d() != null) {
                        Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)20, (int)6, (Vec3d)this.func_70638_az().func_174791_d());
                        if (vec3d != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65)) {
                            this.forceFleeing = true;
                            this.func_70604_c(null);
                            this.func_70624_b(null);
                            this.aggroTimer = 0;
                            return;
                        }
                        vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)6, (Vec3d)this.func_70638_az().func_174791_d());
                        if (vec3d != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65)) {
                            this.forceFleeing = true;
                            this.func_70604_c(null);
                            this.func_70624_b(null);
                            this.aggroTimer = 0;
                            return;
                        }
                    }
                } else {
                    this.fleeing = false;
                }
            }
            if (this.boat != null && !this.boat.func_184207_aI()) {
                this.boat.func_70106_y();
                this.boatTimer = 5;
            }
            if (ToroQuestConfiguration.banditsUseBoats) {
                if (this.boatTimer < 1) {
                    if (!this.func_184218_aH() && this.func_70090_H() && this.field_70181_x < 0.12 && this.field_70181_x > -0.12 && !this.func_70661_as().func_75500_f() && !this.field_70128_L) {
                        this.field_70159_w = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70179_y = 0.0;
                        this.func_184609_a(EnumHand.MAIN_HAND);
                        this.boat = new EntityBoat(this.field_70170_p);
                        BlockPos pos = this.func_180425_c();
                        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        this.boat.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        this.field_70170_p.func_72838_d((Entity)this.boat);
                        this.func_184220_m((Entity)this.boat);
                    }
                } else {
                    --this.boatTimer;
                }
            }
            if (this.actionTimer > 0) {
                --this.actionTimer;
                if (this.actionTimer <= 3) {
                    this.func_96094_a("...");
                    this.func_174805_g(false);
                }
            } else {
                this.func_96094_a("...");
                this.func_174805_g(false);
            }
            if (this.passiveTimer > 0) {
                --this.passiveTimer;
            }
            if (this.func_184614_ca().func_190926_b() && this.func_184592_cb().func_190926_b()) {
                this.addEquipment();
            }
        }
        ItemStack iStackM = this.func_184614_ca();
        ItemStack iStackO = this.func_184592_cb();
        if (iStackO.func_77973_b() instanceof ItemShield) {
            if (!this.flanking && !this.isFleeing()) {
                this.sentryTypeTank();
            }
        } else if (iStackM.func_77973_b() instanceof ItemBow) {
            this.sentryTypeRanged();
        } else if (!this.flanking && !this.isFleeing()) {
            this.sentryTypeDPS();
        }
        if (this.func_70089_S() && this.func_110143_aJ() > 0.0f) {
            if (this.isDrinkingPotion()) {
                PotionType potiontype = PotionTypes.field_185250_v;
                this.func_184611_a(EnumHand.OFF_HAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                if (this.func_70638_az() != null) {
                    float dist = this.func_70032_d((Entity)this.func_70638_az());
                    if (this.field_70122_E && dist <= 36.0f) {
                        float push = 8.0f + dist * dist * 6.0f;
                        Vec3d velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v);
                        if (velocityVector != null) {
                            this.func_70024_g(velocityVector.field_72450_a / (double)push, 0.0, velocityVector.field_72449_c / (double)push);
                            this.field_70133_I = true;
                        }
                        try {
                            Vec3d vec3d;
                            if (!this.func_70781_l() && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)8, (int)4, (Vec3d)this.func_70638_az().func_174791_d())) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5)) {
                                this.func_70605_aq().func_188488_a(-0.5f, 0.0f);
                            }
                        }
                        catch (Exception vec3d) {
                            // empty catch block
                        }
                    }
                }
                if (this.potionUseTimer >= 12 && this.potionUseTimer % 4 == 0) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187664_bz, this.func_184176_by(), 0.35f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    }
                }
                if (this.potionUseTimer-- <= 0) {
                    this.useHealingPotion = false;
                    this.field_70733_aJ = -10.0f;
                    this.func_70031_b(false);
                    this.setDrinkingPotion(false);
                    ItemStack itemstack = this.func_184592_cb();
                    if (itemstack.func_77973_b() == Items.field_151068_bn) {
                        potiontype = PotionTypes.field_185251_w;
                        itemstack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype);
                        List list = PotionUtils.func_185189_a((ItemStack)itemstack);
                        if (list != null) {
                            for (PotionEffect potioneffect : list) {
                                this.func_70690_d(new PotionEffect(potioneffect));
                            }
                        }
                        ItemStack stack = new ItemStack(Items.field_151069_bo, 1);
                        EntityItem dropItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack.func_77946_l());
                        this.field_70170_p.func_72838_d((Entity)dropItem);
                        --this.limitPotions;
                        this.potionUseTimer = 10;
                        dropItem.field_70181_x = this.field_70146_Z.nextDouble() / 10.0;
                        dropItem.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) / 10.0;
                        dropItem.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) / 10.0;
                        this.playTameEffect(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 2.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    }
                    this.func_184185_a(SoundEvents.field_187725_r, 1.2f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                    this.func_184611_a(EnumHand.MAIN_HAND, this.weaponMain);
                    this.func_184611_a(EnumHand.OFF_HAND, this.weaponOff);
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else if (this.limitPotions > 0 && this.useHealingPotion && this.func_110143_aJ() / 2.0f <= this.func_110138_aP() & this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 3.0f) {
                this.func_70661_as().func_75499_g();
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                this.weaponMain = this.func_184614_ca();
                this.weaponOff = this.func_184592_cb();
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                PotionType potiontype = PotionTypes.field_185250_v;
                this.func_184611_a(EnumHand.OFF_HAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                this.potionUseTimer = 45;
                this.setDrinkingPotion(true);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 2.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                iattributeinstance.func_111124_b(MODIFIER);
                iattributeinstance.func_111121_a(MODIFIER);
            }
            if (this.func_70638_az() != null) {
                boolean collidedLower = this.collidedHorizontallyWide(this.field_70163_u);
                if (collidedLower && this.field_70181_x < -0.12) {
                    this.field_70181_x = -0.12;
                    this.field_70133_I = true;
                }
                if (this.climbUntilPlatform) {
                    boolean collidedUpper = this.collidedHorizontallyWide(this.field_70163_u + (double)this.field_70131_O);
                    boolean collidedVertically = this.collidedVerticallySmart(this.field_70163_u + (double)this.field_70131_O);
                    if (collidedUpper || collidedLower || collidedVertically) {
                        if (collidedVertically || collidedUpper && !collidedLower) {
                            this.doClimbing(true);
                        } else {
                            this.doClimbing(false);
                        }
                    } else {
                        this.endClimbing();
                    }
                } else if (this.climbingCooldown-- < 0 && (collidedLower || this.collidedHorizontallyWide(this.field_70163_u + (double)this.field_70131_O))) {
                    this.doClimbing(false);
                } else {
                    this.endClimbing();
                }
            } else {
                this.endClimbing();
            }
        }
    }

    public void faceAwayEntity(Entity entityIn) {
        float f1;
        double d1;
        double d0 = this.field_70165_t - entityIn.field_70165_t;
        double d2 = this.field_70161_v - entityIn.field_70161_v;
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entityIn;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70177_z = f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.aggroTimer = 0;
        if (source == null) {
            return super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            if ((amount /= 2.0f) <= 2.0f) {
                return false;
            }
            super.func_70097_a(source, amount);
        }
        if (this.climbingTimer > 0 || this.climbingCooldown > 40) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.22);
        } else if (!this.field_70122_E || this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b() == 2.22) {
            // empty if block
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
        if (source.func_76346_g() == null) {
            if (this instanceof EntityOrc) {
                Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4);
                if (vec3d != null) {
                    this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5);
                }
            } else if (this.field_70146_Z.nextBoolean()) {
                BlockPos pos = this.func_180425_c();
                IBlockState block = this.field_70170_p.func_180495_p(pos);
                if (block == Blocks.field_150353_l.func_176223_P() || block.func_177230_c() == Blocks.field_150353_l) {
                    Vec3d vec3d;
                    if (this.field_71093_bK == 0) {
                        this.func_184609_a(EnumHand.MAIN_HAND);
                        this.func_70024_g(0.0, 0.25, 0.0);
                        this.field_70133_I = true;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                    }
                    if ((vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4)) != null) {
                        this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5);
                    }
                } else if (block.func_177230_c() instanceof BlockFire) {
                    this.func_184609_a(EnumHand.MAIN_HAND);
                    this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
                    this.field_70170_p.func_175698_g(pos);
                } else if (this.field_70146_Z.nextBoolean() && !this.func_70661_as().func_75500_f()) {
                    this.func_70066_B();
                } else {
                    Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)8, (int)4);
                    if (vec3d != null) {
                        this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5);
                    }
                }
            }
            return super.func_70097_a(source, amount);
        }
        if (source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)source.func_76346_g();
            if (e instanceof EntitySentry) {
                if (e instanceof EntityOrc) {
                    if (this instanceof EntityOrc) {
                        if (this.func_70638_az() == e) {
                            this.func_70624_b(null);
                        }
                        return false;
                    }
                } else if (!(this instanceof EntityOrc)) {
                    if (this.func_70638_az() == e) {
                        this.func_70624_b(null);
                    }
                    return false;
                }
            }
            if (this.boat != null && this.func_70032_d((Entity)e) < 5.0f) {
                this.boat.func_70106_y();
                this.boatTimer = 5;
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.func_70624_b(e);
            }
            this.func_70604_c(e);
            this.callForHelp(e);
            if (e instanceof EntityPlayer) {
                this.enemy = (EntityPlayer)e;
            }
        }
        if (this.blocking && this.func_184583_d(source)) {
            if (this.field_70146_Z.nextBoolean()) {
                this.blockingTimer = 4 + this.field_70146_Z.nextInt(5);
            }
            double dist = source.func_76346_g().func_70068_e((Entity)this);
            if (!(source.func_76352_a() || source.func_82725_o() || source.func_76347_k())) {
                if (source.func_76346_g() instanceof EntityLivingBase) {
                    EntityLivingBase e = (EntityLivingBase)source.func_76346_g();
                    if (amount >= 5.0f && (e.func_184614_ca().func_77973_b() instanceof ItemAxe || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("halberd") || e.func_184614_ca().func_77973_b().getRegistryName().toString().contains("battleaxe"))) {
                        this.func_184602_cy();
                        this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)30);
                        if (dist < 16.0) {
                            this.canShieldPush = true;
                            Vec3d velocityVector = new Vec3d(this.field_70165_t - e.field_70165_t, 0.0, this.field_70161_v - e.field_70161_v);
                            if (velocityVector != null) {
                                this.func_70024_g(velocityVector.field_72450_a / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2), (0.22 - MathHelper.func_151237_a((double)(dist / 100.0), (double)0.0, (double)0.16)) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.0), velocityVector.field_72449_c / (dist + 1.0) * MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.2));
                                this.field_70133_I = true;
                            }
                        }
                        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                        this.blockingTimer = 50;
                        return super.func_70097_a(source, amount / 2.0f);
                    }
                    this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
                    if (dist < 16.0) {
                        if (this.canShieldPush) {
                            this.canShieldPush = false;
                            this.knockBackSmart(e, (float)(0.3 - dist / 100.0));
                        } else if (e.field_70122_E && !e.field_70160_al) {
                            this.knockBackSmart(e, 0.1f);
                        } else {
                            this.knockBackSmart(e, 0.0f);
                        }
                    }
                    this.field_70170_p.func_72960_a((Entity)this, (byte)29);
                    return false;
                }
            } else if (source.func_76352_a()) {
                this.blockingTimer = 6 + this.field_70146_Z.nextInt(5);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)29);
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70146_Z.nextFloat() / 5.0f);
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            Vec3d vec3d;
            if ((!this.func_70685_l(source.func_76346_g()) || (double)this.func_70032_d(source.func_76346_g()) >= 8.0 && this.func_70661_as().func_75494_a(source.func_76346_g()) == null) && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)6, (Vec3d)source.func_76346_g().func_174791_d())) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65)) {
                this.func_70604_c(this.func_70638_az());
                this.forceFleeing = true;
                this.aggroTimer = 0;
            }
            return true;
        }
        return false;
    }

    public void knockBackSmart(EntityLivingBase entityIn, float strength) {
        try {
            Vec3d pos = this.func_174791_d();
            Vec3d targetPos = entityIn.func_174791_d();
            entityIn.func_70653_a((Entity)entityIn, strength, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
            entityIn.field_70133_I = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean func_184583_d(DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        boolean flag2;
        boolean flag = id == 33;
        boolean flag1 = id == 36;
        boolean bl = flag2 = id == 37;
        if (id == 7) {
            this.playTameEffect(true);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187716_o, SoundCategory.AMBIENT, 1.0f, 1.2f, false);
        } else if (id == 6) {
            this.playTameEffect(false);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187716_o, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        if (!(id == 2 || flag || flag1 || flag2)) {
            if (id == 3) {
                SoundEvent soundevent1 = this.func_184615_bR();
                if (soundevent1 != null) {
                    this.func_184185_a(soundevent1, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.func_70606_j(0.0f);
                this.func_70645_a(DamageSource.field_76377_j);
            } else if (id == 30) {
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
            } else if (id == 29) {
                this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
            } else {
                super.func_70103_a(id);
            }
        } else {
            DamageSource damagesource;
            SoundEvent soundevent;
            this.field_70721_aZ = 1.5f;
            this.field_70172_ad = this.field_70771_an;
            this.field_70737_aN = this.field_70738_aO = 10;
            this.field_70739_aP = 0.0f;
            if (flag) {
                this.func_184185_a(SoundEvents.field_187903_gc, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if ((soundevent = this.func_184601_bQ(damagesource = flag2 ? DamageSource.field_76370_b : (flag1 ? DamageSource.field_76369_e : DamageSource.field_76377_j))) != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.func_70097_a(DamageSource.field_76377_j, -1.0f);
        }
        super.func_70103_a(id);
    }

    protected void playTameEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        if (!(this instanceof EntityOrc) && !this.field_70170_p.field_72995_K) {
            this.func_96094_a("...");
            this.func_174805_g(true);
        }
        this.func_98053_h(false);
        this.func_184641_n(false);
        this.canShieldPush = true;
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
        if (!this.field_70170_p.field_72995_K) {
            this.addEquipment();
        }
        return livingdata;
    }

    public void setMount() {
        if (this.field_70170_p.field_72995_K || !this.field_70170_p.func_175678_i(this.func_180425_c())) {
            return;
        }
        if (!(this.weaponMain.func_77973_b() instanceof ItemBow)) {
            this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditRangedWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditRangedWeapons.length)]), 1);
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                this.weaponMain = new ItemStack((Item)Items.field_151031_f, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcRanged.length)].split(",");
                this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                    enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcRanged.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                }
            }
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                return;
            }
            this.func_184611_a(EnumHand.MAIN_HAND, this.weaponMain);
            this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            EntityHorse mount = new EntityHorse(this.field_70170_p);
            mount.func_70873_a(24000);
            mount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            mount.func_110234_j(true);
            mount.func_174820_d(400, new ItemStack(Items.field_151141_av));
            if (this.field_70146_Z.nextInt(100) > ToroQuestConfiguration.goldenHorseArmorChance) {
                ItemStack itemStack = new ItemStack(Items.field_151136_bY, 1);
                mount.func_174820_d(401, itemStack);
            }
            mount.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            mount.func_70606_j(10.0f);
            mount.field_70130_N = 0.9f;
            mount.field_70138_W = 2.05f;
            mount.getEntityData().func_74768_a("despawnTimer", 100);
            mount.getEntityData().func_74776_a("raidSpeed", 1.0f);
            mount.getEntityData().func_74768_a("raidX", 0);
            mount.getEntityData().func_74768_a("raidZ", 0);
            this.field_70170_p.func_72838_d((Entity)mount);
            mount.func_184226_ay();
            this.func_184220_m((Entity)mount);
            mount.func_70024_g(this.field_70146_Z.nextGaussian() / 2.0, 0.1, this.field_70146_Z.nextGaussian() / 2.0);
            mount.field_70133_I = true;
            mount.func_70014_b(new NBTTagCompound());
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target == null || this.func_184614_ca() == null) {
            return;
        }
        this.aggroTimer = 0;
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        if (EnchantmentHelper.func_82781_a((ItemStack)this.func_184614_ca()).containsKey(Enchantment.func_180305_b((String)"minecraft:flame"))) {
            entityarrow.func_70015_d(12);
        }
        entityarrow.func_70243_d(true);
        entityarrow.func_70239_b(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 2.0 - (double)this.field_70131_O / 2.0 - entityarrow.field_70163_u - this.field_70146_Z.nextDouble();
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 2.2f, 1.2f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.5f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        return new EntitySmartArrow(this.field_70170_p, (EntityLivingBase)this);
    }

    protected void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemstack = this.func_184586_b(this.func_184600_cs());
            if (itemstack.func_77973_b() instanceof ItemShield) {
                this.field_184628_bn = 30;
                if (this.field_184628_bn > 0) {
                    this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.canShieldPush = true;
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn <= 0 && !this.field_70170_p.field_72995_K) {
                    this.func_71036_o();
                }
            } else if (itemstack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                    }
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.canShieldPush = true;
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (--this.field_184628_bn <= 0 && !this.field_70170_p.field_72995_K) {
                    this.func_71036_o();
                }
            } else {
                this.canShieldPush = true;
                this.func_184602_cy();
            }
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_184185_a(SoundEvents.field_191269_hn, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
        return super.func_184601_bQ(damageSourceIn);
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        if (this.field_70146_Z.nextBoolean()) {
            this.func_184185_a(SoundEvents.field_191245_bo, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        } else {
            this.func_184185_a(SoundEvents.field_193786_de, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
        return super.func_184615_bR();
    }

    public void forwardStance(boolean faceTarget) {
        this.stance = this.field_70146_Z.nextInt(6) + 5;
        this.strafeHor = this.getStrafe(this.stance);
        if (faceTarget && !this.isFleeing()) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
        }
    }

    public void allStance(boolean faceTarget) {
        this.stance = this.field_70146_Z.nextInt(8) + 3;
        this.strafeHor = this.getStrafe(this.stance);
        if (faceTarget && !this.isFleeing()) {
            AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
        }
    }

    private void sentryTypeDPS() {
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70638_az().getClass() != ((Object)((Object)this)).getClass()) {
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (!this.inCombat) {
                this.func_70661_as().func_75499_g();
                this.inCombat = true;
                this.forwardStance(false);
                this.blockingTimer = MathHelper.func_76125_a((int)this.field_70146_Z.nextInt((int)dist + 25), (int)10, (int)70);
            } else if (this.blockingTimer-- < 0) {
                this.allStance(true);
                this.blockingTimer = MathHelper.func_76125_a((int)this.field_70146_Z.nextInt((int)dist + 25), (int)10, (int)70);
            }
            if (this.limitPotions > 0 && !this.isDrinkingPotion()) {
                if (this.hasSplashPotion == 1 && dist >= 20.0 && dist <= 160.0 && this.func_184592_cb().func_190926_b() && !this.isBesideClimbableBlock()) {
                    if (this.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(3.0, 3.0, 3.0)).size() < 2) {
                        this.hasSplashPotion = 0;
                        PotionType potiontype = PotionTypes.field_185246_r;
                        this.func_184611_a(EnumHand.OFF_HAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
                    }
                } else if (this.hasSplashPotion == 0) {
                    if (dist >= 10.0 && dist <= 80.0) {
                        if (this.func_70685_l((Entity)this.func_70638_az()) && this.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(3.0, 3.0, 3.0)).size() < 2) {
                            --this.splashPotionTimer;
                            if (this.splashPotionTimer < 3) {
                                Vec3d velocityVector;
                                if (this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                                    double push = 1.0 + dist * 2.0;
                                    this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                                    this.field_70133_I = true;
                                }
                                if (this.splashPotionTimer < 0) {
                                    this.splashPotionTimer = 10;
                                    this.hasSplashPotion = -1;
                                    this.func_184609_a(EnumHand.OFF_HAND);
                                    this.throwSplashPotion(this.func_70638_az());
                                    --this.limitPotions;
                                    this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                                    this.func_70661_as().func_75499_g();
                                }
                            }
                        } else {
                            this.splashPotionTimer = 6;
                        }
                    } else {
                        this.splashPotionTimer = 6;
                    }
                }
            }
            if (!this.isFleeing() && !this.flanking) {
                Vec3d vec3d;
                float strafeMod = 1.0f;
                if (this.stance < 5) {
                    this.func_70031_b(false);
                    if (dist <= 32.0 && dist > 2.0) {
                        Vec3d velocityVector;
                        if (this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + 3.7 * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, -0.002, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                        this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)0.4f);
                        this.func_70605_aq().func_188488_a(-1.0f, this.strafeHor);
                    } else {
                        this.forwardStance(true);
                        this.func_70661_as().func_75499_g();
                        this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                    }
                    if (this.field_70146_Z.nextBoolean()) {
                        --this.blockingTimer;
                    }
                    return;
                }
                if (dist <= 2.0) {
                    this.strafeVer = 0.4f;
                } else if (dist <= 4.0) {
                    this.strafeVer = 0.8f;
                    strafeMod = 0.9f;
                } else if (dist <= 9.0) {
                    this.strafeVer = 0.9f;
                    strafeMod = 0.8f;
                } else {
                    this.strafeVer = 1.0f;
                    strafeMod = 0.7f;
                }
                if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                    Vec3d velocityVector;
                    if (dist >= 12.0) {
                        --this.blockingTimer;
                    } else if (dist <= 3.0 && this.field_70122_E && !this.func_70051_ag() && this.climbingCooldown < 40 && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                        double push = 1.0 + dist * dist;
                        this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                        this.field_70133_I = true;
                    }
                    if (this.field_70163_u + 1.5 < this.func_70638_az().field_70163_u) {
                        this.func_70605_aq().func_188488_a(this.strafeVer, 0.0f);
                        if (this.field_70122_E && this.field_70146_Z.nextInt(20) == 0) {
                            this.func_70024_g(0.0, 0.38, 0.0);
                            this.field_70133_I = true;
                        }
                    } else {
                        this.func_70605_aq().func_188488_a(this.strafeVer, this.strafeHor * strafeMod);
                    }
                } else if (this.func_70638_az().field_70122_E && !this.func_70638_az().field_70160_al && this.field_70122_E && !this.field_70160_al && !this.climbUntilPlatform && this.aggroTimer > 3 && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)6, (Vec3d)this.func_70638_az().func_174791_d())) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65)) {
                    this.forceFleeing = true;
                    this.func_70604_c(this.func_70638_az());
                    this.aggroTimer = 0;
                    return;
                }
            }
        } else if (this.blocking || this.inCombat) {
            this.inCombat = false;
            this.aggroTimer = 0;
            this.blocking = false;
            this.climbingCooldown = 0;
            this.func_70624_b(null);
            this.func_70031_b(false);
            this.canShieldPush = true;
            this.func_184602_cy();
            this.field_184628_bn = 0;
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
            this.strafeVer = 0.0f;
            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.func_70661_as().func_75499_g();
            if (this.func_184592_cb().func_77973_b() instanceof ItemPotion) {
                this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            }
            this.hasSplashPotion = 1;
            this.splashPotionTimer = 10;
            this.cannotReachTimer = 0;
        }
    }

    private void sentryTypeTank() {
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            List arrows = this.field_70170_p.func_175647_a(EntityArrow.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(8.0, 8.0, 8.0), (Predicate)new Predicate<EntityArrow>(){

                public boolean apply(@Nullable EntityArrow entity) {
                    return entity.field_70142_S == 0.0 && entity.field_70250_c == EntitySentry.this.func_70638_az();
                }
            });
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (!arrows.isEmpty()) {
                this.forwardStance(false);
                AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                this.blockingTimer = dist <= 12.0 ? 25 : 50;
                this.blocking = true;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.canShieldPush = true;
                this.func_184602_cy();
                this.func_184598_c(EnumHand.OFF_HAND);
                this.func_184608_ct();
                this.strafeVer = 0.4f;
            }
            if (!this.inCombat) {
                this.inCombat = true;
                this.func_70661_as().func_75499_g();
                this.strafeVer = 0.8f;
                this.forwardStance(false);
            }
            if (!this.blocking && !this.func_70051_ag() && dist <= 12.0 && this.blockingTimer <= -((int)((double)(this.stance * 5) + dist + 20.0)) && !(this.func_70638_az() instanceof EntityVillager)) {
                this.allStance(true);
                this.blockingTimer = (int)MathHelper.func_151237_a((double)((double)(this.field_70146_Z.nextInt(70) + 20) - dist), (double)20.0, (double)80.0);
                this.blocking = true;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                this.canShieldPush = true;
                this.func_184608_ct();
                this.func_184598_c(EnumHand.OFF_HAND);
                this.strafeVer = dist <= 6.0 ? 0.2f : 0.4f;
            } else if (this.blocking && this.blockingTimer % 16 == 0) {
                this.canShieldPush = true;
                this.strafeVer = dist <= 3.0 ? 0.2f : 0.4f;
            }
            if (this.blocking && this.blockingTimer <= 0) {
                this.blocking = false;
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
                this.allStance(true);
                this.canShieldPush = true;
                this.func_184602_cy();
            } else if (!this.blocking && dist <= 64.0 && (this.blockingTimer == -12 || this.blockingTimer == -32 || this.blockingTimer < -32 && this.blockingTimer % 14 == 0) && this.field_70146_Z.nextInt(4) == 0) {
                this.allStance(true);
            }
            if (!this.isFleeing() && !this.flanking) {
                if (!this.blocking) {
                    Vec3d vec3d;
                    float strafeMod = 1.0f;
                    if (this.stance < 5) {
                        this.func_70031_b(false);
                        if (dist <= 30.0) {
                            Vec3d velocityVector;
                            if (this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                                double push = 1.0 + 5.0 * dist;
                                this.func_70024_g(velocityVector.field_72450_a / push, -0.002, velocityVector.field_72449_c / push);
                                this.field_70133_I = true;
                            }
                            this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)0.4f);
                            this.func_70605_aq().func_188488_a(-1.0f, this.strafeHor);
                        } else {
                            this.forwardStance(true);
                            this.func_70661_as().func_75499_g();
                            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                        }
                        if (this.field_70146_Z.nextBoolean()) {
                            --this.blockingTimer;
                        }
                        return;
                    }
                    if (dist <= 2.0) {
                        this.strafeVer = 0.4f;
                    } else if (dist <= 4.0) {
                        this.strafeVer = 0.8f;
                        strafeMod = 0.9f;
                    } else if (dist <= 9.0) {
                        this.strafeVer = 0.9f;
                        strafeMod = 0.8f;
                    } else {
                        this.strafeVer = 1.0f;
                        strafeMod = 0.7f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        Vec3d velocityVector;
                        if (dist >= 12.0) {
                            --this.blockingTimer;
                        } else if (dist <= 3.0 && this.field_70122_E && !this.func_70051_ag() && this.climbingCooldown < 40 && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                        if (this.field_70163_u + 1.5 < this.func_70638_az().field_70163_u) {
                            this.func_70605_aq().func_188488_a(this.strafeVer, 0.0f);
                            if (this.field_70122_E && this.field_70146_Z.nextInt(20) == 0) {
                                this.func_70024_g(0.0, 0.38, 0.0);
                                this.field_70133_I = true;
                            }
                        } else {
                            this.func_70605_aq().func_188488_a(this.strafeVer, this.strafeHor * strafeMod);
                        }
                    } else if (this.func_70638_az().field_70122_E && !this.func_70638_az().field_70160_al && this.field_70122_E && !this.field_70160_al && !this.climbUntilPlatform && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)6, (Vec3d)this.func_70638_az().func_174791_d())) != null && this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.65)) {
                        this.forceFleeing = true;
                        this.func_70604_c(this.func_70638_az());
                        this.aggroTimer = 0;
                        return;
                    }
                } else {
                    AIHelper.faceEntitySmart((EntityLivingBase)this, this.func_70638_az());
                    if (this.strafeVer < 0.4f) {
                        Vec3d velocityVector;
                        if (!this.field_70170_p.field_72995_K && this.field_70122_E && (velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v)) != null) {
                            double push = 1.0 + dist * dist;
                            this.func_70024_g(velocityVector.field_72450_a / push, 0.0, velocityVector.field_72449_c / push);
                            this.field_70133_I = true;
                        }
                    } else if (this.strafeVer > 0.4f) {
                        this.strafeVer = 0.4f;
                    }
                    if (this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)this.strafeVer)) {
                        this.func_70605_aq().func_188488_a(this.strafeVer, this.strafeHor * 1.5f);
                    } else {
                        this.func_70605_aq().func_188488_a(this.strafeVer * 0.5f, this.strafeHor * 0.5f);
                    }
                }
            }
            --this.blockingTimer;
        } else if (this.blocking || this.inCombat) {
            this.inCombat = false;
            this.aggroTimer = 0;
            this.blocking = false;
            this.climbingCooldown = 0;
            this.func_70624_b(null);
            this.func_184602_cy();
            this.canShieldPush = true;
            this.func_70031_b(false);
            this.field_184628_bn = 0;
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
            this.strafeVer = 0.0f;
            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.func_70661_as().func_75499_g();
        }
    }

    private void sentryTypeRanged() {
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            if (!this.field_70122_E) {
                this.field_70159_w /= 2.0;
                this.field_70179_y /= 2.0;
            }
            if (!this.inCombat) {
                this.inCombat = true;
                this.func_70661_as().func_75499_g();
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() <= 0.0 && !this.func_184218_aH()) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.39 + this.field_70146_Z.nextDouble() / 50.0);
            }
        } else if (this.blocking || this.inCombat) {
            this.inCombat = false;
            this.aggroTimer = 0;
            this.blocking = false;
            this.func_70624_b(null);
            this.func_184602_cy();
            this.canShieldPush = true;
            this.func_70031_b(false);
            this.field_184628_bn = 0;
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
            this.strafeVer = 0.0f;
            this.strafeHor = 0.0f;
            this.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.func_70661_as().func_75499_g();
        }
    }

    @Override
    public boolean func_70652_k(Entity victim) {
        if (victim == null || !victim.func_70089_S() || victim.getClass().equals(((Object)((Object)this)).getClass())) {
            this.func_70624_b(null);
            return false;
        }
        this.aggroTimer = 0;
        this.attackTargetEntityWithCurrentItem(victim);
        this.func_70031_b(false);
        return true;
    }

    protected void playAttackSound() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_184185_a(SoundEvents.field_191268_hm, 1.0f, 0.9f + this.field_70146_Z.nextFloat() / 5.0f);
        }
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        this.playAttackSound();
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)this)) {
            float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float modifierForCreature = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            if (attackDamage > 0.0f || modifierForCreature > 0.0f) {
                ItemStack itemstack;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
                boolean criticalHit = this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = criticalHit = criticalHit && !this.func_70051_ag();
                if (criticalHit) {
                    attackDamage *= 1.5f;
                }
                attackDamage += modifierForCreature;
                boolean swordSweep = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (!criticalHit && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)) != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemAxe)) {
                    swordSweep = true;
                }
                float targetHealth = 0.0f;
                boolean setFireToTarget = false;
                int fireAspectModiferOfGuard = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
                if (targetEntity instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspectModiferOfGuard > 0 && !targetEntity.func_70027_ad()) {
                        setFireToTarget = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double targetMotionX = targetEntity.field_70159_w;
                double targetMotionY = targetEntity.field_70181_x;
                double targetMotionZ = targetEntity.field_70179_y;
                boolean successfulAttack = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage);
                if (successfulAttack) {
                    AIHelper.spawnSweepHit((Entity)this, targetEntity);
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (swordSweep) {
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r((Entity)entitylivingbase) || !(this.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a((Entity)this, 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
                        }
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        this.spawnSweepParticles();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = targetMotionX;
                        targetEntity.field_70181_x = targetMotionY;
                        targetEntity.field_70179_y = targetMotionZ;
                    }
                    if (criticalHit) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.onCriticalHit(targetEntity);
                    }
                    if (!criticalHit && !swordSweep) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (modifierForCreature > 0.0f) {
                        this.onEnchantmentCritical(targetEntity);
                    }
                    if (!this.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack itemstack3;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemstack2 = this.func_184614_ca();
                        ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                        if (itemstack2 != null && itemstack3 != null && itemstack3.func_77973_b() instanceof ItemShield && (itemstack2.func_77973_b() instanceof ItemAxe || itemstack2.func_77973_b().getRegistryName().toString().contains("halberd") || itemstack2.func_77973_b().getRegistryName().toString().contains("battleaxe"))) {
                            float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                            if (this.field_70146_Z.nextFloat() < f3) {
                                entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
                    ItemStack mainhandItem = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (mainhandItem != null && entity instanceof EntityLivingBase) {
                        mainhandItem.func_77973_b().func_77644_a(mainhandItem, (EntityLivingBase)entity, (EntityLivingBase)this);
                        if (mainhandItem.func_190916_E() <= 0) {
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float damageDealt = targetHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        if (fireAspectModiferOfGuard > 0) {
                            targetEntity.func_70015_d(fireAspectModiferOfGuard * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && damageDealt > 2.0f) {
                            int k = (int)((double)damageDealt * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (setFireToTarget) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    public void onCriticalHit(Entity entityHit) {
    }

    public void onEnchantmentCritical(Entity entityHit) {
    }

    public void spawnSweepParticles() {
        double d0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    public float getStrafe(int stance) {
        switch (stance) {
            case 3: {
                return -0.32f;
            }
            case 4: {
                return 0.32f;
            }
            case 5: {
                return -0.31f;
            }
            case 6: {
                return 0.31f;
            }
            case 7: {
                return -0.3f;
            }
            case 8: {
                return 0.3f;
            }
            case 9: {
                return -0.29f;
            }
            case 10: {
                return 0.29f;
            }
        }
        return 0.0f;
    }

    public boolean collidedHorizontallyWide(double d) {
        try {
            IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + 0.6, d, this.field_70161_v));
            if (block.func_185917_h()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d, this.field_70161_v + 0.6));
            if (block.func_185917_h()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t - 0.6, d, this.field_70161_v));
            if (block.func_185917_h()) {
                return true;
            }
            block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d, this.field_70161_v - 0.6));
            if (block.func_185917_h()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean collidedVerticallySmart(double d) {
        try {
            IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, d, this.field_70161_v));
            if (block.func_185917_h()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void doClimbing(boolean backwards) {
        if (this.climbingTimer < 250 && !(this.func_184614_ca().func_77973_b() instanceof ItemBow) && (this.func_70638_az().field_70163_u - 1.0 > this.field_70163_u || this.climbUntilPlatform)) {
            this.climbUntilPlatform = true;
            if (!backwards && this.field_70181_x < 0.0012) {
                this.climbingTimer += 30;
            }
            ++this.climbingTimer;
            this.aggroTimer = 0;
            if (backwards) {
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                Vec3d velocityVector = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, 0.0, this.field_70161_v - this.func_70638_az().field_70161_v);
                if (velocityVector != null) {
                    double push = 8.0 + this.func_70068_e((Entity)this.func_70638_az());
                    this.field_70159_w = velocityVector.field_72450_a / push;
                    this.field_70179_y = velocityVector.field_72449_c / push;
                    if (this.field_70181_x < (double)0.3f) {
                        this.field_70181_x = 0.3f;
                    }
                    this.field_70133_I = true;
                }
            } else {
                this.func_70605_aq().func_188488_a(0.0f, 0.0f);
                Vec3d velocityVector = new Vec3d(this.func_70638_az().field_70165_t - this.field_70165_t, 0.0, this.func_70638_az().field_70161_v - this.field_70161_v);
                if (velocityVector != null) {
                    this.field_70159_w = velocityVector.field_72450_a;
                    this.field_70179_y = velocityVector.field_72449_c;
                    this.field_70133_I = true;
                }
            }
            this.blockingTimer = 20;
            this.setBesideClimbableBlock(true);
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
        } else {
            this.endClimbing();
        }
    }

    private void endClimbing() {
        this.climbUntilPlatform = false;
        if (this.climbingTimer > 40) {
            this.climbingCooldown = 40;
        }
        this.climbingTimer = 0;
        this.setBesideClimbableBlock(false);
        if (!this.blocking && this.field_70122_E) {
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)ToroQuestConfiguration.banditAndOrcKnockBackResistance);
        }
    }

    protected void func_85033_bc() {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.func_184212_Q().func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.func_184212_Q().func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.func_184212_Q().func_187227_b(CLIMBING, (Object)b0);
    }

    public void addEquipment() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int weapon = this.field_70146_Z.nextInt(3);
        if (weapon == 0) {
            if (this.field_70146_Z.nextBoolean()) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditTwoHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditTwoHandedMeleeWeapons.length)]), 1);
                if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.banditBaseHealth) {
                    this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditTwoHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditTwoHandedMeleeWeaponsPowerful.length)]), 1);
                }
                if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                    this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151040_l, 1) : new ItemStack(Items.field_151036_c, 1);
                }
                if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                    String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                        enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                        this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    }
                }
            } else {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditOneHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditOneHandedMeleeWeapons.length)]), 1);
                if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.banditBaseHealth) {
                    this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditOneHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditOneHandedMeleeWeaponsPowerful.length)]), 1);
                }
                if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                    this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151040_l, 1) : new ItemStack(Items.field_151036_c, 1);
                }
                if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                    String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                        enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                        this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                    }
                }
                this.weaponOff = this.weaponMain.func_77946_l();
            }
        } else if (weapon == 1) {
            String[] enchant;
            this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditOneHandedMeleeWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditOneHandedMeleeWeapons.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.banditBaseHealth) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditOneHandedMeleeWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditOneHandedMeleeWeaponsPowerful.length)]), 1);
            }
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                this.weaponMain = this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151040_l, 1) : new ItemStack(Items.field_151036_c, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcMeleeWeapon.length)].split(",");
                this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                    enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcMeleeWeapon.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                }
            }
            this.weaponOff = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditShields[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditShields.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.banditBaseHealth) {
                this.weaponOff = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditShieldsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditShieldsPowerful.length)]), 1);
            }
            if (this.weaponOff == null || this.weaponOff.func_190926_b()) {
                this.weaponOff = new ItemStack(Items.field_185159_cQ, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcShield[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcShield.length)].split(",");
                this.weaponOff.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
            }
        } else if (weapon == 2) {
            this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditRangedWeapons[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditRangedWeapons.length)]), 1);
            if (this.field_70146_Z.nextInt((int)this.func_110138_aP()) > ToroQuestConfiguration.banditBaseHealth) {
                this.weaponMain = new ItemStack(Item.func_111206_d((String)ToroQuestConfiguration.banditRangedWeaponsPowerful[this.field_70146_Z.nextInt(ToroQuestConfiguration.banditRangedWeaponsPowerful.length)]), 1);
            }
            if (this.weaponMain == null || this.weaponMain.func_190926_b()) {
                this.weaponMain = new ItemStack((Item)Items.field_151031_f, 1);
            }
            if (ToroQuestConfiguration.enchantFirstBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantFirstBanditAndOrcChance) {
                String[] enchant = ToroQuestConfiguration.enchantFirstBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantFirstBanditAndOrcRanged.length)].split(",");
                this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                if (ToroQuestConfiguration.enchantSecondBanditAndOrcChance > 0 && this.field_70146_Z.nextInt(100) < ToroQuestConfiguration.enchantSecondBanditAndOrcChance) {
                    enchant = ToroQuestConfiguration.enchantSecondBanditAndOrcRanged[this.field_70146_Z.nextInt(ToroQuestConfiguration.enchantSecondBanditAndOrcRanged.length)].split(",");
                    this.weaponMain.func_77966_a(Enchantment.func_180305_b((String)enchant[0]), this.field_70146_Z.nextInt(Integer.parseInt(enchant[1])) + 1);
                }
            }
        }
        if (this.weaponMain != null && !this.weaponMain.func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, this.weaponMain);
        } else {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (this.weaponOff != null && !this.weaponOff.func_190926_b()) {
            this.func_184611_a(EnumHand.OFF_HAND, this.weaponOff);
        } else {
            this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        }
        this.addMask();
        if (ToroQuestConfiguration.banditsHaveArmorForSpartanWeaponry) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151027_R, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T, 1));
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ToroQuestConfiguration.banditAttackDamage);
    }

    public void addMask() {
        if (ToroQuestConfiguration.renderBanditMask) {
            ItemStack head = new ItemStack(Item.func_111206_d((String)"toroquest:bandit_helmet"), 1);
            this.func_184201_a(EntityEquipmentSlot.HEAD, head);
        }
    }

    public void func_70624_b(EntityLivingBase e) {
        if (e == null || !e.func_70089_S() || e.getClass().equals(((Object)((Object)this)).getClass())) {
            this.func_70031_b(false);
            super.func_70624_b(null);
            return;
        }
        super.func_70624_b(e);
    }

    @Override
    protected void callForHelp(EntityLivingBase attacker) {
        if (attacker == null || !attacker.func_70089_S()) {
            return;
        }
        List help = this.field_70170_p.func_175647_a(EntitySentry.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 12.0, 20.0), (Predicate)new Predicate<EntitySentry>(){

            public boolean apply(@Nullable EntitySentry entity) {
                return true;
            }
        });
        for (EntitySentry entity : help) {
            if (entity instanceof EntityOrc || entity.getBribed() || entity.func_70638_az() != null) continue;
            entity.func_70624_b(attacker);
        }
    }

    public boolean isEntityInsideOpaqueBlock(EntityBoat b) {
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(b.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)b.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(b.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * b.field_70130_N * 1.2f)));
            int l = MathHelper.func_76128_c((double)(b.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * b.field_70130_N * 1.2f)));
            if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
            blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
            if (!b.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_191058_s()) continue;
            blockpos$pooledmutableblockpos.func_185344_t();
            return true;
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    @Nullable
    public Team func_96124_cp() {
        return null;
    }

    public boolean func_184191_r(Entity entityIn) {
        return false;
    }

    public boolean func_184194_a(Team teamIn) {
        return false;
    }

    static {
        if (ToroQuestConfiguration.specificEntityNames) {
            NAME = "toroquest_" + NAME;
        }
    }
}

